/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gz9
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    public class FlashTest extends Sprite {
        
        private static const M:int = 256;
        private static const N:int = 256;
        private static const BASE:Number = 32;
        private static const OCTAVES:int = 3;
        private static const ORIGIN:Point = new Point(232.5, 400);
        private static const RISE:Point = new Point(0, -300);
        private static const E_1:Number = Math.E - 1;
        
        private const points:Vector.<Point> = new Vector.<Point>(M, true);
        private const bd:BitmapData = new BitmapData(N, 1, false, 0x000000);
        private const offsets:Array = new Array(OCTAVES);
        private var seed:int;
        private var pos:int;
        
        public function FlashTest() {
            stage.frameRate = 60;
            seed = Math.random() * 0x1000000;
            var i:int;
            for (i = 0; i < M; i++) points[i] = ORIGIN.clone();
            for (i = 0; i < OCTAVES; i++) offsets[i] = new Point(0, BASE / 2);
            for (i = 0; i < M - 1; i++) fetch(i);
            pos = M;
            draw();
            addEventListener(Event.ENTER_FRAME, frame);
        }
        
        private function refresh():void {
            bd.perlinNoise(BASE, BASE, OCTAVES, seed, true, true, 6, false, offsets);
            for each (var p:Point in offsets) p.x += N;
        }
        
        private function frame(e:Event):void {
            fetch(pos - 1);
            draw();
            pos++;
        }
        
        private function fetch(i:int):void {
            if (i % N == 0) refresh();
            var c:uint = bd.getPixel(i % N, 0);
            var p:Point = points[i % M];
            p.x = Number(c & 0xff) / 255 * 400 - 200;
            p.y = Number(c >> 8 & 0xff) / 255 * 200 - 100;
        }
        
        private function draw():void {
            graphics.clear();
            graphics.moveTo(ORIGIN.x, ORIGIN.y);
            for (var i:int = pos - 1; i >= pos - M; i--) {
                var t:Number = Number(pos - i) / M;
                var u:Number = t * 0.8 + 0.2;
                u = (u * u - 0.04) / 0.96;
                var v:Number = Math.log(E_1 * t + 1);
                var w:Number = (0.2 / Math.max(u, 0.2) - 0.2) / 0.8;
                var p:Point = points[i % M];
                var x:Number = ORIGIN.x + p.x * u + RISE.x * v;
                var y:Number = ORIGIN.y + p.y * u + RISE.y * v;
                graphics.lineStyle(0, 0x000000, w);
                graphics.lineTo(x, y);
            }
        }
        
    }
}