/**
 * Copyright faunus ( http://wonderfl.net/user/faunus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7ggc
 */

// forked from rsakane's Charts
package
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import com.bit101.components.ComboBox;
    
    public class Main extends Sprite
    {
        private var canvas:Sprite;
        private var tf:TextField;
        
        public function Main()
        {
            Wonderfl.capture_delay(15);
            
            graphics.beginFill(0xF4F5F0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            canvas = new Sprite();
            addChild(canvas);
            
            tf = Utils.createTextField("コンボボックスからグラフを選択");
            tf.y = 420;
            addChild(tf);
            
            var box:ComboBox = new ComboBox(this, 0, 280, "Charts");
            box.height = box.height * 2;
            box.numVisibleItems += 1;
            box.addEventListener(Event.SELECT, onSelect);
            box.addItem("Bar Chart");
            box.addItem("Bar Chart 3D");
            box.addItem("Line Chart");
            box.addItem("Area Chart");
            box.addItem("Area Chart 2");
            box.addItem("Pie Chart");
            box.addItem("Doughnut Chart");
        }
        
        private function onSelect(event:Event):void
        {
            while (canvas.numChildren) canvas.removeChildAt(0);
            
            var data1:Array = [];
            var data2:Array = [];
            var data3:Array = [];
            
            var width:int = 400, height:int = 200;
            var numX:int, numY:int, minY:Number, maxY:Number, chart:*;
            var box:ComboBox = event.currentTarget as ComboBox;
            if (box.selectedItem == "Bar Chart")
            {
                numX = 3, numY = 5, minY = 0, maxY = 1000;
                initArray([data1, data2, data3], numX, minY, maxY);
                chart = new BarChart( { fixed:1, color:[0xFF9900, 0x008000, 0x009AD6], key:["AAA", "BBB", "CCC"], data:[data1, data2, data3], labelX:["2008", "2009", "2010"], minY:minY, maxY:maxY, numX:numX, numY:numY, width:width, height:height } );
                chart.x = 60;
                chart.y = 30;
                canvas.addChild(chart);
                
                tf.text = "矩形部分にポインタをあてると値表示";
            }
            else if (box.selectedItem == "Bar Chart 3D")
            {
                numX = 2, numY = 5, minY = 0, maxY = 1000;
                initArray([data1, data2, data3], numX, minY, maxY);
                chart = new BarChart3D( { rotate:-30, fixed:1, color:[0xFF9900, 0x008000, 0x009AD6], key:["AAA", "BBB", "CCC"], data:[data1, data2, data3], labelX:["2008", "2009"], minY:minY, maxY:maxY, numX:numX, numY:numY, width:width, height:height } );
                chart.x = 60;
                chart.y = 30;
                canvas.addChild(chart);
                
                tf.text = "矩形部分にポインタをあてると値表示";
            }
            else if (box.selectedItem == "Line Chart")
            {
                numX = 7, numY = 5, minY = -100, maxY = 1000;
                initArray([data1, data2, data3], numX, minY, maxY);
                chart = new LineChart( { fixed:1, color:[0xFF9900, 0x008000, 0x009AD6], key:["AAA", "BBB", "CCC"], data:[data1, data2, data3], labelX:["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], minY:minY, maxY:maxY, numX:numX, numY:numY, width:width, height:height } );
                chart.x = 45;
                chart.y = 30;
                canvas.addChild(chart);
                
                tf.text = "関節部分にポインタをあてると値表示";
            }
            else if (box.selectedItem == "Area Chart")
            {
                numX = 7, numY = 5, minY = 0, maxY = 1000;
                initArray([data1], numX, minY, maxY);
                chart = new AreaChart( { fixed:1, color:[0xED1A3D], labelX:["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], key:["AAA", "BBB", "CCC"], numX:numX, numY:numY, maxY:maxY, minY:minY, data:[data1], width:width, height:height } );
                chart.x = 45;
                chart.y = 30;
                canvas.addChild(chart);
                
                tf.text = "頂点部分にポインタをあてると値表示";
            }
            else if (box.selectedItem == "Area Chart 2")
            {
                numX = 7, numY = 3, minY = 0, maxY = 2400;
                initArray([data1, data2, data3], numX, minY, maxY / 3);
                chart = new AreaChart2( { fixed:1, color:[0xED1A3D, 0x008000, 0x009AD6], labelX:["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], key:["AAA", "BBB", "CCC"], numX:numX, numY:numY, maxY:maxY, minY:minY, data:[data1, data2, data3], width:width, height:height } );
                chart.x = 45;
                chart.y = 30;
                canvas.addChild(chart);
                
                tf.text = "頂点部分にポインタをあてると値表示";
            }
            else if (box.selectedItem == "Pie Chart")
            {
                initArray([data1], 5, 0, 800);
                chart = new PieChart( { fixed:1, key:["AAA", "BBB", "CCC", "DDD", "EEE"], data:data1, radius:150, color:[0xED1A3D, 0x008000, 0x009AD6, 0xF8ABA6, 0xF39800] } );
                chart.x = 232;
                chart.y = 232;
                canvas.addChild(chart);
                
                tf.text = "弧にポインタをあてると値, 割合表示\n弧をクリックすると開閉";
            }
            else if (box.selectedItem == "Doughnut Chart")
            {
                var oR:Number = 150, iR:Number = 70;
                initArray([data1], 5, 0, 800);
                chart = new DoughnutChart( { key:["AAA", "BBB", "CCC", "DDD", "EEE"], data:data1, outerRadius:oR, innerRadius:iR, color:[0xED1A3D, 0x008000, 0x009AD6, 0xF8ABA6, 0xF39800] } );
                chart.x = 232;
                chart.y = 232;
                canvas.addChild(chart);
                
                tf.text = "弧にポインタをあてると値, 割合表示\n弧をクリックすると開閉";
            }
        }
        
        private function initArray(data:Array, numX:int, minY:Number, maxY:Number):void
        {
            for (var i:int = 0; i < numX; i++)
            {
                for (var j:int = 0; j < data.length; j++)
                {
                    data[j].push((maxY - minY) * Math.random() + minY);
                }
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFormat;
import frocessing.color.ColorHSV;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;

class Shape extends Sprite
{
    public static var popup:Sprite;
    private var num:Number;
    private var tf:TextField;
    private var container:Sprite;
    
    public function Shape(container:Sprite, message:String)
    {        
        if (popup == null)
        {
            popup = new Sprite();
            popup.mouseEnabled = false;
            popup.filters = [new DropShadowFilter(1)];
        }
        
        this.container = container;
        this.num = num;
        
        tf = Utils.createTextField(message);
        
        addEventListener(MouseEvent.MOUSE_MOVE, onMouseOver);
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
    }
    
    private function onMouseOut(event:MouseEvent):void 
    {
        popup.visible = false;
    }
    
    private function onMouseOver(event:MouseEvent):void 
    {
        container.addChildAt(popup, container.numChildren - 1);
        if (popup.numChildren)
        {
            popup.removeChild(popup.getChildAt(0));
        }
        popup.graphics.clear();
        
        popup.visible = true;
        popup.graphics.lineStyle(1.0);
        popup.graphics.beginFill(0xFFFFFF);
        popup.graphics.drawRoundRect(0, 0, tf.width + 5, 15, 5, 5);
        popup.graphics.endFill();
        popup.addChild(tf);
        
        tf.x = (popup.width - tf.width) / 2;
        tf.y = (popup.height - tf.height) / 2 - 2;
        
        var point:Point = globalToLocal(new Point(mouseX, mouseY))
        popup.y = event.stageY - container.y - popup.height;
        popup.x = event.stageX - container.x - popup.width / 2;
    }
}

class Utils
{    
    public static function getRect(container:Sprite, width:Number, height:Number, message:String, color:int):Sprite
    {
        var shape:Shape = new Shape(container, message);        
        shape.graphics.beginFill(color);
        shape.graphics.drawRect(0, 0, width, -height);
        shape.graphics.endFill();
        shape.filters = [new DropShadowFilter(1, 0)];
        
        return shape;
    }
    
    public static function getRect3D(container:Sprite, width:Number, height:Number, rotate:Number, message:String, color:int):Sprite
    {
        var hsv:ColorHSV = new ColorHSV();
        hsv.value = color;
        hsv.v -= 0.15;
        
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(width, -height, -90 * Math.PI / 180);
        var shape:Shape = new Shape(container, message);        
        shape.graphics.beginGradientFill("linear", [color, hsv.value], [1.0, 1.0], [0, 255], matrix);
        shape.graphics.drawRect(0, 0, width, -height);
        shape.graphics.endFill();
        
        var size:Number = width * 0.5;
        var tx:Number = Math.cos(rotate * Math.PI / 180) * size;
        var ty:Number = -height + Math.sin(rotate * Math.PI / 180) * size;
        
        matrix = new Matrix();
        matrix.createGradientBox(width + Math.cos(rotate) * 15, Math.sin(rotate * Math.PI / 180) * size, 180 * Math.PI/ 180, 0, -height);
        shape.graphics.beginGradientFill("linear", [color, hsv.value], [1.0, 1.0], [0, 255], matrix);
        shape.graphics.moveTo(0, -height);
        shape.graphics.lineTo(tx, ty);
        shape.graphics.lineTo(tx + width, ty);
        shape.graphics.lineTo(width, -height);
        shape.graphics.lineTo(0, -height);
        shape.graphics.endFill();
        
        hsv.v -= 0.15;
        matrix = new Matrix();
        shape.graphics.beginFill(hsv.value);
        shape.graphics.moveTo(width, -height);
        shape.graphics.lineTo(tx + width, ty);
        shape.graphics.lineTo(tx + width, ty + height);
        shape.graphics.lineTo(width, 0);
        shape.graphics.endFill();
        shape.filters = [new DropShadowFilter(1, 0, 0x777777)];
        
        return shape;
    }
    
    public static function getCircle(container:Sprite, radius:Number, message:String, color:int, alpha:Number = 1.0, line:Boolean = true, filter:Boolean = true):Sprite
    {
        var shape:Shape = new Shape(container, message);
        if (line) shape.graphics.lineStyle(1.0, color);
        shape.graphics.beginFill(0xFFFFFF, alpha);
        shape.graphics.drawCircle(0, 0, radius);
        shape.graphics.endFill();
        if (filter) shape.filters = [new DropShadowFilter(1, 0)];
        
        return shape;
    }
    
    public static function getShape(container:Sprite, message:String):Sprite
    {
        var shape:Shape = new Shape(container, message);
        return shape;
    }
    
    public static function textToBitmap(text:String):Bitmap
    {
        var tf:TextField = createTextField(text);
        
        var bd:BitmapData = new BitmapData(tf.width, tf.height, true, 0x0);
        bd.draw(tf);
        
        return new Bitmap(bd);
    }
    
    public static function createTextField(text:String):TextField
    {
        var tf:TextField = new TextField();
        tf.defaultTextFormat = new TextFormat("_typeWriter", 15, 0x0);
        tf.autoSize = "left";
        tf.text = text;
        tf.selectable = false;
        
        return tf;
    }
    
    public static function toFixed(data:Array, p:Number = 0):void
    {
        var y:int;
        var x:int;
        if (data[0] is Array)
        {
            for (y = 0; y < data.length; y++)
            {
                for (x = 0; x < data[y].length; x++)
                {
                    if (data[y][x].toString().indexOf(".") != -1)
                    {
                        data[y][x] = Number(Number(data[y][x]).toFixed(p));
                    }
                }
            }
        }
        else
        {
            for (x = 0; x < data.length; x++)
            {
                if (data[x].toString().indexOf(".") != -1)
                {
                    data[x] = Number(Number(data[x]).toFixed(p));
                }
            }
        }
    }
    
    public static function createBackground(graphics:Graphics, p:Object, colors:Array = null):void
    {
        graphics.lineStyle(1.0, 0xAAAAAA);
        for (var i:int = 0; i < p.numY; i++)
        {
            graphics.moveTo(0, p.height / p.numY * i);
            graphics.lineTo(p.width, p.height / p.numY * i);
        }
        
        if (colors)
        {
            for (i = 0; i < p.numY; i++)
            {
                var color:int = (i % 2) ? colors[0] : colors[1];
                graphics.beginFill(color);
                graphics.drawRect(0, p.height / p.numY * i, p.width, p.height / p.numY);
                graphics.endFill();
            }
        }
        
        graphics.lineStyle(3.0);
        graphics.drawRect(0, 0, p.width, p.height);
        graphics.endFill();
        graphics.lineStyle();
    }
    
    public static function createBackground3D(graphics:Graphics, p:Object, colors:Array, width:Number):void
    {
        var ty:Number = Math.sin((180 + p.rotate) * Math.PI / 180) * width * 0.5;
        var tx:Number = Math.cos((180 + p.rotate) * Math.PI / 180) * width * 0.5;
        
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(p.width, p.height - ty, 45 * Math.PI / 180, 0, -p.height);
        graphics.beginGradientFill("linear", colors, [1.0, 1.0], [0, 255], matrix);
        graphics.drawRect(0, 0, p.width, p.height - ty);
        graphics.endFill();
        
        graphics.lineStyle(1.0, 0xAAAAAA);
        for (var i:int = 0; i < p.numY; i++)
        {
            graphics.moveTo(0, p.height / p.numY * i);
            graphics.lineTo(p.width, p.height / p.numY * i);
        }
        
        matrix = new Matrix();
        matrix.createGradientBox(p.width + tx * 2, ty, 0, -tx, p.height - ty);
        graphics.beginGradientFill("linear", colors, [1.0, 1.0], [0, 255], matrix);
        graphics.moveTo(0, p.height - ty);
        graphics.lineTo(p.width, p.height - ty);
        graphics.lineTo(p.width + tx, p.height);
        graphics.lineTo(tx, p.height);
        graphics.lineTo(0, p.height - ty);
        graphics.endFill();
        
        matrix.createGradientBox(p.width, 10, -90 * Math.PI / 180, -tx, p.height);
        graphics.beginGradientFill("linear", colors, [1.0, 1.0], [0, 255], matrix);
        graphics.drawRect(tx, p.height, p.width, 10);
        graphics.endFill();
        
        var hsv:ColorHSV = new ColorHSV();
        hsv.value = colors[0];
        hsv.v -= 0.2;
        
        graphics.beginFill(hsv.value);
        graphics.moveTo(p.width, p.height - ty);
        graphics.lineTo(p.width, p.height - ty + 10);
        graphics.lineTo(p.width + tx, p.height + 10);
        graphics.lineTo(p.width + tx, p.height);
        graphics.endFill();
    }
    
    public static function drawPie(s:Sprite, radius:Number, degreeA:Number, degreeB:Number, color:int):void
    {
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius * 2, radius * 2, 0, -radius, -radius);
        
        var hsv:ColorHSV = new ColorHSV();
        var hsv2:ColorHSV = new ColorHSV();
        hsv.value = hsv2.value = color;
        hsv.v -= 0.15;
        hsv2.v -= 0.3;
        
        s.graphics.beginGradientFill("radial", [color, hsv.value, hsv2.value], [1.0, 1.0, 1.0], [0, 240, 255], matrix);
        s.graphics.lineTo(Math.cos(degreeA * Math.PI / 180) * radius, Math.sin(degreeA * Math.PI / 180) * radius);
        
        drawArc(s.graphics, radius, degreeA, degreeB);
        s.graphics.lineTo(0, 0);
        s.graphics.endFill();
    }
    
    public static function drawDoughnut(s:Sprite, innerRadius:Number, outerRadius:Number, degreeA:Number, degreeB:Number, color:int):void
    {
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(outerRadius * 2, outerRadius * 2, 0, -outerRadius, -outerRadius);
        
        var hsv:ColorHSV = new ColorHSV();
        var hsv2:ColorHSV = new ColorHSV();
        hsv.value = hsv2.value = color;
        hsv.v -= 0.15;
        hsv2.v -= 0.3;
        
        s.graphics.beginGradientFill("radial", [color, hsv.value, hsv2.value], [1.0, 1.0, 1.0], [0, 240, 255], matrix);
        s.graphics.moveTo(Math.cos(degreeA * Math.PI / 180) * innerRadius, Math.sin(degreeA * Math.PI / 180) * innerRadius);
        s.graphics.lineTo(Math.cos(degreeA * Math.PI / 180) * outerRadius, Math.sin(degreeA * Math.PI / 180) * outerRadius);
        drawArc(s.graphics, outerRadius, degreeA, degreeB);
        s.graphics.moveTo(Math.cos(degreeA * Math.PI / 180) * innerRadius, Math.sin(degreeA * Math.PI / 180) * innerRadius);
        drawArc(s.graphics, innerRadius, degreeA, degreeB);
        s.graphics.lineTo(Math.cos(degreeB * Math.PI / 180) * outerRadius, Math.sin(degreeB * Math.PI / 180) * outerRadius);
    }
    
    public static function drawArc(graphics:Graphics, radius:Number, degreeA:Number, degreeB:Number):void
    {
        var end:Boolean = false;
        while (!end)
        {
            var d1:Number = degreeA;
            var d2:Number = degreeA;
            if (d1 + 45 < degreeB) d2 = d1 + 45;
            else d2 += degreeB - d1, end = true;
            degreeA = d2;
            
            var radianA:Number = d1 * Math.PI / 180;
            var radianB:Number = d2 * Math.PI / 180;
            
            var x1:Number = Math.cos(radianA) * radius;
            var y1:Number = Math.sin(radianA) * radius;
            var x2:Number = Math.cos(radianB) * radius;
            var y2:Number = Math.sin(radianB) * radius;
            
            var radian:Number = (radianB - radianA) / 2;
            var length:Number = radius / Math.cos(radian);
            
            var cx:Number = Math.cos(radianA + radian) * length;
            var cy:Number = Math.sin(radianA + radian) * length;
            
            graphics.curveTo(cx, cy, x2, y2);
        }
    }
}

class DoughnutChart extends Sprite
{
    private var t:ITween;
    
    public function DoughnutChart(p:Object):void
    {
        Utils.toFixed(p.data, p.fixed);
        p.data.sort(Array.NUMERIC | Array.DESCENDING);
        var ratio:Array = [0];
        var sum:Number = 0;
        for (var i:int = 0; i < p.data.length; i++) sum += p.data[i];
        for (i = 0; i < p.data.length; i++) ratio[i + 1] = p.data[i] / sum * 360;
        
        var degree:Number = 0;
        for (i = 1; i < ratio.length; i++)
        {
            degree += ratio[i - 1];
            var c:Shape = new Shape(this, p.data[i - 1] + " (" + Number(p.data[i - 1] / sum * 100).toFixed(2) + "%)");
            Utils.drawDoughnut(c, p.innerRadius, p.outerRadius, degree, degree + ratio[i], p.color[i - 1]);
            c.name = String((degree + degree + ratio[i]) / 2);
            c.rotation -= (90 + degree);
            c.addEventListener(MouseEvent.CLICK, onMouseClick);
            addChildAt(c, 0);
            
            var message:String = (p.key[i - 1] == undefined) ? "" : p.key[i - 1]
            var bitmap:Bitmap = Utils.textToBitmap(message);
            bitmap.x = -bitmap.width / 2;
            bitmap.y = -bitmap.height / 2;
            bitmap.x += Math.cos(((degree + degree + ratio[i]) / 2) * Math.PI / 180) * p.outerRadius * 1.2;
            bitmap.y += Math.sin(((degree + degree + ratio[i]) / 2) * Math.PI / 180) * p.outerRadius * 1.2;
            bitmap.alpha = 0;
            c.addChild(bitmap);
            
            BetweenAS3.serial
            (
                BetweenAS3.tween(c, { rotation: 0 }, null, 1.5),
                BetweenAS3.tween(bitmap, { alpha:1.0 } )
            ).play();
        }
    }
    
    private function onMouseClick(event:MouseEvent):void
    {
        if (t != null && t.isPlaying) return;
        
        var s:Sprite = event.currentTarget as Sprite;
        var tx:Number = Math.cos(Number(s.name) * Math.PI / 180) * 20;
        var ty:Number = Math.sin(Number(s.name) * Math.PI / 180) * 20;
        
        if (s.x == 0) t = BetweenAS3.tween(s, { $x:tx, $y:ty }, null, 0.2);
        else t = BetweenAS3.tween(s, { x:0, y:0 }, null, 0.2);
        t.play();
    }
}

class PieChart extends Sprite
{
    private var t:ITween;
    
    public function PieChart(p:Object)
    {
        Utils.toFixed(p.data, p.fixed);
        p.data.sort(Array.NUMERIC | Array.DESCENDING);
        var ratio:Array = [0];
        var sum:Number = 0;
        for (var i:int = 0; i < p.data.length; i++) sum += p.data[i];
        for (i = 0; i < p.data.length; i++) ratio[i + 1] = p.data[i] / sum * 360;
        
        var degree:Number = 0;
        for (i = 1; i < ratio.length; i++)
        {
            degree += ratio[i - 1];
            var c:Shape = new Shape(this, p.data[i - 1] + " (" + Number(p.data[i - 1] / sum * 100).toFixed(2) + "%)");
            Utils.drawPie(c, p.radius, degree, degree + ratio[i], p.color[i - 1]);
            c.name = String((degree + degree + ratio[i]) / 2);
            c.rotation -= (90 + degree);
            c.addEventListener(MouseEvent.CLICK, onMouseClick);
            addChildAt(c, 0);
            
            var message:String = (p.key[i - 1] == undefined) ? "" : p.key[i - 1]
            var bitmap:Bitmap = Utils.textToBitmap(message);
            bitmap.x = -bitmap.width / 2;
            bitmap.y = -bitmap.height / 2;
            bitmap.x += Math.cos(((degree + degree + ratio[i]) / 2) * Math.PI / 180) * p.radius * 1.2;
            bitmap.y += Math.sin(((degree + degree + ratio[i]) / 2) * Math.PI / 180) * p.radius * 1.2;
            bitmap.alpha = 0;
            c.addChild(bitmap);
            
            BetweenAS3.serial
            (
                BetweenAS3.tween(c, { rotation: 0 }, null, 1.5),
                BetweenAS3.tween(bitmap, { alpha:1.0 } )
            ).play();
        }
    }
    
    private function onMouseClick(event:MouseEvent):void
    {
        if (t != null && t.isPlaying) return;
        
        var s:Sprite = event.currentTarget as Sprite;
        var tx:Number = Math.cos(Number(s.name) * Math.PI / 180) * 20;
        var ty:Number = Math.sin(Number(s.name) * Math.PI / 180) * 20;
        
        if (s.x == 0) t = BetweenAS3.tween(s, { $x:tx, $y:ty }, null, 0.2);
        else t = BetweenAS3.tween(s, { x:0, y:0 }, null, 0.2);
        t.play();
    }
}

class AreaChart2 extends Sprite
{
    public function AreaChart2(p:Object)
    {
        Utils.createBackground(graphics, p, [0xFFFFFF, 0xF4F5F0]);
        Utils.toFixed(p.data, p.fixed);
        
        var prev:Array = new Array(p.numX).map(function(...a):* { return 0; } );
        var pr:Number = 0;
        for (var i:int = 0; i < p.data.length; i++)
        {        
            if (p.key && p.key[i] != undefined)
            {
                graphics.beginFill(p.color[i]);
                graphics.drawRect(pr + 5, -14, 15, 3);
                graphics.endFill();
                
                var tf:TextField = Utils.createTextField(p.key[i]);
                tf.x = pr + 20;
                tf.y = -14 - tf.height / 2;
                addChild(tf);
                pr = tf.x + tf.width;
            }
            
            var panel:Sprite = new Sprite();
            addChildAt(panel, 0);
            
            var min:Number = int.MAX_VALUE;
            var data:Array = [];
            for (var j:int = 0; j < p.data[i].length; j++)
            {
                var ty:Number = p.height * ((p.maxY - (p.data[i][j] + prev[j])) / (p.maxY - p.minY));
                prev[j] += p.data[i][j];
                
                var c:Sprite = Utils.getCircle(this, 5, p.data[i][j], 0x0, 0.0, false, false);
                c.x = p.width / (p.numX - 1) * j;
                c.y = ty;
                if (min > ty) min = ty;
                addChild(c);
                data.push(c);
            }
            
            panel.y = p.height;
            
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(p.width, -(p.height - ty), 90 * Math.PI / 180);
            
            var color:ColorHSV = new ColorHSV();
            color.value = p.color[i];
            color.v -= 0.3;
            
            panel.graphics.beginGradientFill("linear", [color.value, p.color[i]], [1.0, 1.0], [0, 255], matrix);
            panel.graphics.moveTo(data[0].x, data[0].y - p.height);
            
            for (j = 0; j < data.length; j++)
            {
                panel.graphics.lineTo(data[j].x, data[j].y - p.height);
            }
            panel.graphics.lineTo(data[j - 1].x, 0);
            panel.graphics.lineTo(0, 0);
            panel.graphics.endFill();
            
            BetweenAS3.tween(panel, { scaleY:1.0 }, { scaleY:0 } ).play();
        }
        
        var frame:Sprite = new Sprite();
        frame.graphics.lineStyle(3.0);
        frame.graphics.drawRect(0, 0, p.width, p.height);
        addChild(frame);
        
        for (i = 0; i < p.numX; i++)
        {
            if (p.labelX != null && p.labelX[i] != undefined)
            {
                var text:TextField = Utils.createTextField(p.labelX[i]);
                text.x = p.width / (p.numX - 1) * i - text.width / 2;
                text.y = p.height;
                addChild(text);
            }
        } 
        
        for (i = 0; i <= p.numY; i++)
        {
            var num:Number = Math.abs(p.maxY - p.minY) / p.numY * i + p.minY;
            num = (num.toString().indexOf(".") == -1) ? num : Number(num.toFixed(p.fixed));
            var labelY:TextField = Utils.createTextField(num.toString());
            labelY.x = -labelY.width;
            labelY.y = p.height / p.numY * (p.numY - i) - labelY.height / 2;
            addChild(labelY);
        }
    }
}

class AreaChart extends Sprite
{
    public function AreaChart(p:Object)
    {
        Utils.createBackground(graphics, p, [0xFFFFFF, 0xF4F5F0]);
        Utils.toFixed(p.data, p.fixed);
        
        var pr:Number = 0;
        for (var i:int = 0; i < p.data.length; i++)
        {        
            if (p.key && p.key[i] != undefined)
            {
                graphics.beginFill(p.color[i]);
                graphics.drawRect(pr + 5, -14, 15, 3);
                graphics.endFill();
                
                var tf:TextField = Utils.createTextField(p.key[i]);
                tf.x = pr + 20;
                tf.y = -14 - tf.height / 2;
                addChild(tf);
                pr = tf.x + tf.width;
            }
            
            var panel:Sprite = new Sprite();
            panel.filters = [new DropShadowFilter(1, 45, 0xDBF3D3)];
            addChild(panel);
            
            var data:Array = [];
            for (var j:int = 0; j < p.data[i].length; j++)
            {
                var ty:Number = p.height * ((p.maxY - p.data[i][j]) / (p.maxY - p.minY));
                
                var c:Sprite = Utils.getCircle(this, 5, p.data[i][j], 0x0, 0.0, false, false);
                c.x = p.width / (p.numX - 1) * j;
                c.y = ty;
                panel.addChild(c);
                data.push(c);
                
                var t:ITween = BetweenAS3.tween(c, { y:c.y }, { y:p.height / 2 } );
                if (j == p.data[i].length - 1)
                {
                    t.onUpdate = function(color:int, panel:Sprite, data:Array):void
                    {
                        panel.graphics.clear();
                        panel.graphics.beginFill(color, 0.4);
                        panel.graphics.moveTo(data[0].x, data[0].y);
                        
                        for (var i:int = 1; i < data.length; i++)
                        {
                            panel.graphics.lineTo(data[i].x, data[i].y);
                        }
                        panel.graphics.lineTo(data[i - 1].x, p.height);
                        panel.graphics.lineTo(0, p.height);
                        panel.graphics.endFill();
                        
                        panel.graphics.lineStyle(2.0);
                        panel.graphics.moveTo(data[0].x, data[0].y);
                        for (i = 1; i < data.length; i++)
                        {
                            panel.graphics.lineTo(data[i].x, data[i].y);
                        }
                    }
                    t.onUpdateParams = [p.color[i], panel, data];
                }
                t.play();
            }
        }
        
        for (i = 0; i < p.numX; i++)
        {
            if (p.labelX != null && p.labelX[i] != undefined)
            {
                var text:TextField = Utils.createTextField(p.labelX[i]);
                text.x = p.width / (p.numX - 1) * i - text.width / 2;
                text.y = p.height;
                addChild(text);
            }
        } 
        
        for (i = 0; i <= p.numY; i++)
        {
            var num:Number = Math.abs(p.maxY - p.minY) / p.numY * i + p.minY;
            num = (num.toString().indexOf(".") == -1) ? num : Number(num.toFixed(p.fixed));
            var labelY:TextField = Utils.createTextField(num.toString());
            labelY.x = -labelY.width;
            labelY.y = p.height / p.numY * (p.numY - i) - labelY.height / 2;
            addChild(labelY);
        }
        
        var frame:Sprite = new Sprite();
        frame.graphics.lineStyle(3.0);
        frame.graphics.drawRect(0, 0, p.width, p.height);
        addChild(frame);
    }
}

class LineChart extends Sprite
{
    public function LineChart(p:Object)
    {
        Utils.createBackground(graphics, p);
        Utils.toFixed(p.data, p.fixed);
        
        graphics.lineStyle();
        var pr:Number = 0;
        
        for (var i:int = 0; i < p.data.length; i++)
        {
            if (p.key && p.key[i] != undefined)
            {
                graphics.beginFill(p.color[i]);
                graphics.drawRect(pr + 5, -14, 15, 3);
                graphics.endFill();
                
                var tf:TextField = Utils.createTextField(p.key[i]);
                tf.x = pr + 20;
                tf.y = -14 - tf.height / 2;
                addChild(tf);
                pr = tf.x + tf.width;
            }
            
            var panel:Sprite = new Sprite();
            panel.filters = [new DropShadowFilter(1, 45, 0x777777)];
            addChild(panel);
            
            var data:Array = [];
            for (var j:int = 0; j < p.data[i].length; j++)
            {
                var ty:Number = p.height * ((p.maxY - p.data[i][j]) / (p.maxY - p.minY));
                
                var c:Sprite = Utils.getCircle(this, 2, p.data[i][j], p.color[i]);
                c.x = p.width / (p.numX - 1) * j;
                c.y = ty;
                panel.addChild(c);
                data.push(c);
                
                var t:ITween = BetweenAS3.tween(c, { y:c.y }, { y:p.height / 2 } );
                if (j == p.data[i].length - 1)
                {
                    t.onUpdate = function(color:int, panel:Sprite, data:Array):void
                    {
                        panel.graphics.clear();
                        panel.graphics.lineStyle(2.0, color);
                        panel.graphics.moveTo(data[0].x, data[0].y);
                        
                        for (var i:int = 1; i < data.length; i++)
                        {
                            panel.graphics.lineTo(data[i].x, data[i].y);
                        }
                    }
                    t.onUpdateParams = [p.color[i], panel, data];
                }
                t.play();
            }
        }
        
        for (i = 0; i < p.numX; i++)
        {
            if (p.labelX != null && p.labelX[i] != undefined)
            {
                var text:TextField = Utils.createTextField(p.labelX[i]);
                text.x = p.width / (p.numX - 1) * i - text.width / 2;
                text.y = p.height;
                addChild(text);
            }
        } 
        
        for (i = 0; i <= p.numY; i++)
        {
            var num:Number = Math.abs(p.maxY - p.minY) / p.numY * i + p.minY;
            num = (num.toString().indexOf(".") == -1) ? num : Number(num.toFixed(p.fixed));
            var labelY:TextField = Utils.createTextField(num.toString());
            labelY.x = -labelY.width;
            labelY.y = p.height / p.numY * (p.numY - i) - labelY.height / 2;
            addChild(labelY);
        }
    }
}

class BarChart extends Sprite
{
    public function BarChart(p:Object)
    {        
        Utils.createBackground(graphics, p);
        Utils.toFixed(p.data, p.fixed);
        
        var w:Number = p.width / 2 / p.numX;
        
        graphics.lineStyle();
        var pr:Number = 0;
        
        for (var i:int = 0; i < p.data.length; i++)
        {
            if (p.key && p.key[i] != undefined)
            {
                graphics.beginFill(p.color[i]);
                graphics.drawRect(pr + 5, -14, 15, 3);
                graphics.endFill();
                
                var tf:TextField = Utils.createTextField(p.key[i]);
                tf.x = pr + 20;
                tf.y = -14 - tf.height / 2;
                addChild(tf);
                
                pr = tf.x + tf.width;
            }
            
            for (var j:int = 0; j < p.numX; j++)
            {    
                var rect:Sprite = Utils.getRect(this, w / p.data.length, p.data[i][j] / (p.maxY - p.minY) * p.height, p.data[i][j], p.color[i]);
                var tx:Number = j * 2 * w + w / 2;
                rect.x = tx + (w / p.data.length) * i;
                rect.y = p.height / (p.maxY - p.minY) * p.maxY;
                addChild(rect);
                
                if (p.labelX != null && p.labelX[j] != undefined)
                {
                    var text:TextField = Utils.createTextField(p.labelX[j]);
                    text.x = tx + (w - text.width) / 2 + 1;
                    text.y = p.height;
                    addChild(text);
                }
                
                BetweenAS3.tween(rect, { scaleY:1.0 }, { scaleY:0.0 }, 1.0).play();
            }
        }
        
        var frame:Sprite = new Sprite();
        frame.graphics.lineStyle(3.0);
        frame.graphics.drawRect(0, 0, p.width, p.height);
        addChild(frame);
        
        for (i = 0; i <= p.numY; i++)
        {
            var num:Number = Math.abs(p.maxY - p.minY) / p.numY * i + p.minY;
            num = (num.toString().indexOf(".") == -1) ? num : Number(num.toFixed(p.fixed));
            var labelY:TextField = Utils.createTextField(num.toString());
            labelY.x = -labelY.width;
            labelY.y = p.height / p.numY * (p.numY - i) - labelY.height / 2;
            addChild(labelY);
        }
    }
}

class BarChart3D extends Sprite
{
    public function BarChart3D(p:Object)
    {        
        Utils.toFixed(p.data, p.fixed);
        var w:Number = p.width / 2 / p.numX;
        Utils.createBackground3D(graphics, p, [0xBBC0B5, 0xECF0E8], w / p.data.length);
        
        graphics.lineStyle();
        var pr:Number = 0;
        
        for (var i:int = 0; i < p.data.length; i++)
        {
            if (p.key && p.key[i] != undefined)
            {
                graphics.beginFill(p.color[i]);
                graphics.drawRect(pr + 5, -14, 15, 3);
                graphics.endFill();
                
                var tf:TextField = Utils.createTextField(p.key[i]);
                tf.x = pr + 20;
                tf.y = -14 - tf.height / 2;
                addChild(tf);
                
                pr = tf.x + tf.width;
            }
            
            for (var j:int = 0; j < p.numX; j++)
            {    
                var rect:Sprite = Utils.getRect3D(this, w / p.data.length, p.data[i][j] / (p.maxY - p.minY) * p.height, p.rotate, p.data[i][j], p.color[i]);
                var tx:Number = j * 2 * w + w / 2;
                rect.x = tx + (w / p.data.length) * i;
                rect.y = p.height / (p.maxY - p.minY) * p.maxY;
                addChild(rect);
                
                if (p.labelX != null && p.labelX[j] != undefined)
                {
                    var text:TextField = Utils.createTextField(p.labelX[j]);
                    text.x = tx + (w - text.width) / 2 + 1;
                    text.y = p.height + 15;
                    addChild(text);
                }
                
                BetweenAS3.tween(rect, { scaleY:1.0 }, { scaleY:0.0 }, 1.0).play();
            }
        }
        
        for (i = 0; i <= p.numY; i++)
        {
            var num:Number = Math.abs(p.maxY - p.minY) / p.numY * i + p.minY;
            num = (num.toString().indexOf(".") == -1) ? num : Number(num.toFixed(p.fixed));
            var labelY:TextField = Utils.createTextField(num.toString());
            labelY.x = -labelY.width - 15;
            labelY.y = p.height / p.numY * (p.numY - i) - labelY.height / 2;
            addChild(labelY);
        }
    }
}