/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gZk
 */

package {
	/* a tornado made of text
	 */
	import flash.events.Event;
	import flash.geom.Vector3D;
	import flash.text.TextField;
	import flash.text.TextFormat;
    import flash.display.Sprite;
    import flash.text.TextField;

[SWF(backgroundColor="0x000000", width="800", height="600", frameRate="30")]

    public class Twister extends Sprite {

		private var tornadoRadius:Number = 250;
		private var tornadoHeight:Number = 1000;
		private var letters:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		private var numFloaters:int = 300;
		private var floaters:Vector.<TextField> = new Vector.<TextField>(numFloaters);
		private var tf:TextFormat = new TextFormat("Arial", 24);
		private var ctr:Vector3D;

        public function Twister() {
			
			tf.color = 0x00FF00;

			for(var i:int = 0; i < numFloaters; ++i)
			{	
				ctr = new Vector3D(stage.stageWidth/2,800, 500);
				//create letter 
				var t:TextField = new TextField();
				var idx:int = Math.round(Math.random()*25);
				t.defaultTextFormat = tf;
				t.text = letters.charAt(idx);
				floaters[i] = t;
				//set positions
				t.x =  Math.random()*stage.stageWidth;
				t.y =  ctr.y - Math.random()*tornadoHeight;
				t.z =  Math.random()*1000;
				t.rotationX = Math.random()*360;
				t.rotationY = Math.random()*360;
				t.rotationZ = Math.random()*360;
				addChild(t);
				addEventListener(Event.ENTER_FRAME, onEnterFrame);
			}
        }
		private function onEnterFrame(event:Event):void {
			for(var f:int = 0; f < numFloaters; ++f)
			{
				var t:TextField = floaters[f];
				if(t.y < -150){
					t.y = ctr.y;//respawn at the bottom
					continue;
				}
				var xd:Number = t.x - ctr.x;
				var zd:Number = t.z - ctr.z;
				var angle:Number = Math.atan2(xd,zd);//radians
				var radius:Number = Math.sqrt(xd*xd + zd*zd);
				radius -= 5;
				angle+=0.05;
				//stabilize letter at a radius which increase as y decreases
				if(radius < tornadoRadius) {
					t.y--;//updraft
					radius = tornadoRadius*(tornadoHeight - t.y)/tornadoHeight;
				}

				//seen from above,
				//z is the new x, increasing rightwards
				//x is the new y, increasing downwards
				//get new z, x positions
				//and add back to ctr
				t.z = ctr.z + radius*Math.cos(angle);
				t.x = ctr.x + radius*Math.sin(angle);

			}
		}
    }
}
