/**
 * Copyright Lorenz82 ( http://wonderfl.net/user/Lorenz82 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gRH
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            // Display as many blocks on the screen as will fit
            var BLOCK_SIZE:Number = 1;
            var BLOCK_BUFFER:uint = 3;
            var blockSize:uint = 100;
            var blockTotal:uint = blockSize + BLOCK_BUFFER;
            var cols:uint = Math.floor(this.stage.stageWidth / blockTotal);
            var rows:uint = Math.floor((this.stage.stageHeight) / blockTotal);
            var blockXStart:uint = (this.stage.stageWidth - ((cols * blockSize) + ((cols - 1) * BLOCK_BUFFER))) / 2;
            var blockX:uint = blockXStart;
            var blockY:uint = ((this.stage.stageHeight) - ((rows * blockSize) + ((rows - 1) * BLOCK_BUFFER))) / 2;
            for (var colIndex:uint = 0; colIndex < rows; ++colIndex) {
               for (var rowIndex:uint = 0; rowIndex < cols; ++rowIndex) {                   
                  var block:Sprite = this.getBlock(blockSize);
                  block.x = blockX;
                  block.y = blockY;
                  this.addChild(block);
                  blockX += blockTotal;
               }
               blockY += blockTotal;
               blockX = blockXStart;
            }           
            
        }
        
        private function getBlock(blockSize:uint):Sprite
        {
           var block:Sprite = new Sprite();
           block.graphics.beginFill(0xAAC228);
           block.graphics.drawRect(0, 0, blockSize, blockSize);
           block.graphics.endFill();
           block.cacheAsBitmap = true;
           return block;
        }
            
    }
}