/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gQS
 */

//
//  thanks to  http://www.zenbullets.com
//

package
{
	

	
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	
	[SWF( frameRate=12, backgroundColor=0xdddddd)]		
	public class sketch extends Sprite
	{


		private var holder:Sprite = new Sprite();
		
		public var pArray:Array = new Array();
		public var nArray:Array = new Array();
		
		private var bmd:BitmapData = new BitmapData(480,480,true,0xdddddd);
		private var layer2:Bitmap = new Bitmap(bmd);
		
		public function sketch()
		{
			trace("test");
			if(stage != null){
				stage.addEventListener(Event.ENTER_FRAME, onEnter);
				stage.addEventListener(MouseEvent.CLICK, onClick);
			}
			
			//layer.draw(holder);
			var xx:Particle = new Particle(holder);
			
			//layer.add(new FilterEffect(new BlurFilter(2,2 , 1)));
			//layer.add(new ColorEffect(new ColorTransform(1, 1, 1, 0.9)));
			//addChild(layer);

			addChild(layer2);
			
			for(var i:int = 0 ; i < Util.pNum; i++)
			{
				addParticle();
			}
			for(var i:int = 0; i < Util.nNum; i++)
			{
				addNode();
				
			}
		}
		private function onEnter(e:Event):void
		{
			holder.graphics.clear();
			rect();
			
			for(var i:int; i < pArray.length; i++){
				pArray[i].update(nArray);
				pArray[i].drawMe(pArray);
			}
			layer2.bitmapData.draw(holder);
		}
		private function rect():void
		{
			
			var bmd:BitmapData = new BitmapData(480,480,false,0xdddddd);
			layer2.bitmapData.draw(bmd,null,new ColorTransform(1,1,1,0.03));
		}
		private function onClick(e:MouseEvent):void
		{
			clear();
			for(var i:int = 0 ; i < Util.pNum; i++)
			{
				addParticle();
			}
			for(var i:int = 0; i < Util.nNum; i++)
			{
				addNode();
			}
		}
		private function clear():void
		{
			pArray = new Array();
			for(var i:int = 0; i < nArray.length; i++)
			{
				nArray[i].dispose();
			}
			nArray = new Array();
			
			
		}
		private function addParticle():void
		{
			var xx:Particle = new Particle(holder);
			pArray.push(xx );
			
			//holder.addChild(xx);
		}
		
		private function addNode():void
		{
			var xx:Node = new Node();
			this.addChild(xx);
			nArray.push(xx);
			
						
		}
		
	}
}
import flash.display.Sprite;
import flash.geom.Point;

	class Util
	{
		public static const WID:int = 480;
		public static const HEI:int = 480;
		public static const pNum:int = 20;
		public static const nNum:int = 4;
		public static const boost:Number = 0.2;
	}


	
	class Node extends Sprite
	{
		public var pos:Point;
		public function Node()
		{
			pos = new Point(Math.random() * Util.WID, Math.random() * Util.HEI );
			this.graphics.lineStyle(1.5,0xffffff,0.4);
			this.graphics.drawCircle(pos.x, pos.y, 15);
		}
		public function dispose():void
		{
			if(parent)
			{
				parent.removeChild(this);
			}
		}
	}




	class Particle extends Sprite
	{
		public var xPos:Number, yPos:Number;
		public var pos:Point;
		
		public var vel:Point;
		public var gain:Number;
		
		public var col:uint
		private var target:Sprite;
		
		public function Particle(_target:Sprite)
		{
			target = _target;
			xPos = Math.random() * Util.WID;
			yPos = Math.random() * Util.HEI;
			pos = new Point(xPos, yPos);
			vel = new Point(0,0);
			if(Math.random() > 0.5){
				col = 0x000000;
			}else{
				col = 0xffffff;
			}
			
			
		}
		public function drawMe(ar:Array):void
		{
			
			var str:Number = Math.random()*1+ 0.5;
			
			var len:int = ar.length;
			
			for(var i:int = 0; i < len; i++)
			{
				var dis:Number  = Point.distance(pos, ar[i].pos);
				if(dis > 40)
				{
					if(dis > 220)
					{
						dis = 218;
					}
					target.graphics.lineStyle(str, col ,(220 - dis) * 0.004);
					target.graphics.moveTo(pos.x, pos.y);
					target.graphics.lineTo(ar[i].pos.x, ar[i].pos.y);
					
				}
				
				
			}
			
			
		}
		public function update(ar:Array):void
		{
			var len:int = ar.length;
			for(var i:int = 0; i < len; i++)
			{
				gain = Point.distance(pos, ar[i].pos);
				if(gain > 1)
				{
					vel.x += ((ar[i].pos.x - pos.x) * Util.boost) / gain;
					vel.y += ((ar[i].pos.y - pos.y) * Util.boost) / gain;
					pos.x += vel.x;
					pos.y += vel.y;
				}
			}
			
			
			
		}
	}
	








