/**
 * Copyright ueueueueue ( http://wonderfl.net/user/ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gM7
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	
	[SWF(frameRate=50)]
	
	/**
	 * ...
	 * @author ue
	 */
	public class Main extends Sprite 
	{
		public var ball:Sprite;
		public var line:Sprite;
		public var centerPoint:Point = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
		public var ballPoint:Point = new Point();
		public var a:Number = 0;
		public var r:Number = 200;
		public var mScroll:int;
		public var bmp:Bitmap;
		public var bmpData:BitmapData;
		
		public function Main():void 
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			ball = new Sprite();
			ball.graphics.beginFill(0x000000);
			ball.graphics.lineStyle(1,0x000000);
			ball.graphics.moveTo(0, 0);
			ball.graphics.lineTo(5, 20);
			ball.graphics.lineTo(-5, 20);
			ball.graphics.lineTo(0, 0);
			ball.graphics.endFill();
			ball.x = centerPoint.x;
			ball.y = centerPoint.y;
			ball.rotation = 0;
			
			line = new Sprite();
			
			
			addChild(line);
			addChild(ball);
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			r -= 0.3;
			a += 5;
			ball.rotation = a-180;
			if (a >= 360) a = 0;
			
			ballPoint.x = r * Math.cos(a / 180 * Math.PI);
			ballPoint.y = r * Math.sin(a / 180 * Math.PI);
			
			var nowX:Number = ballPoint.x + centerPoint.x;
			var nowY:Number = ballPoint.y + centerPoint.y;
			
			line.graphics.lineTo(nowX, nowY);
			
			ball.x = nowX;
			ball.y = nowY;
			
			line.graphics.lineStyle(1, 0x000000, 0.5);
			line.graphics.moveTo(nowX, nowY);
                        
                        if(ball.x <=0 || ball.y <=0){
                            line.graphics.clear();
                            ball.x = centerPoint.x;
                            ball.y = centerPoint.y;
                            ball.rotation =0;
                            r=200;
                            a=0;
                        }
		}
		
		
	}
	
}