/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gLM
 */

// forked from GreekFellows's Spinfade 3
package {
    import flash.display.Bitmap;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    
    public class Spinfade3 extends Sprite {
        private var array:Array;
        private var prevArray:Array;
        private var done:Array;
        
        private var core:Sprite;
        
        private var sbd:BitmapData;
        private var sb:Bitmap;
        private var ss:Sprite;
        
        private var messages:Array = [ "HELLO", "WORLD", "[ BRADSEDITO ]" ];
        // cm stands for Current Message
        private var cm:int = 0;
        
        private const UNIT:int = 4;
        
        public function Spinfade3() {
            init(messages[cm]);
        }
        
        private function init(str:String, first:Boolean = true):void {
            this.removeChildren();
            
            var t:TextField = text(str);
            
            var bitmapData:BitmapData = new BitmapData(465, 465);
            bitmapData.draw(this);
            this.removeChild(t);
            
            if (first) {
                this.sbd = new BitmapData(465, 465);
                this.sb = new Bitmap(sbd);
                this.ss = new Sprite();
                this.addChild(sb);
                
                this.core = new Sprite();
                this.core.x = 0;
                this.core.y = 0;
                this.core.z = 0;
                this.ss.addChild(this.core);
            }
            
            this.addChild(this.sb);
            
            this.array = [];
            this.done = [];
            
            for (var ver:int = 0; ver < bitmapData.height; ver += this.UNIT) {
                for (var hor:int = 0; hor < bitmapData.width; hor += this.UNIT) {
                    if (bitmapData.getPixel(hor, ver) != 0xffffff) {
                        if (first) {
                            var x:Number = 465/2+Math.cos((hor-ver)*Math.PI/180)*100;
                            var y:Number = 465/2+Math.sin((hor-ver)*Math.PI/180)*100;
                            var z:Number = 0+Math.tan((hor-ver)*Math.PI/180);
                            this.array.push({
                                gx:hor,
                                gy:ver,
                                gz:0,
                                vector:new Vector3D(x, y, z),
                                ax:(hor - x) / 820,
                                ay:(ver - y) / 820,
                                az:(0 - z) / 820,
                                divide:40,
                                startmoving:false,
                                fadeaway:false,
                                alpha:1,
                                color:bitmapData.getPixel(hor, ver)
                            });
                        } else {
                            var vector:Vector3D;
                            if (prevArray[this.array.length - 1] != undefined) {
                                vector = prevArray[this.array.length - 1].vector;
                                
                                this.array.push({
                                    gx:hor,
                                    gy:ver,
                                    gz:0,
                                    vector:vector,
                                    ax:(hor - vector.x) / 820,
                                    ay:(ver - vector.y) / 820,
                                    az:(0 - vector.z) / 820,
                                    divide:40,
                                    startmoving:true,
                                    fadeaway:false,
                                    alpha:1,
                                    color:bitmapData.getPixel(hor, ver)
                                });
                            } else {
                                vector = prevArray[prevArray.length - 1].vector;
                                
                                this.array.push({
                                    gx:hor,
                                    gy:ver,
                                    gz:0,
                                    vector:vector,
                                    ax:(hor - vector.x) / 820,
                                    ay:(ver - vector.y) / 820,
                                    az:(0 - vector.z) / 820,
                                    divide:40,
                                    startmoving:true,
                                    fadeaway:false,
                                    alpha:1,
                                    color:bitmapData.getPixel(hor, ver)
                                });
                            }
                        }
                    }
                }
            }
            
            if (!first) {
            if (this.array.length < this.prevArray.length) {
                for (var addi:int = this.array.length; addi < this.prevArray.length; addi++) {
                    var xa:Number = Math.floor(Math.random() * 400) - 200 + 465/2;
                    var ya:Number = Math.floor(Math.random() * 400) - 200 + 465/2;
                    var za:Number = Math.floor(Math.random() * 400) - 200 + 0;
                    this.array.push( {
                        gx:xa,
                        gy:ya,
                        gz:za,
                        vector:this.prevArray[addi].vector,
                        ax:(xa - this.prevArray[addi].vector.x) / 820,
                        ay:(ya- this.prevArray[addi].vector.y) / 820,
                        az:(za - this.prevArray[addi].vector.z) / 820,
                        divide:40,
                        startmoving:true,
                        fadeaway:true,
                        alpha:1,
                        color:bitmapData.getPixel(hor, ver)
                    });
                }
            }
            }
            
            this.prevArray = [];
            
            for (var ind:int = 0; ind < this.array.length; ind++) {
                this.prevArray.push(this.array[ind]);
            }
            
            this.addEventListener(Event.ENTER_FRAME, spin);
            this.addEventListener(Event.ENTER_FRAME, spinfade);
        }
        
        private function spin(e:Event):void {
            this.core.transform.matrix3D.appendRotation((mouseX - 465/2) / 50, Vector3D.Y_AXIS, new Vector3D(465/2, 0, 0));
            
            this.sbd.draw(ss);
        }
        
        private function spinfade(e:Event):void {
            for (var it:int = 0; it < 50; it++) {
                if (this.array.length > 0) {
                    var ind:int = Math.floor(Math.random() * this.array.length);
                    if (this.array[ind] != undefined) {
                        this.array[ind].startmoving = true;
                    }
                }
            }
            
            ss.graphics.clear();
            
            ss.graphics.beginFill(0xffffff, 1);
            ss.graphics.drawRect(0, 0, 465, 465);
            ss.graphics.endFill();
            
            for (var inde:int = 0; inde < this.array.length; inde++) {
                ss.graphics.beginFill(this.array[inde].color, this.array[inde].alpha);
                ss.graphics.drawRect(graph(this.array[inde].vector).x, graph(this.array[inde].vector).y, this.UNIT, this.UNIT);
                ss.graphics.endFill();
                
                if (this.array[inde].startmoving) {
                    if (this.array[inde].fadeaway) {
                        this.array[inde].alpha -= .05;
                        if (this.array[inde].alpha <= 0) {
                            this.array.splice(inde, 1);
                        }
                    }
                    
                    if (this.array[inde] != undefined) {
                        this.array[inde].vector.x += this.array[inde].ax * this.array[inde].divide;
                        this.array[inde].vector.y += this.array[inde].ay * this.array[inde].divide;
                        this.array[inde].vector.z += this.array[inde].az * this.array[inde].divide;
                        
                        if (this.array[inde].divide <= 0) {
                            this.array[inde].vector.x = this.array[inde].gx;
                            this.array[inde].vector.y = this.array[inde].gy;
                            this.array[inde].vector.z = this.array[inde].gz;
                            this.array[inde].ax = 0;
                            this.array[inde].ay = 0;
                            this.array[inde].az = 0;
                            
                            this.done.push( {
                                vector:this.array[inde].vector,
                                color:this.array[inde].color
                            });
                            
                            this.array.splice(inde, 1);
                        } else {
                            this.array[inde].divide--;
                        }
                    }
                }
                
                if (this.array.length == 0) {
                    cm++;
                    if (messages[cm]!=null) {
                        this.removeEventListener(Event.ENTER_FRAME, spinfade);
                        init(messages[cm], false);
                    }
                }
            }
            
            for (var doni:int = 0; doni < this.done.length; doni++) {
                ss.graphics.beginFill(this.done[doni].color, 1);
                ss.graphics.drawRect(graph(this.done[doni].vector).x, graph(this.done[doni].vector).y, this.UNIT, this.UNIT);
                ss.graphics.endFill();
            }
        }
        
        private function graph(vector:Vector3D):Vector3D {
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            var xy:Vector3D = vector;
            xy = mat.transformVector(vector);
            xy.w = (2000 + xy.z) / 2000;
            xy.project();
            
            return xy;
        }
        
        private function text(str:String):TextField {
            var tf:TextField = new TextField();
            tf.text = str;
            
            var fm:TextFormat = new TextFormat();
            fm.font = "Segoe UI Light";
            fm.size = 72;
            fm.align = "center";
            
            tf.setTextFormat(fm);
            
            tf.width = tf.textWidth;
            tf.height = tf.textHeight + 5;
            tf.x = 465 / 2 - tf.textWidth / 2;
            tf.y = 465 / 2 - tf.textHeight / 2;
            
            this.addChild(tf);
            
            return tf;
        }

    }
}