/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7gGy
 */

// forked from hacker_szoe51ih's flash on 2010-5-30
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.events.*;
     [SWF(width=465,height=465,backgroundColor=0,frameRate=60)]
     
    public class BitmapDataSample11 extends Sprite {
    	
    	private var bmpData:BitmapData;
    	private var colorTrans:ColorTransform;
    	private var filter:BlurFilter;
    	private var vectormap:BitmapData;
    	private var particles:Array;
    	private var particle_number:uint=25000;
    	private var size:Number=465;
    	
        public function BitmapDataSample11() {
          //Bitmapを作成して表示リストに追加
          bmpData=new BitmapData(size,size,false,0);//透明ピクセルはサポートしない
          addChild(new Bitmap(bmpData));
          //DisplayObjectに設定するためのカラーとフィルターを作成
          colorTrans=new ColorTransform(0.95,0.99,0.99);
          filter=new BlurFilter(2,2,1);
          //ベクトルマップとパーティクルの初期化
          vectormap:new BitmapData(size,size,false,0);//透明ピクセルはサポートしない
          reset();
          addEventListener(Event.ENTER_FRAME,onEnterFrame);
          stage.addEventListener(MouseEvent.CLICK,reset);
          
        }
        
        //リセット処理
        public function reset(e:MouseEvent=null):void{
        	var randomSeed:int=Math.random()*0xffffffff;
        	var colors:uint= BitmapDataChannel.RED | BitmapDataChannel.GREEN;
        	vectormap.perlinNoise(size/2,size/2,4,randomSeed,false,true);//numOctavesは4,stitchはtrue,fractalNoiseはfalse
        	//パーティクルの初期化
        	particles=new Array(particle_number);//25000個のパーティクルを格納する為の配列を作成
	        	for(var i:int=0 ; i<particle_number ; i++){
	        		//ここでパーティクルクラスを使う
	        		particles[i]=new Particle(Math.random()*size,Math.random()*size);//ここでの引数が最初の表示位置になる
	        	}
        }
        
        //パーティクルを動かす
        public function onEnterFrame(e:Event):void{
        	//エフェクト適用(フィルターとカラー)  	
        	bmpData.applyFilter(bmpData,bmpData.rect,bmpData.rect.topLeft,filter);        
        	bmpData.colorTransform(bmpData.rect,colorTrans); 	
        	//パーティクルの描画
        	bmpData.lock();
        	for(var i:int=0; i<particle_number; i++){
        		var p:Particle=Particle[i];//配列に入れておいたパーティクルを一個ずつ取り出し、個別の変数に移す
        		//ベクトルマップのPixel値から加速度を算出
        		var col:uint=vectormap.getPixel(p.x,p.y);
        		p.ax+=((col>>16&0xff)-128)*0.0005;
        		p.ay+=((col>>8&0xff)-128)*0.0005;
        	}
        	
        }
    }
}

//パーティクルクラス
class Particle{
	//初期位置
	public var x:Number;
	public var y:Number;
	//加速度
	public var ax:Number;
	public var ay:Number;
	//速度
	public var vx:Number;
	public var vy:Number;
	
	function Particle(px:Number,py:Number):void	{
		x=px;
		y=py;
	}
}
