/**
 * Copyright yashikei ( http://wonderfl.net/user/yashikei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7g75
 */

//ぼかしフィルタ（被写界深度表現）
//参考　http://clockmaker.jp/blog/2008/08/papervision3d_focus_blur/

package{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import org.papervision3d.cameras.Camera3D;

    import flash.utils.Timer;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    public class menu3D extends BasicView {
        
        private var objRen:int = 6;
        private var objs:Array = new Array();
        private var kaiten:Number = 0;

        
        public function menu3D(){
            
            camera.y = 500;
            camera.z = 2000;
            for(var i:int = 0; i<objRen ; i++){
            
                var obj:Plane;
                var material:ColorMaterial = new ColorMaterial(0x00ff00, 0.5);
                material.doubleSided = true;
            
                obj = new Plane(material, 500, 300, 1, 1);
                
                obj.useOwnContainer = true;//ぼかしフィルタ（被写界深度表現）をするときは必須
                objs.push(obj);
                scene.addChild(obj);
                startRendering();
            }
        addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
            
        }//----------  menu3D
            
        //-----------------------------------------------------------
        //EnterFrameHandler
        //-----------------------------------------------------------
        private function EnterFrameHandler(e:Event):void{
            kaiten += 0.5;
            for(var i:int=0 ; i<objs.length ; i++){
                var obj:Plane = objs[i];
                var r:Number = 1000;
                var rot:Number = i*360/objRen;
                obj.x = r * Math.sin( (rot + kaiten) * Math.PI / 180 );
                obj.z = r * Math.cos( (rot + kaiten) * Math.PI / 180 );
                
                //obj.x += 10;
                }
               
            //-----------------------------------------------------------
            //カメラから一番近いオブジェクトとの距離
            //-----------------------------------------------------------
            var disList:Array = new Array();
            for(i = 0; i <objs.length; i++){
                var o:DisplayObject3D = objs[i] as DisplayObject3D;
                var dis:Number = Math.abs(calcPointDistanceFromCamera(o));
                disList.push(dis);
                }
            var disMin:Number = disList[0];
            for(i=0 ; i<objs.length ; i++){
                if(disList[i+1] < disMin){
                    disMin = disList[i+1]
                    }
                }
            //-----------------------------------------------------------
            //ぼかしフィルタの設定
            //-----------------------------------------------------------               
            for (i = 0; i < objs.length; i++)
                {
                 o = objs[i] as DisplayObject3D;
                 
                 // 距離の算出
                 var deg:Number = Math.abs(calcPointDistanceFromCamera(o) - disMin);
                 
                 // ぼかしの適用値
                 var blurVal:int = Math.min(64, deg * .02 << 1 );
                 var blurFilter:BlurFilter = new BlurFilter(blurVal, blurVal, 1);
                 
                 // 明度の適用値
                 var blightness:Number = deg / 20;//ぼかし度
                 var blightnessArr:Array =
                 [
                     1, 0, 0, 0, blightness,
                     0, 1, 0, 0, blightness,
                     0, 0, 1, 0, blightness,
                     0, 0, 0, 1, 0
                 ];
                 var blightnessFilter:ColorMatrixFilter = new ColorMatrixFilter(blightnessArr);
                 
                 // フィルター適用
                 o.filters = [blurFilter, blightnessFilter];
             }
  
        }//----------  EnterFrameHandler
         
        //-----------------------------------------------------------
        //カメラとオブジェクトとの距離を求める
        //-----------------------------------------------------------   
        private function calcPointDistanceFromCamera(obj:DisplayObject3D):Number{
　 　      　var vecX:Number = obj.sceneX - camera.x;
　 　      　var vecY:Number = obj.sceneY - camera.y;
　 　      　var vecZ:Number = obj.sceneZ - camera.z;
　 　      　return Math.sqrt(
　 　　     　　　　　(vecX * vecX)
　 　　   　　　　　+ (vecY * vecY)
　 　　   　　　　　+ (vecZ * vecZ));
        }//----------  calcPointDistanceFromCamera
    }
}