/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7fYK
 */

// forked from aobyrne's Lissajous collection #2
// forked from aobyrne's Lissajous collection #1
package  
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    /**
     * ...
     * @author aobyrne
     */
    public class LissajousCollection extends Sprite
    {
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private var sprite:Sprite;
        public var includeOutput:Boolean;
        
        public function LissajousCollection() 
        {
            includeOutput = false;
            init(0, 0);
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }
        
        public function init(w:int, h:int):void 
        {
            var cy:int;
            var sy:int;
            var cx:int;
            var sx:int;
            bitmap = Bitmap(addChild(new Bitmap));
            var columns:Number = 8;
            var cellSize:Number = 29;
            var cellSize2:Number = 2*cellSize;
            if (w == 0)
            {
                w = cellSize2 * columns;
            }
            if (h == 0) 
            {
                h = cellSize2 * columns;
            }
            bitmapData = new BitmapData(w, h, false, 0xfffffff);
            bitmap.bitmapData = bitmapData;
            var lissajous:Lissajous;
            var total:Number = columns * columns;
            
            
            
            
            
            var indexes:Array = [];
            var disPosableindexes:Array = [];
            for (var i:int = 0; i < total; i++) 
            {
                cx =(i % columns) ;
                cy = Math.floor(i / columns);
                indexes[i]=[cx,cy]
                disPosableindexes[i]=[cx,cy]
            }
            var s:Array = disPosableindexes;
            for (var j:int = 0; j < total; j++) 
            {
                cx =indexes[j][0] ;
                sx =s[j][0] ;
                cy = indexes[j][1];
                sy = s[j][1];
                lissajous = Lissajous(addChild(new Lissajous(this, cellSize+cx * cellSize2, cellSize+cy * cellSize2, sx+1, sy+1, cellSize, cellSize)));
                
            }
            var g:Graphics = Sprite(addChild(new Sprite)).graphics;
            g.beginFill(0xff,0);
            g.drawRect(0, 0,this.width, this.height);
            //addEventListener(Event.ENTER_FRAME, loop);            
        }
        
        private function loop(e:Event):void 
        {
            bitmapData.draw(this);
            
        }
                
    }

}

import flash.display.Graphics;
import flash.display.Shape;
import flash.events.Event;
import flash.display.Sprite;


    class Lissajous extends Sprite 
    {
        private var freqX:Number;
        private var freqY:Number;
        private var radiusX:Number;
        private var radiusY:Number;
        private var shape:Shape;
        private var t:Number;
        private var radian:Number;
        
        public function Lissajous(lissajousCollection:LissajousCollection,xArg:Number,yArg:Number,frecXArg:Number,frecYArg:Number,radiusXArg:Number,radiusYArg:Number,color:uint=0xff)
        {
            shape = Shape(lissajousCollection.addChild(new Shape()));
            var g:Graphics = shape.graphics;
            g.beginFill(color);
            g.drawCircle(0, 0, 2.5);
            x = xArg;
            y = yArg;
            freqX = frecXArg;
            freqY = frecYArg;
            radiusX = radiusXArg;
            radiusY = radiusYArg;
            t = 0;
            radian = Math.PI / 180;
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void 
        {
            shape.x = x+radiusX * Math.sin(t * freqX);
            shape.y = y+radiusY * Math.sin(t * freqY);
            t+=radian;
        }
        
    }


