/**
 * Copyright wonderwhyer ( http://wonderfl.net/user/wonderwhyer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7fEN
 */

// forked from gaina's ConvolutionFilter
package 
{
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ConvolutionFilter;
    
    /**
     * ...
     * @author gaina
     */
    [SWF(width = 465, height = 465, backgroundColor = 0, frameRate=60)]
    public class Main extends Sprite 
    {
        private var _canvas:BitmapData;
        private var _convo:ConvolutionFilter;
        private var _r:Array;
        private var _g:Array;
        private var _b:Array;
        private var _down:Boolean = false;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN,down);
            stage.addEventListener(MouseEvent.MOUSE_UP,up);
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            this.graphics.beginFill(0);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            _canvas = new BitmapData(465, 465, false, 0);
            var _matrix:Array = [
                                1, 2, 1, 
                                2, 5, 2, 
                                1, 2, 1
                                ];
            _convo = new ConvolutionFilter(3, 3, _matrix, 0xFF, 0);
            
            addChild(new Bitmap(_canvas));
            
            _r = [0, 0, 0, 0xFF0000, 0, 0, 0, 0];
            _g = [0, 0, 0, 0x00FF00, 0, 0, 0, 0];
            _b = [0, 0, 0, 0x0000FF, 0, 0, 0, 0];
            
            //_canvas.noise(Math.random() * 500);
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        public function down(e:Event):void
        {
            _down=true;
        }
        
        public function up(e:Event):void
        {
            _down=false;
        }
        
        private function loop(e:Event):void 
        {
            _canvas.lock();
            if(_down)
            {
                for(var i:int = -1;i<2;i++)
                {
                    for(var j:int = -1;j<2;j++)
                    {
                        _canvas.setPixel(mouseX+i,mouseY+j,Math.random()*int.MAX_VALUE);
                    }
    
                }
            }

            _canvas.applyFilter(_canvas, _canvas.rect, _canvas.rect.topLeft, _convo);
            _canvas.paletteMap(_canvas, _canvas.rect, _canvas.rect.topLeft, _r, _g, _b, null);
            _canvas.unlock();
        }
        
    }
    
}