/**
 * Copyright Nekoeri88 ( http://wonderfl.net/user/Nekoeri88 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7ef3
 */

// forked from ProjectNya's EmitLight (9)
////////////////////////////////////////////////////////////////////////////////
// EmitLight (9)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var light:EmitLight;

        public function Main() {
            Wonderfl.capture_delay(4);
            init();
            addChild(new Stats());
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new EmitLight(rect);
            addChild(light);
        }

    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var max:uint = 4;
    private var particles:Array;
    private var color:ColorHSV;
    private var colorTrans:ColorTransform;
    private static var blur:BlurFilter;
    private static var point:Point = new Point();
    private var id:uint = 0;
    
    private var random_x:uint;
    private var random_y:uint;
    
    private var randomarray:Array;
    

    public function EmitLight(r:Rectangle) {
        rect = r;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        particles = new Array();
        color = new ColorHSV(0);
        colorTrans = new ColorTransform();
        blur = new BlurFilter(8, 8, 3);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        
        randomarray = new Array();
        randomarray.x1 = 1;
        randomarray.xp = 0;
        randomarray.y1 = 1;
        randomarray.yp = 0;
        randomarray.yurax = 5;
        randomarray.yuray = 5;

        
    }
    private function update(evt:Event):void {
        create();
        bitmapData.lock();
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.angle += 10;
            particle.update();
            particle.scale = particle.alpha = particle.power;
            if (particle.power < 0) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        color.h = id;
        colorTrans.color = color.value;
        bitmapData.draw(container, null, colorTrans, BlendMode.SCREEN, null, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        id ++;
        
        
randomarray.yurax * 2

        //randomarray.x1 = 200;
        randomarray.y1 = 200;
        
        trace (randomarray.x1);
        
    }
    private function create():void {
        for (var n:uint = 0; n < max; n++) {
            var particle:Particle = new Particle();
            //particle.tx = mouseX;
            //particle.ty = mouseY;
            
            particle.tx = randomarray.x1;
            particle.ty = randomarray.y1;
            
            
            particle.angle = Math.random()*360;
            particle.speed = Math.random()*3 + 5;
            particle.power = 1;
            particle.setup();
            container.addChild(particle);
            particles.push(particle);
        }
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class Particle extends Shape {
    private static var radius:uint = 6;
    private static var color:uint = 0xFFFFFF;
    public var angle:Number = 0;
    public var speed:Number = 0;
    public var tx:Number;
    public var ty:Number;
    private var vx:Number = 0;
    private var vy:Number = 0;
    public var power:Number = 0;
    private static var radian:Number = Math.PI/180;
    private static var friction:Number = 0.96;
    private static var deceleration:Number = 0.016;
    private static var acceleration:Number = 0.02;
    private var _scale:Number = 1;

    public function Particle() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function setup():void {
        x = tx;
        y = ty;
    }
    public function update():void {
        speed *= 1.05;
        vx = speed*Math.cos(angle*radian);
        vy = speed*Math.sin(angle*radian);
        tx += vx;
        ty += vy;
        x += (tx - x)*acceleration;
        y += (ty - y)*acceleration;
        vx *= friction;
        vy *= friction;
        power -= deceleration;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}
