/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7drI
 */

// forked from bongiovi015's Sphere with sound
package  {

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.ProgressEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DropShadowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Vector3D;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    
    public class WonderSphere2 extends Sprite {
    
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        private static const POLICY_FILE:String = "http://www.bongiovi.tw/crossdomain.xml";
        private static const SOUND_FILE:String = "http://scfire-dtc-aa03.stream.aol.com:80/stream/1035";
        
        public static const W : int = 465;
        public static const R : int = 150;
        public static const RECT : Rectangle = new Rectangle(0, 0, W, W);
        public static const COLORS : Array = [0x587b7C, 0x719b9E, 0x9FC1BE, 0xE0D9BB, 0xDACB94, 0xCABA88, 0xDABD55, 0xC49F32, 0xA97409];
        public static const SEED : int = Math.floor( Math.random() * 0xFFFF );
        public static const ROTATION : Number = 1;
        public static const CTRANS : ColorTransform = new ColorTransform(.9, .9, .9, .8);
        public static const BLUR : BlurFilter = new BlurFilter(3, 3, 1);
        
        private var __bmpd                      : BitmapData = new BitmapData(W, W, true, 0x00000000);
        private var __bmpdPerlin                  : BitmapData;
        private var __particles                  : Vector.<Particle> = new Vector.<Particle>();
        private var __sContainer                : Shape = new Shape;
        private var __sound                        : Sound = new Sound;
        private var __soundChannel                 : SoundChannel;
        private var __bytes                     : ByteArray = new ByteArray();
        private var __sLoading                    : Shape = new Shape;
        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
    
        /**
         *    @constructor
         */
        public function WonderSphere2(){
//            Security.loadPolicyFile(POLICY_FILE);
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(W, W);
            graphics.beginGradientFill(GradientType.RADIAL, [0x1e1506, 0x000000], [1, 1], [25, 255], mtx);
            graphics.drawRect(0, 0, W, W);
            graphics.endFill();
            
            addChild(__sLoading);
            
            __sound.addEventListener(Event.COMPLETE, __onSoundLoaded);
            __sound.addEventListener(ProgressEvent.PROGRESS, __onProgress);
            __sound.addEventListener(IOErrorEvent.IO_ERROR, function(e:IOErrorEvent) : void { trace("Error Loading Sound File"); });
            __sound.load(new URLRequest(SOUND_FILE), new SoundLoaderContext(10000, true));
        }
        
        
        private function __onProgress(e:ProgressEvent) : void {
            __sLoading.graphics.clear();
            __sLoading.y = 465 / 2;
            __sLoading.graphics.beginFill(0xFFFFFF, 1);
            __sLoading.graphics.drawRect(0, 0, 465 * e.bytesLoaded / e.bytesTotal, 1);
            __sLoading.graphics.endFill();
        }
        
        
        private function __onSoundLoaded(e:Event) : void {
            __sound.removeEventListener(ProgressEvent.PROGRESS, __onProgress);
            removeChild(__sLoading);
            
            addChild(new Bitmap(__bmpd));
            __initPerlin();
            __initParticles();
            
            __soundChannel = __sound.play();
            __soundChannel.addEventListener(Event.SOUND_COMPLETE, function(e:Event) : void  {__soundChannel = __sound.play(); } );

            addEventListener(Event.ENTER_FRAME, render);
            
        }
        
        
        public function render(e:Event) : void {
            SoundMixer.computeSpectrum(__bytes, true);
            var ary:Array = [];
            for (var j:int = 0; j < 128; j++){
                ary[j] = __bytes.readFloat();
            }
            
            __sContainer.graphics.clear();
            
            var p:Particle;
            var pos:Vector3D;
            var tx:Number, ty:Number;
            const ROTATION:Number = .5;
            var count:int = 0;
            
            for each ( p in __particles) {
                p.matrix.appendRotation(ROTATION*.5, Vector3D.X_AXIS);
                p.matrix.appendRotation(ROTATION, Vector3D.Y_AXIS);
                pos = p.matrix.position;
                
                if(pos.z > 0) {
                    var bColor:uint = brightnessColor(p.color, 1 - Math.sqrt( Math.pow(pos.x, 2) + Math.pow(pos.y, 2) ) / 250);
                    __sContainer.graphics.beginFill(bColor);
                    __sContainer.graphics.drawCircle(pos.x+W*.5, pos.y+W*.5, p.length + 2*ary[p.angle]);
                    __sContainer.graphics.endFill();
                }
                count ++;
            }
            
            __bmpd.lock();
            __bmpd.applyFilter(__bmpd, RECT, new Point, BLUR);
            __bmpd.colorTransform(RECT, CTRANS);
            __bmpd.draw(__sContainer);
            __bmpd.unlock();
        }

        
        private function __initParticles() : void {
            const DIS:int = 72; 
            const TOTAL:int = 360 / DIS;
            var i:int, j:int;
            var pos:Vector3D;
            var tx:Number, ty:Number;
            
            for (j=0; j<DIS*.5; j++ ) {
                for (i=0; i<DIS; i++ ) {
                    var p:Particle = new Particle();
                    p.matrix.identity();
                    p.matrix.appendTranslation(R, 0, 0);
                    p.matrix.appendRotation(i*TOTAL, Vector3D.Z_AXIS);
                    p.matrix.appendRotation(j*TOTAL, Vector3D.Y_AXIS);
                    
                    p.mtxOrg.appendTranslation(R, 0, 0);
                    p.mtxOrg.appendRotation(i*TOTAL, Vector3D.Z_AXIS);
                    p.mtxOrg.appendRotation(j*TOTAL, Vector3D.Y_AXIS);
                    p.length = .5;
                    
                    p.color = getRandomColorFrom(COLORS);
                    
                    if(i <= 18) p.angle = i;
                    else if ( i <= 36 ) p.angle = 36 - i;
                    else if ( i <= 54 ) p.angle = i - 18;
                    else p.angle = 72 - i + 18;
                    
                    __particles.push(p);
                }
            }
        }

        
        private function __initPerlin(e:Event=null) : void {
            if(__bmpdPerlin == null) __bmpdPerlin = new BitmapData(W*.5, W*.5);
            __bmpdPerlin.perlinNoise(W*.5, W*.5, 8, SEED, false, true, 4);
        }

        
        public static function getRandomColor(colors:Array) : uint {    return colors[int(Math.random() * colors.length)];    }
        
        public static function getRandomColorFrom(colors:Array) : uint {    return colors[int(Math.random() * colors.length)];    }
        
        public static function brightnessColor(color:uint, level:Number) : uint {
            var a:uint = color >> 24 & 0xFF; 
            var r:uint = color >> 16 & 0xFF; 
            var g:uint = color >> 8 & 0xFF; 
            var b:uint = color & 0xFF;
            
            r *= level;
            g *= level;
            b *= level;
            
            if(r > 0xFF) r = 0xFF;
            if(g > 0xFF) g = 0xFF;
            if(b > 0xFF) b = 0xFF;
            
            var newColor:uint = a << 24 | r << 16 | g << 8 | b;
            return newColor;
        }

    }

}


import flash.geom.Matrix3D;

class Particle {
    public var matrix : Matrix3D = new Matrix3D;
    public var mtxOrg : Matrix3D = new Matrix3D;
    public var color : uint;
    public var angle : Number;
    public var length : Number;
}
