/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7chT
 */

// forked from _wonder's 不規則な円をゆっくりとアニメーションさせる
// forked from _wonder's 不規則な円
// forked from _wonder's curveToを使って閉じた曲線を描く
package {
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor=0x000000)]
    public class Moveball extends Sprite {
        private var numDots:uint = 200;
        private var maxRadius:Number = 200;
        
        public function Moveball() {
            init();
        }
        
        public function init():void {
            for( var i:uint = 0; i < numDots; i++ ){
                var ballRadius:Number = Math.random() * 5 + 15;
                var dot:Ball = new Ball( ballRadius, Math.random() * 0xffffff );
                var radius:Number = Math.sqrt(Math.random()) * maxRadius;
                var angle:Number = Math.random() * (Math.PI * 2);
                dot.x = stage.stageWidth / 2 + Math.cos( angle ) * radius;
                dot.y = stage.stageHeight / 2 + Math.sin( angle ) * radius;
                dot.alpha = 0.2;
                addChild( dot );
            }
        }
    }
}


import flash.display.Sprite;
import flash.events.Event;

class Ball extends Sprite {
        private var num:uint = 14;
        private var radius:Number;
        private var rdm:Number = 5;
        private var points:Array = [];
        private var nextpoints:Array = [];
        private var per:Number = 0.3;
        private var color:uint;
        
        public function Ball(radius:Number, color:uint=0x32280c) {
            this.radius = radius;
            this.color = color;
            init();
        }
        
        private function init():void {
                points = getPoint();
                nextpoints = getPoint();
                
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
                for( var i:int = 0; i < points.length; i++){
                    (points[i].x - nextpoints[i].x) > 0 ? points[i].x -= per : points[i].x += per ;
                    (points[i].y - nextpoints[i].y) > 0 ? points[i].y -= per : points[i].y += per ;
                }
                if( Math.abs(points[0].x - nextpoints[0].x) < per ){ nextpoints = getPoint(); };
                
                createBall( points );
        }
        
        private function createBall( _points:Array ):void {
                graphics.clear();
                
                graphics.lineStyle(1, color);
                graphics.beginFill(color);
                
                var xc1:Number = (_points[0].x+_points[num-1].x) / 2;
                var yc1:Number = (_points[0].y+_points[num-1].y) / 2;
                graphics.moveTo(xc1,yc1);
                
                for(var j:int = 0; j < num-1; j++){
                    var xc:Number = (_points[j].x+_points[j+1].x) / 2;
                    var yc:Number = (_points[j].y+_points[j+1].y) / 2;
                    graphics.curveTo(_points[j].x, _points[j].y, xc, yc);
                }
                
                graphics.curveTo(points[j].x, points[j].y, xc1, yc1);
        }
        
        private function getPoint():Array {
                var array:Array = [];
                for( var i:int = 0; i < num; i++){
                    var rad:Number = (i*360/num) * Math.PI / 180;
                    array[i] = new Object();
                    array[i].x = Math.sin( rad ) * radius + (Math.random() * rdm);
                    array[i].y = Math.cos( rad ) * radius + (Math.random() * rdm);
            }
            return array;
        }
    }