/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7bdw
 */

// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Spring extends Sprite {
    		private var ball:Ball;
    		private var spring:Number = 0.1;
    		private var targetX:Number = stage.stageWidth / 2;
    		private var targetY:Number = stage.stageHeight / 2;
    		private var vx:Number = 100;
    		private var vy:Number = 0;
    		private var friction:Number = 0.95;
    		private var gravity:Number = 5;
    		
    		public function Spring() {
            init();
        }
        
        private function init():void {
        		ball = new Ball();
        		addChild( ball );
        		addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
        		var dx:Number = mouseX - ball.x;
        		var dy:Number = mouseY - ball.y;
        		var ax:Number = dx * spring;
        		var ay:Number = dy * spring;
        		vx += ax;
        		vy += ay;
        		vy += gravity;
        		vx *= friction;
        		vy *= friction;
        		ball.x += vx;
        		ball.y += vy;
        		graphics.clear();
        		graphics.lineStyle(1);
        		graphics.moveTo(ball.x, ball.y);
        		graphics.lineTo(mouseX, mouseY);
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
	public var radius:Number;
	public var color:uint;
	
	public function Ball(radius:Number=40, color:uint=0Xff0000){
		this.radius = radius;
		this.color = color;
		init();
	}
	
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}