/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7bUs
 */

/*
	Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト

	code 3.2.13
*/
package {
	import com.bit101.components.*;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.*;

	[SWF(width = "800", height = "600", frameRate = "12", backgroundColor = "#101010")]
    public class ChangeSphereMaterialSample extends BasicView {
		
		private var sphere:Sphere;
		private var color_btn:PushButton;
		private var wire_btn:PushButton;
		private var bmp_btn:PushButton;
		private var bmpdata:BitmapData;
		
		public function ChangeSphereMaterialSample()
		{
			// ボタン初期化
			color_btn = new PushButton(stage, 10, 20, "ColorMaterial");
			wire_btn = new PushButton(stage, 10, 50, "WireMaterial");
			bmp_btn = new PushButton(stage, 10, 80, "BitmapMaterial");

			// Loaderクラスを使用して画像ファイルを読み込む(外部のパスを指定)
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
			loader.load(
				new URLRequest("http://assets.wonderfl.net/images/related_images/2/29/2957/295773efe549b4206f0ab5e4e776915fb02f95ff"),
				new LoaderContext(true));		
		}

		private function compHandler(e:Event) :void 
		{
			var loader:Loader = e.target.loader as Loader;
			// 画像ファイルを読み込んだ場合、loaderのcontentプロパティがビットマップ画像になっている
			bmpdata = Bitmap(loader.content).bitmapData;
			
			// 初期はカラーマテリアルを採用
			var material:ColorMaterial = new ColorMaterial(0xFF0000);
			
			// プリミティブオブジェクトの球体を作成
			sphere = new Sphere(material, 400);
			scene.addChild(sphere);
			
			// 3つのボタンの制御
			color_btn.addEventListener(MouseEvent.CLICK, clickHandler);
			wire_btn.addEventListener(MouseEvent.CLICK, clickHandler);
			bmp_btn.addEventListener(MouseEvent.CLICK, clickHandler);
			
			// レンダリング
			startRendering();
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			sphere.rotationY += 0.5;
		}
		
		
		private function clickHandler(e:MouseEvent):void
		{
			// マテリアルプロパティに新しいマテリアルを指定して差し替える
			switch(e.currentTarget) 
			{
			case color_btn :
				sphere.material = new ColorMaterial(0xFF0000);
				break;
				
			case wire_btn :
				sphere.material = new WireframeMaterial(0xFF0000);
				break;
				
			case bmp_btn :
				sphere.material = new BitmapMaterial(bmpdata);
				break;
			}
		}
    }
}