/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7bQB
 */

// forked from cpu_t's BitmapDataのhistogram()
// BitmapDataのhistogramってどんなのか実験。
// 
// とりあえずperlinNoiseをhistogramしてみる。
// 
// resetを押すとBitmapDataが新しくなります。
// 上の数字はnumOctaves
// 下はチェックを入れるとfractalNoiseがtrueになります
// 
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Loader;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.TextField;
    public class FlashTest extends Sprite {
		private var bmp:Bitmap;
		private var bmpdata:BitmapData;
		private var tfoutput:TextField;
		private var view:Sprite;
		private var input:TextField;
        public function FlashTest() {
			addChild(bmp = new Bitmap());
			bmp.y = 80;
			
			tfoutput = createTextfield();
			//tfoutput.type = "input";
			tfoutput.y = 25;
			
			addChild(view = new Sprite());
			view.y = stage.stageHeight;
			
			var btn:Sprite = new Sprite();
			addChild(btn);
			btn.graphics.beginFill(0xE0E0E0);
			btn.graphics.drawRect(0, 0, 40, 20);
			btn.graphics.endFill();
			var t:TextField;
			btn.addChild(t = new TextField());
			t.text = "reload";
			t.autoSize = "left";
			btn.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void { loadImg(); } );
			
			input = createTextfield();
			input.x = 50;
			input.type = "input";
			input.text = "http://wonderfl.net/static/tmp/related_images/d707916d0a76acf0e2618e7567d708efa65b094em";
			
			loadImg();
        }
		
		private function createTextfield():TextField
		{
			var t:TextField = new TextField;
			addChild(t);
			t.background = true;
			t.backgroundColor = 0xE0E0E0;
			t.autoSize = "left";
			return t;
		}
		
		private function loadImg():void
		{
			var loader:Loader = new Loader();
			var req:URLRequest = new URLRequest(input.text);
			tfoutput.appendText("load\n");
			loader.load(req, new LoaderContext(true));
			loader.contentLoaderInfo.addEventListener(Event.INIT, function(e:Event):void
			{
				var l:Loader = new Loader();
				tfoutput.appendText("load2\n");
				l.loadBytes(loader.contentLoaderInfo.bytes);
				l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
				{
					tfoutput.appendText("complete");
					bmpdata = new BitmapData(l.width, l.height);
					bmpdata.draw(l);
					bmp.bitmapData = bmpdata;
					reset();
				});
			});
			
		}
		
		private function reset():void
		{
			var vec:Vector.<Vector.<Number>> = bmpdata.histogram(bmpdata.rect);
			tfoutput.text = "";
			tfoutput.appendText("r:"+vec[0].toString() + "\n");
			tfoutput.appendText("g:"+vec[1].toString() + "\n");
			tfoutput.appendText("b:" + vec[2].toString());
			
			var g:Graphics = view.graphics;
			g.clear();
			g.lineStyle( -1, 0);
			g.moveTo(0, 0);
			g.lineTo(255, 0);
			g.endFill();
			
			for (var c:int = 0; c < 3; c++)
			{
				g.lineStyle( -1, 0xFF0000 >> (c * 8));
				g.moveTo(0, -vec[c][0]);
				for (var i:int = 0; i < 256; i++)
					g.lineTo(i, -vec[c][i]);
				g.endFill();
			}
		}
    }
}