/**
 * Copyright windy ( http://wonderfl.net/user/windy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7bD0
 */

// forked from ProjectNya's candle + fire + Microphone
////////////////////////////////////////////////////////////////////////////////
// candle + fire + Microphone
//
// add microphone feature to blow it off (by makc3d)
// マイクに息を吹きかけて、ろうそうの炎を消して！
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.media.Microphone;
    import flash.events.ActivityEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var candlePath:String = "e/ed/edac/edacc14dd5fdd2d007f924c08230d2f2360ce50c";
        private var fire:Fire;
        private var mic:Microphone;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var label:Label = new Label(465, 80, 48, Label.CENTER);
            addChild(label);
            label.y = 100;
            label.textColor = 0x999999;
            label.text = "candle off!";
            //
            var loader:PhotoLoader = new PhotoLoader();
            loader.addEventListener(PhotoLoader.INIT, initialize, false, 0, true);
            loader.load(basePath + candlePath);
        }
        private function initialize(evt:Event):void {
            evt.target.removeEventListener(PhotoLoader.INIT, initialize);
            var candle:Bitmap = Bitmap(evt.target.content);
            addChild(candle);
            candle.x = 172;
            candle.y = 345;
            //
            fire = new Fire();
            addChild(fire);
            fire.x = 232;
            fire.y = 390;
            //
            mic = Microphone.getMicrophone();
            mic.setLoopBack(true);
            mic.gain = 50;
            mic.rate = 11;
            mic.setSilenceLevel(5);
            mic.addEventListener(ActivityEvent.ACTIVITY, start, false, 0, true);
        }
        private function start(evt:ActivityEvent):void {
            var timer:Timer = new Timer(50);
            timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
            timer.start();
        }
        private function update(evt:TimerEvent):void {
            var level:Number = mic.activityLevel;
            fire.setup(level/100);
        }
        
    }

}


//////////////////////////////////////////////////
// Fireクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.filters.GradientGlowFilter;
import flash.filters.BitmapFilterType;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class Fire extends Sprite {
    private var fire:Shape;
    private static var colors:Array = [0xFF0000, 0xFFFF00, 0xFFFFFF];
    private static var alphas:Array = [0, 0.75, 1];
    private static var ratios:Array = [0, 192, 255];
    private var light:Shape;
    private var level:Number = 1;

    public function Fire() {
        init();
    }

    private function init():void {
        draw();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function setup(lv:Number):void {
        if (lv > 1) lv = 1;
        level = 1 - lv;
    }
    private function update(evt:Event):void {
        var angle:Number = 265 + Math.floor(Math.random()*10);
        var blurX:Number = 16 + Math.floor(Math.random()*4);
        var blurY:Number = 48 + Math.floor(Math.random()*8);
        var gradientGlowFilter:GradientGlowFilter = new GradientGlowFilter(16, angle, colors, alphas, ratios, blurX, blurY, 2, 3, BitmapFilterType.FULL, true);
        fire.filters = [gradientGlowFilter];
        fire.scaleY = level;
        light.scaleX = light.scaleY = level*0.4 + 0.6;
    }
    private function draw():void {
        createLight();
        createFire();
    }
    private function createLight():void {
        light = new Shape();
        addChild(light);
        light.y = -60;
        var _colors:Array = [0xFFFFFF, 0xFFFF00];
        var _alphas:Array = [0.6, 0];
        var _ratios:Array = [0, 255];
        var radius:uint = 200;
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        light.graphics.beginGradientFill(GradientType.RADIAL, _colors, _alphas, _ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        light.graphics.drawCircle(0, 0, radius);
        light.graphics.endFill();
    }
    private function createFire():void {
        fire = new Shape();
        addChild(fire);
        var w:uint = 30;
        var h:uint = 90;
        fire.graphics.beginFill(0xFFFFFF);
        fire.graphics.moveTo(-w*0.5, -h*0.2);
        fire.graphics.curveTo(-w*0.4, -h, 0, -h);
        fire.graphics.curveTo(w*0.4, -h, w*0.5, -h*0.2);
        fire.graphics.curveTo(w*0.5, 0, 0, 0);
        fire.graphics.curveTo(-w*0.5, 0, -w*0.5, -h*0.2);
        fire.graphics.endFill();
        fire.blendMode = BlendMode.SCREEN;
        var gradientGlowFilter:GradientGlowFilter = new GradientGlowFilter(16, 270, colors, alphas, ratios, 18, 52, 2, 3, BitmapFilterType.FULL, true);
        fire.filters = [gradientGlowFilter];
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
