/**
 * Copyright joeRob2468 ( http://wonderfl.net/user/joeRob2468 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7aZs
 */

package {
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    
    [SWF(backgroundColor=0x000000, frameRate=60)]
    
    public class FlashTest extends Sprite {
        
        private var g:Graphics;
        private var color:uint = 0xFFFFFF;
        private var brushSize:Number = 2;
        private var maxBrushSize:Number = 10;
        
        private var drawing:Boolean = false;
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void
        {
            g = this.graphics;
            stage.doubleClickEnabled = true;
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN,startDraw);
            stage.addEventListener(MouseEvent.MOUSE_UP,stopDraw);
            stage.addEventListener(MouseEvent.DOUBLE_CLICK,changeColor);
            stage.addEventListener(KeyboardEvent.KEY_UP,clear);
        }
        
        private function startDraw(e:MouseEvent):void
        {
            drawing = true;
            g.moveTo(mouseX,mouseY);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,draw);
        }
        
        private function draw(e:MouseEvent):void
        {
            if(drawing)
            {
                g.lineStyle(brushSize/2,color);
                g.lineTo(mouseX,mouseY);
            }

        }

        
        private function stopDraw(e:MouseEvent):void
        {
            drawing = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,draw);
        }
        
        
        private function changeColor(e:MouseEvent):void
        {
            color = Math.random()*0xFFFFFF;
            //brushSize = Math.random()*maxBrushSize;
        }
        
        
        private function clear(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.SPACE:
                    g.clear();
                    break;
            }

        }




    }
}