/**
 * Copyright katapad ( http://wonderfl.net/user/katapad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7ZM1
 */

package 
{
	import com.bit101.components.CheckBox;
	import com.bit101.components.HBox;
	import com.bit101.components.Label;
	import com.bit101.components.NumericStepper;
	import com.bit101.components.PushButton;
	import com.bit101.components.TextArea;
	import com.bit101.components.VBox;
	import com.bit101.components.Window;
	import com.greensock.TweenMax;
	import flash.display.DisplayObjectContainer;
	import flash.events.Event;
	import flash.system.System;
	
	/**
	 * public function生成ツール。
	 * functionの名前を改行区切りで書くと全部public function hoge():voidが吐き出されます。
	 * 引数とか、戻り値はないです。
	 * @author katapad
	 * @version 0.1
	 * @since 2011/03/16 18:23
	 */
	public class FuncGenUI extends Window 
	{
		//----------------------------------
		//  static var/const
		//----------------------------------
		public static const WIDTH:int = 465;
		public static const HEIGHT:int = 465;
		public static const TAB:String = '\t';
		
		//----------------------------------
		//  instance var 
		//----------------------------------
		private var _container:VBox;
		private var _tabNum:NumericStepper;
		private var _input:TextArea;
		private var _output:TextArea;
		private var _info:Label;
		private var _useASDoc:CheckBox;
		
		public function FuncGenUI(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number = 0, title:String = "funcGen")
		{
			super(parent, xpos, ypos, title);
			_init();
		}
		
		private function _init():void 
		{
			width = WIDTH;
			height = HEIGHT;
			_container = new VBox(this, 5, 5);
			_container.spacing = 10;
			
			_info = new Label(_container);
			
			var btnBox:HBox = new HBox(_container);
			new PushButton(btnBox, 0, 0, 'generate', _generateHandler);
			new PushButton(btnBox, 0, 0, 'clear', _clearHandler);
			
			var optionBox:HBox = new HBox(_container, 3, 14);
			new Label(optionBox, 0, 0, 'tab num');
			_tabNum = new NumericStepper(optionBox, 0, 0);
			_tabNum.minimum = 0;
			_tabNum.maximum = 5;
			_tabNum.value = 2;
			
			_useASDoc = new CheckBox(_container, 0, 0, 'use ASDoc');
			_useASDoc.selected = false;
			
			
			
			new Label(_container, 0, 0, '');
			new Label(_container, 0, 0, 'input');
			_input = new TextArea(_container, 0, 0, 'funcA\nfuncB\nfuncC');
			
			new Label(_container, 0, 0, 'output');
			_output = new TextArea(_container);
			_output.editable = false;
			_output.width = this.width - 10;
		}
		
		private function _clearHandler(event:Event):void 
		{
			_input.text = '';
			_output.text = '';
		}
		
		private function _generateHandler(event:Event):void 
		{
			if (_input.text == '')
			{
				_showInfo('please fill input text');
				return;
			}
			
			_parse();
			
			System.setClipboard(_output.text);
			_showInfo('success! copied!');
		}
		
		private function _parse():void 
		{
			
			var tab:String = _getTab();
			var asdoc:String = _getASDoc(tab);
			
			var text:String = _input.text;
			text = text.replace(/\r/g, '\n');
			text = text.replace(/\r\n/g, '\n');
			text = text.replace(/\n\n/g, '\n');
			
			
			var list:Array = text.split('\n');
			
			var result:String = '';
			
			for (var i:int = 0, n:int = list.length; i < n; ++i) 
			{
				var funcName:String = list[i];
				if (funcName == '')
					continue;
				
				result += asdoc 
						+ tab + 'public function ' + funcName + '():void \n' 
						+ tab + '{' + '\n'
						+ tab + TAB + '\n'
						+ tab + '}' + '\n'
						+ '\n'
			}
			
			_output.text = result;
		}
		
		private function _getASDoc(tab:String):String 
		{
			if (!_useASDoc.selected)
				return '';
			return tab + '/**\n' + tab + ' * \n' + tab + ' */\n';
		}
		
		private function _getTab():String 
		{
			var num:int = int(_tabNum.value);
			var result:String = '';
			for (var i:int = 0; i < num; i++) 
			{
				result += TAB;
			}
			return result;
		}
		
		
		
		
		
		
		
		
		
		//----------------------------------
		//  view
		//----------------------------------
		private function _showInfo(text:String):void 
		{
			_info.text = text;
			_startDeleteInfoTimer();
		}
		
		private function _startDeleteInfoTimer():void 
		{
			TweenMax.killDelayedCallsTo(_deleteInfo);
			TweenMax.delayedCall(3, _deleteInfo)
		}
		
		private function _deleteInfo():void 
		{
			_info.text = '';
		}
		
	}
}
