/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7YlU
 */

package {

    import flash.display.Sprite;
    import flash.display.Shape
    import flash.display.Graphics
    
    public class FlashTest extends Sprite {
        
        private var sh:Shape
        
        public function FlashTest() {
            // write as3 code here..
            sh = new Shape
            sh.x = sh.y = stage.stageWidth / 2
            addChild(sh)
            
            stage.addEventListener("mouseDown", function(Null):void {
                sh.graphics.clear()
                render(sh.graphics)
            })
            render(sh.graphics)
        }
        
        public function render(g:Graphics):void {
            var rad:Number = 200
            
            // border
            sh.graphics.lineStyle(1, 0x0)
            sh.graphics.drawCircle(0, 0, rad)
            sh.graphics.endFill()
            
            // lines
            for(var i:int=0; i<50; i++){
                connect(sh.graphics, rad, Math.random()*6.28, Math.random()*6.28)
            }
        }
        
        public function connect(g:Graphics, rad:Number, t0:Number, t1:Number):void {
            var ratio:Number = Math.abs(t0-t1) / Math.PI
            g.lineStyle(ratio, 0x0, .2 + ratio * .8)
            var x0:Number = rad * Math.cos(t0), y0:Number = rad * Math.sin(t0)
            var x1:Number = rad * Math.cos(t1), y1:Number = rad * Math.sin(t1)
            g.moveTo(x0, y0)
            g.curveTo(0, 0, x1, y1)
        }
        
    }
    
}