/**
 * Copyright poepoemix ( http://wonderfl.net/user/poepoemix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7YEy
 */

package {
    import flash.display.Sprite;
    /**
     * コンポーネント作成のヘルパー
     */
    public class ComponentHelper extends Sprite{
        public function ComponentHelper() {
            if(stage != null) {
                red();
                var base:* = base({
                    parent: this,
                    left: 10,
                    top: 10,
                    width: stage.stageWidth - 20,
                    height: stage.stageHeight - 20,
                    log: true});
                var logger:* = logger();
                logger.setup(stage);
                logger.info("test");
                inputText({parent:base, left:50, top: 30});
                var list:* = list({parent: base, left: 10, top: 10});
                list.addItem(["test", "a"]);
                list.alpha=0.5;
            }
        }
        public function base(data:Object):* {
            return MinimalCompHelper.base(data);
        }
        public function panel(data:Object):* {
            return MinimalCompHelper.panel(data);
        }
        public function button(data:Object):* {
            return MinimalCompHelper.button(data);
        }
        public function inputText(data:Object):* {
            return MinimalCompHelper.inputText(data);
        }
        public function label(data:Object):* {
            return MinimalCompHelper.label(data);
        }
        public function hSlider(data:Object):* {
            return MinimalCompHelper.hSlider(data);
        }
        public function vSlider(data:Object):* {
            return MinimalCompHelper.vSlider(data);
        }
        public function comboBox(data:Object):* {
            return MinimalCompHelper.comboBox(data);
        }
        public function textArea(data:Object):* {
            return MinimalCompHelper.textArea(data);
        }
        public function window(data:Object):* {
            return MinimalCompHelper.window(data);
        }
        public function accordion(data:Object):* {
            return MinimalCompHelper.accordion(data);
        }
        public function calendar(data:Object):* {
            return MinimalCompHelper.calendar(data);
        }
        public function checkBox(data:Object):* {
            return MinimalCompHelper.checkBox(data);
        }
        public function list(data:Object):* {
            return MinimalCompHelper.list(data);
        }
        public function listItem(data:Object):* {
            return MinimalCompHelper.listItem(data);
        }
        public function progressBar(data:Object):* {
            return MinimalCompHelper.progressBar(data);
        }
        public function radioButton(data:Object):* {
            return MinimalCompHelper.radioButton(data);
        }
        public function rotarySelector(data:Object):* {
            return MinimalCompHelper.rotarySelector(data);
        }
        /**
         * about color...
         */
        public function red():void {
            MinimalCompHelper.red();
        }
        public function blue():void {
            MinimalCompHelper.blue();
        }
        public function orange():void {
            MinimalCompHelper.orange();
        }
        public function green():void {
            MinimalCompHelper.green();
        }
        public function aqua():void {
            MinimalCompHelper.aqua();
        }
        public function gray():void {
            MinimalCompHelper.gray();
        }
        /**
         * refresh minimalcomp component under obj.
         */
        public function refresh(obj:*):void {
            MinimalCompHelper.refresh(obj);
        }
        /**
         * getLogger
         */
        public function logger():Logger {
            return Logger.getLogger();
        }
    }
}

import flash.display.DisplayObjectContainer;
import flash.events.Event;
import flash.display.Sprite;
import flash.events.MouseEvent;

import com.bit101.components.*;
class MinimalCompHelper {
    public static function refresh(obj:*):void {
        try {(obj as Component).draw();}
        catch(e:Error) {}
        for(var i:int = 0;i < obj.numChildren;i ++) {
            try {refresh(obj.getChildAt(i));}
            catch(e:Error) {}
        }
    }
    private static function basic():void {
        Style.PANEL      = 0xF0F0F0; // panel only
        Style.BACKGROUND = 0xFFFFFF; // 全コンポーネントの背景色
        Style.DROPSHADOW = 0xC0C0C0; // 全コンポーネントの影(背景色と同じにすることでのっぺりにできる。)
        Style.INPUT_TEXT = 0x303030; // text on input field
        Style.LABEL_TEXT = 0x303030; // label data
        Style.embedFonts = false; // オリジナルフォントを使わないことで日本語がうてるようになる。
        Style.fontName   = "Arial";
        Style.fontSize   = 12;
    }
    public static function wText():void {Style.INPUT_TEXT = Style.LABEL_TEXT = 0xFFFFFF;}
    public static function bText():void {Style.INPUT_TEXT = Style.LABEL_TEXT = 0x303030;}
    public static function red():void    {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0xDA4F49;}
    public static function blue():void   {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x0074CC;}
    public static function orange():void {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0xFB9406;}
    public static function green():void  {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x5BB75B;}
    public static function aqua():void   {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x49AFCD;}
    public static function gray():void   {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x414141;}
    
    /**
     * 基本パネル
     */
    public static function base(data:Object):* {
        var panel:* = panel(data);
        if(data.log) {
            // ログ用のボタンを設置する。
            button({parent:panel, left: panel.width - 40, top: panel.height - 20, width:40, height:20, text:"log", func: function():void {
                Logger.getLogger().toggle();
            }});
        }
        return panel;
    }
    /**
     * パネル
     */
    public static function panel(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for panel may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var width:int = (data.width != null ? data.width : 200);
        var height:int = (data.height != null ? data.height : 200);
        var panel:Panel = new Panel(data.parent, left, top);
        panel.setSize(width, height);
        return panel;
    }
    /**
     * ボタン
     */
    public static function button(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for button may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var width:int = (data.width != null ? data.width : 100);
        var height:int = (data.height != null ? data.height : 20);
        var text:String = (data.text != null ? data.text : "");
        if(!Style.embedFonts) {
            wText();
        }
        var button:PushButton = new PushButton(parent, left, top, text, data.func);
        button.setSize(width, height);
        if(!Style.embedFonts) {
            bText();
        }
        return button;
    }
    /**
     * テキスト入力
     */
    public static function inputText(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for inputText may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var text:String = (data.text != null ? data.text : "");
        var inputText:InputText = new InputText(parent, left, top, text);
        if(data.width != null) {
            inputText.width = data.width;
        }
        if(data.height != null) {
            inputText.height = data.height;
        }
        return inputText;
    }
    /**
     * ラベル
     */
    public static function label(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for label may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var text:String = (data.text != null ? data.text : "");
        return new Label(parent, left, top, text);
    }
    /**
     * 水平スライダー
     */
    public static function hSlider(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for hSlider may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var text:String = (data.text != null ? data.text : "");
        return new HSlider(parent, left, top, data.func);
    }
    /**
     * 垂直スライダー
     */
    public static function vSlider(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for vSlider may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var text:String = (data.text != null ? data.text : "");
        return new VSlider(parent, left, top, data.func);
    }
    public static function comboBox(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for comboBox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        if(!Style.embedFonts) {
            wText();
        }
        var comboBox:ComboBox = new ComboBox(parent, left, top, data.default, data.list);
        if(!Style.embedFonts) {
            bText();
        }
        return comboBox;
    }
    public static function textArea(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for textArea may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var width:int = (data.width != null ? data.width : 100);
        var height:int = (data.height != null ? data.height : 20);
        var text:String = (data.text != null ? data.text : "");
        var area:TextArea = new TextArea(parent, left, top, text); 
        area.setSize(width, height);
        return area;
    }
    public static function window(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for window may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var width:int = (data.width != null ? data.width : 100);
        var height:int = (data.height != null ? data.height : 100);
        var window:Window = new Window(parent, left, top, data.title);
        return window;
    }
    public static function accordion(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for accordion may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var accordion:Accordion = new Accordion(parent, left, top);
        return accordion;
    }
    public static function calendar(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for calender may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var calendar:Calendar = new Calendar(parent, left, top);
        
        return calendar;
    }
    public static function checkBox(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for checkbox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var checkBox:CheckBox = new CheckBox(parent, left, top);
        return checkBox;
    }
    public static function list(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for checkbox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var list:List = new List(parent, left, top);
        return list;
//        return null;
    }
    public static function listItem(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for checkbox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var listItem:ListItem = new ListItem(parent, left, top)
        return listItem;
    }
    public static function progressBar(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for checkbox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var progressBar:ProgressBar = new ProgressBar(parent, left, top);
    }
    public static function radioButton(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for checkbox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var radioButton:RadioButton = new RadioButton(parent, left, top);
        return radioButton;
    }
    public static function rotarySelector(data:Object):* {
        var parent:* = data.parent;
        if(parent == null) {
            throw new Error("parent for checkbox may not null.");
        }
        var left:int = (data.left != null ? data.left : 0);
        var top:int  = (data.top  != null ? data.top  : 0);
        var rotarySelector:RotarySelector = new RotarySelector(parent, left, top);
        return rotarySelector;
    }
}

class Logger {
    private static var logger:Logger = new Logger();
    public static function getLogger():Logger {return logger;}
    public const FATAL:int = 0, ERROR:int = 1, WARN:int = 2, INFO:int = 3, DEBUG:int = 4;
    private static var window:Window, field:TextArea;
    private static var logStack:Array = [];
    private static var level:int, max:int;
    public function setup(base:*, level:String="INFO"):void {
        Logger.max = 2000;
        switch(level) {
            case "FATAL":
                Logger.level = FATAL;
            case "ERROR":
                Logger.level = ERROR;
            case "WARN":
                Logger.level = WARN;
            default:
            case "INFO":
                Logger.level = INFO;
            case "DEBUG":
                Logger.level = DEBUG;
        }

        window = new Window(base, 20, 20, "log");
        window.shadow = true;window.hasCloseButton = true;
        window.setSize(base.stageWidth - 40, base.stageHeight - 40);
        window.addEventListener(Event.CLOSE, function(e:Event):void {hide();});
        window.alpha = 0.7;
        field = new TextArea(window, 0, 20);
        field.setSize(window.width, window.height - 20);
        hide();
    }
    private function add(obj:*, level:String):void {
        logStack.push((new Date().toLocaleTimeString()) + "[" + level + "]" + obj.toString());
        logStack = logStack.slice(logStack.length - max, logStack.length);
        field.text = logStack.join("\n");
    }
    public function fatal(obj:*):void {add(obj, "FATAL");}
    public function error(obj:*):void {if(level < ERROR) {return;}add(obj, "ERROR");}
    public function warn(obj:*):void  {if(level < WARN)  {return;}add(obj, "WARN");}
    public function info(obj:*):void  {if(level < INFO)  {return;}add(obj, "INFO");}
    public function debug(obj:*):void {if(level < DEBUG) {return;}add(obj, "DEBUG");}
    public function toggle():void {window.visible = !window.visible;}
    public function show():void   {window.visible = true;}
    public function hide():void   {window.visible = false;}
}

class ListItem extends Component
{
    protected var _data:Object;
    protected var _label:Label;
    protected var _defaultColor:uint = 0xffffff;
    protected var _selectedColor:uint = 0xdddddd;
    protected var _rolloverColor:uint = 0xeeeeee;
    protected var _selected:Boolean;
    protected var _mouseOver:Boolean = false;
    
    /**
     * Constructor
     * @param parent The parent DisplayObjectContainer on which to add this ListItem.
     * @param xpos The x position to place this component.
     * @param ypos The y position to place this component.
     * @param data The string to display as a label or object with a label property.
     */
    public function ListItem(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, data:Object = null)
    {
        _data = data;
        super(parent, xpos, ypos);
    }
    
    /**
     * Initilizes the component.
     */
    protected override function init() : void
    {
        super.init();
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        setSize(100, 20);
    }
    
    /**
     * Creates and adds the child display objects of this component.
     */
    protected override function addChildren() : void
    {
        super.addChildren();
        _label = new Label(this, 5, 0);
        _label.draw();
    }
    
    ///////////////////////////////////
    // public methods
    ///////////////////////////////////
    
    /**
     * Draws the visual ui of the component.
     */
    public override function draw() : void
    {
        super.draw();
        graphics.clear();

        if(_selected)
        {
            graphics.beginFill(_selectedColor);
        }
        else if(_mouseOver)
        {
            graphics.beginFill(_rolloverColor);
        }
        else
        {
            graphics.beginFill(_defaultColor);
        }
        graphics.drawRect(0, 0, width, height);
        graphics.endFill();

        if(_data == null) return;

        if(_data is String)
        {
            _label.text = _data as String;
        }
        else if(_data.hasOwnProperty("label") && _data.label is String)
        {
            _label.text = _data.label;
        }
        else
        {
            _label.text = _data.toString();
        }
    }
    
    
    
    
    ///////////////////////////////////
    // event handlers
    ///////////////////////////////////
    
    /**
     * Called when the user rolls the mouse over the item. Changes the background color.
     */
    protected function onMouseOver(event:MouseEvent):void
    {
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        _mouseOver = true;
        invalidate();
    }
    
    /**
     * Called when the user rolls the mouse off the item. Changes the background color.
     */
    protected function onMouseOut(event:MouseEvent):void
    {
        removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        _mouseOver = false;
        invalidate();
    }
    
    
    
    ///////////////////////////////////
    // getter/setters
    ///////////////////////////////////
    
    /**
     * Sets/gets the string that appears in this item.
     */
    public function set data(value:Object):void
    {
        _data = value;
        invalidate();
    }
    public function get data():Object
    {
        return _data;
    }
    
    /**
     * Sets/gets whether or not this item is selected.
     */
    public function set selected(value:Boolean):void
    {
        _selected = value;
        invalidate();
    }
    public function get selected():Boolean
    {
        return _selected;
    }
    
    /**
     * Sets/gets the default background color of list items.
     */
    public function set defaultColor(value:uint):void
    {
        _defaultColor = value;
        invalidate();
    }
    public function get defaultColor():uint
    {
        return _defaultColor;
    }
    
    /**
     * Sets/gets the selected background color of list items.
     */
    public function set selectedColor(value:uint):void
    {
        _selectedColor = value;
        invalidate();
    }
    public function get selectedColor():uint
    {
        return _selectedColor;
    }
    
    /**
     * Sets/gets the rollover background color of list items.
     */
    public function set rolloverColor(value:uint):void
    {
        _rolloverColor = value;
        invalidate();
    }
    public function get rolloverColor():uint
    {
        return _rolloverColor;
    }    
}

class List extends Component
{
    protected var _items:Array;
    protected var _itemHolder:Sprite;
    protected var _panel:Panel;
    protected var _listItemHeight:Number = 20;
    protected var _listItemClass:Class =ListItem;
    protected var _scrollbar:VScrollBar;
    protected var _selectedIndex:int = -1;
    protected var _defaultColor:uint = 0xffffff;
    protected var _alternateColor:uint = 0xf3f3f3;
    protected var _selectedColor:uint = 0xcccccc;
    protected var _rolloverColor:uint = 0xdddddd;
    protected var _alternateRows:Boolean = false;
    
    /**
     * Constructor
     * @param parent The parent DisplayObjectContainer on which to add this List.
     * @param xpos The x position to place this component.
     * @param ypos The y position to place this component.
     * @param items An array of items to display in the list. Either strings or objects with label property.
     */
    public function List(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, items:Array=null)
    {
        if(items != null)
        {
            _items = items;
        }
        else
        {
            _items = new Array();
        }
        super(parent, xpos, ypos);
    }
    
    /**
     * Initilizes the component.
     */
    protected override function init() : void
    {
        super.init();
        setSize(100, 100);
        addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
        addEventListener(Event.RESIZE, onResize);
        makeListItems();
        fillItems();
    }
    
    /**
     * Creates and adds the child display objects of this component.
     */
    protected override function addChildren() : void
    {
        super.addChildren();
        _panel = new Panel(this, 0, 0);
        _panel.color = _defaultColor;
        _itemHolder = new Sprite();
        _panel.content.addChild(_itemHolder);
        _scrollbar = new VScrollBar(this, 0, 0, onScroll);
        _scrollbar.setSliderParams(0, 0, 0);
    }
    
    /**
     * Creates all the list items based on data.
     */
    protected function makeListItems():void
    {
        while(_itemHolder.numChildren > 0) _itemHolder.removeChildAt(0);

        var numItems:int = Math.ceil(_height / _listItemHeight);
        for(var i:int = 0; i < numItems; i++)
        {

            var item:ListItem = new _listItemClass(_itemHolder, 0, i * _listItemHeight);
            item.setSize(width, _listItemHeight);
            item.defaultColor = _defaultColor;

            item.selectedColor = _selectedColor;
            item.rolloverColor = _rolloverColor;
            item.addEventListener(MouseEvent.CLICK, onSelect);
        }
    }

    protected function fillItems():void
    {
        var offset:int = _scrollbar.value;
        var numItems:int = Math.ceil(_height / _listItemHeight);
        
        for(var i:int = 0; i < numItems; i++)
        {
            var item:ListItem = _itemHolder.getChildAt(i) as ListItem;
            item.data = _items[offset + i];
            if(_alternateRows)
            {
                item.defaultColor = ((offset + i) % 2 == 0) ? _defaultColor : _alternateColor;
            }
            else
            {
                item.defaultColor = _defaultColor;
            }
            if(offset + i == _selectedIndex)
            {
                item.selected = true;
            }
            else
            {
                item.selected = false;
            }
        }
    }
    
    /**
     * If the selected item is not in view, scrolls the list to make the selected item appear in the view.
     */
    protected function scrollToSelection():void
    {
        var numItems:int = Math.ceil(_height / _listItemHeight);
        if(_selectedIndex != -1)
        {
            if(_scrollbar.value > _selectedIndex)
            {
//                    _scrollbar.value = _selectedIndex;
            }
            else if(_scrollbar.value + numItems < _selectedIndex)
            {
                _scrollbar.value = _selectedIndex - numItems + 1;
            }
            fillItems();
        }
    }
    
    
    
    ///////////////////////////////////
    // public methods
    ///////////////////////////////////
    
    /**
     * Draws the visual ui of the component.
     */
    public override function draw() : void
    {
        super.draw();
        
        _selectedIndex = Math.min(_selectedIndex, _items.length - 1);


        // panel
        _panel.setSize(_width, _height);
        _panel.color = _defaultColor;
        _panel.draw();
        
        // scrollbar
        _scrollbar.x = _width - 10;
        var contentHeight:Number = _items.length * _listItemHeight;
        _scrollbar.setThumbPercent(_height / contentHeight); 
        var pageSize:Number = _height / _listItemHeight;
        _scrollbar.maximum = Math.max(0, _items.length - pageSize);
        _scrollbar.pageSize = pageSize;
        _scrollbar.height = _height;
        _scrollbar.draw();
        scrollToSelection();
    }
    
    /**
     * Adds an item to the list.
     * @param item The item to add. Can be a string or an object containing a string property named label.
     */
    public function addItem(item:Object):void
    {
        _items.push(item);
        invalidate();
        fillItems();
    }
    
    /**
     * Adds an item to the list at the specified index.
     * @param item The item to add. Can be a string or an object containing a string property named label.
     * @param index The index at which to add the item.
     */
    public function addItemAt(item:Object, index:int):void
    {
        index = Math.max(0, index);
        index = Math.min(_items.length, index);
        _items.splice(index, 0, item);
        invalidate();
        fillItems();
    }
    
    /**
     * Removes the referenced item from the list.
     * @param item The item to remove. If a string, must match the item containing that string. If an object, must be a reference to the exact same object.
     */
    public function removeItem(item:Object):void
    {
        var index:int = _items.indexOf(item);
        removeItemAt(index);
    }
    
    /**
     * Removes the item from the list at the specified index
     * @param index The index of the item to remove.
     */
    public function removeItemAt(index:int):void
    {
        if(index < 0 || index >= _items.length) return;
        _items.splice(index, 1);
        invalidate();
        fillItems();
    }
    
    /**
     * Removes all items from the list.
     */
    public function removeAll():void
    {
        _items.length = 0;
        invalidate();
        fillItems();
    }
    
    
    
    
    
    ///////////////////////////////////
    // event handlers
    ///////////////////////////////////
    
    /**
     * Called when a user selects an item in the list.
     */
    protected function onSelect(event:Event):void
    {
        if(! (event.target is ListItem)) return;
        
        for(var i:int = 0; i < _itemHolder.numChildren; i++)
        {
            if(_itemHolder.getChildAt(i) == event.target) _selectedIndex = i;
            ListItem(_itemHolder.getChildAt(i)).selected = false;
        }
        ListItem(event.target).selected = true;
        dispatchEvent(new Event(Event.SELECT));
    }
    
    /**
     * Called when the user scrolls the scroll bar.
     */
    protected function onScroll(event:Event):void
    {
        fillItems();
    }
    
    /**
     * Called when the mouse wheel is scrolled over the component.
     */
    protected function onMouseWheel(event:MouseEvent):void
    {
        _scrollbar.value -= event.delta;
        fillItems();
    }

    protected function onResize(event:Event):void
    {
        makeListItems();
        fillItems();
    }
    ///////////////////////////////////
    // getter/setters
    ///////////////////////////////////
    
    /**
     * Sets / gets the index of the selected list item.
     */
    public function set selectedIndex(value:int):void
    {
        if(value >= 0 && value < _items.length)
        {
            _selectedIndex = value;
//                _scrollbar.value = _selectedIndex;
            invalidate();
            dispatchEvent(new Event(Event.SELECT));
        }
    }
    public function get selectedIndex():int
    {
        return _selectedIndex;
    }
    
    /**
     * Sets / gets the item in the list, if it exists.
     */
    public function set selectedItem(item:Object):void
    {
        var index:int = _items.indexOf(item);
        if(index != -1)
        {
            selectedIndex = index;
            invalidate();
            dispatchEvent(new Event(Event.SELECT));
        }
    }
    public function get selectedItem():Object
    {
        if(_selectedIndex >= 0 && _selectedIndex < _items.length)
        {
            return _items[_selectedIndex];
        }
        return null;
    }

    /**
     * Sets/gets the default background color of list items.
     */
    public function set defaultColor(value:uint):void
    {
        _defaultColor = value;
        invalidate();
    }
    public function get defaultColor():uint
    {
        return _defaultColor;
    }

    /**
     * Sets/gets the selected background color of list items.
     */
    public function set selectedColor(value:uint):void
    {
        _selectedColor = value;
        invalidate();
    }
    public function get selectedColor():uint
    {
        return _selectedColor;
    }

    /**
     * Sets/gets the rollover background color of list items.
     */
    public function set rolloverColor(value:uint):void
    {
        _rolloverColor = value;
        invalidate();
    }
    public function get rolloverColor():uint
    {
        return _rolloverColor;
    }

    /**
     * Sets the height of each list item.
     */
    public function set listItemHeight(value:Number):void
    {
        _listItemHeight = value;
        makeListItems();
        invalidate();
    }
    public function get listItemHeight():Number
    {
        return _listItemHeight;
    }

    /**
     * Sets / gets the list of items to be shown.
     */
    public function set items(value:Array):void
    {
        _items = value;
        invalidate();
    }
    public function get items():Array
    {
        return _items;
    }

    /**
     * Sets / gets the class used to render list items. Must extend ListItem.
     */
    public function set listItemClass(value:Class):void
    {
        _listItemClass = value;
        invalidate();
    }
    public function get listItemClass():Class
    {
        return _listItemClass;
    }

    /**
     * Sets / gets the color for alternate rows if alternateRows is set to true.
     */
    public function set alternateColor(value:uint):void
    {
        _alternateColor = value;
        invalidate();
    }
    public function get alternateColor():uint
    {
        return _alternateColor;
    }
    
    /**
     * Sets / gets whether or not every other row will be colored with the alternate color.
     */
    public function set alternateRows(value:Boolean):void
    {
        _alternateRows = value;
        invalidate();
    }
    public function get alternateRows():Boolean
    {
        return _alternateRows;
    }

    /**
     * Sets / gets whether the scrollbar will auto hide when there is nothing to scroll.
     */
    public function set autoHideScrollBar(value:Boolean):void
    {
        _scrollbar.autoHide = value;
    }
    public function get autoHideScrollBar():Boolean
    {
        return _scrollbar.autoHide;
    }
}
















