/**
 * Copyright j2e ( http://wonderfl.net/user/j2e )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Xqo
 */

// forked from undo's カメラ映像を分解したり戻したり
/*
* カメラ画像を取得してRGBに分解します。
* 画面をクリックすると分割した画像を1点に重ねます。
* 背景が黒、ブレンドモードがADDなら元画像と同じになるはずです。
* ブレンドモードをいじったりしてみてください。
*/
package
{
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.system.Security;
    import flash.system.SecurityPanel;
    
    [SWF(backgroundColor = 0x0)]

    public class CameraTests extends Sprite
    {
        public function CameraTests()
        {
            Wonderfl.capture_delay(1);
                stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            this.camWidth = this.stage.stageWidth/2;
            this.camHeight = this.stage.stageHeight/2;
            init();
        }

        private var _cam:Camera;
        private var _vid:Video;
        private var _bmd:BitmapData;

        private var _redBmd:BitmapData;
        private var _greenBmd:BitmapData;
        private var _blueBmd:BitmapData;

        private var _rbm:Bitmap;
        private var _gbm:Bitmap;
        private var _bbm:Bitmap;

        private var camWidth:Number;
        private var camHeight:Number;
        private var camFPS:Number = 15;

        private var bMode:String = BlendMode.DIFFERENCE;
        private var conved:Boolean = false;
        private function init():void
        {
            Security.allowDomain('*');
            
            _cam = Camera.getCamera();
            if(!_cam) return;
            
            _vid = new Video(camWidth, camHeight);
            _cam.setMode(camWidth, camHeight, camFPS);
            _vid.attachCamera(_cam);
            _bmd = new BitmapData(camWidth, camHeight, false);
            _redBmd = new BitmapData(camWidth, camHeight, false,0);
            _greenBmd = new BitmapData(camWidth, camHeight, false,0);
            _blueBmd = new BitmapData(camWidth, camHeight, false,0);

            _rbm = new Bitmap(_redBmd);
            _gbm = new Bitmap(_greenBmd);
            _bbm = new Bitmap(_blueBmd);            
            
            _rbm.y = _gbm.y = camHeight;
            _bbm.x = _gbm.x = camWidth;
            
            
            var rsp:Sprite = new Sprite();
            var gsp:Sprite = new Sprite();
            var bsp:Sprite = new Sprite();
            
            rsp.cacheAsBitmap = true;
            gsp.cacheAsBitmap = true;
            bsp.cacheAsBitmap = true;
            
            this.addChild(new Bitmap(_bmd));
            
            this.addChild(_rbm);
            this.addChild(_gbm);
            this.addChild(_bbm);
            
            _rbm.blendMode = bMode;
            _gbm.blendMode = bMode;
            _bbm.blendMode = bMode;

            addEventListener(Event.ENTER_FRAME, onEnter);

            stage.addEventListener(MouseEvent.CLICK, onClick);
        }

        private function onEnter(evt:Event):void
        {
            var matrix:Matrix = new Matrix();
            matrix.scale(-1, 1);
            matrix.translate(camWidth, 0);
            _redBmd.draw(_vid, matrix);
            _redBmd.draw(_bmd, null, null, BlendMode.DIFFERENCE);
            _bmd.draw(_vid, matrix);
            //_redBmd.draw(_vid, matrix);
            
            //_rbm.draw(_vid);
            //feed.copyPixels(buffer, rect, pnt);
            //buffer.draw(prev, null, null, BlendMode.DIFFERENCE);
            //prev.draw(video);
            //canvas.copyPixels(buffer, rect, pnt);
            
            //_redBmd.copyChannel(_bmd, _bmd.rect, new Point(), 1, 1);
            
            _greenBmd.copyChannel(_bmd, _bmd.rect, new Point(), 2, 2);
            _blueBmd.copyChannel(_bmd, _bmd.rect, new Point(), 4, 4);
        }
        private function onClick(evt:MouseEvent):void
        {
            trace(conved);
            Tweener.removeAllTweens();
            if(conved)
            {
                Tweener.addTween(_rbm, {x:0, time:1, transition:"easeInOutCubic"});
                Tweener.addTween(_bbm, {y:0, time:1, transition:"easeInOutCubic"});
                conved = false;
            }
            else
            {
                Tweener.addTween(_rbm, {x: camWidth, time: 1, transition: "easeInOutCubic"});
                Tweener.addTween(_bbm, {y: camHeight, time: 1, transition: "easeInOutCubic"});
                conved = true;
            }
        }


        /*
         * functions
         */
        private function selectCamera():void
        {
            //ダイアログを表示して、ユーザにカメラを選択してもらう
            Security.showSettings(SecurityPanel.CAMERA);
        }

        private function setCamToVideo(c:Camera, v:Video = null):Video
        {
            //Videoへカメラを設定する
            if (!v)
                v = new Video();

            v.attachCamera(c);
            return v;
        }
    }
}
