/**
 * Copyright ton ( http://wonderfl.net/user/ton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Xlb
 */

package
{
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.flashdynamix.utils.SWFProfiler;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.System;
    import net.hires.debug.Stats;
    
    public class Main extends Sprite 
    {
        private var GUI:Sprite;        
        private var slider:HSlider;
        private var label:Label;
        private var button:PushButton;
        
        public function Main():void 
        {
            GUI = new Sprite();
            addChild(GUI);
            
            slider = new HSlider(GUI, 0, 4, changeLabel);
            slider.maximum = 100;
            slider.tick = 1;
            slider.value = 75;
            
            label = new Label(GUI, slider.width, 0, String(slider.value / 100));
            
            button = new PushButton(GUI, label.x + label.width, 0, "GC!", changeImminence);
            
            GUI.x = stage.stageWidth - GUI.width - 150;
            GUI.y = stage.stageHeight - GUI.height - 10;
            
            SWFProfiler.init(this);        
            
            var stats:Stats = new Stats( { bg:0x0, fps:0x0, ms:0x0, mem:0xff0000, memmax:0x00ff00 } );
            stats.scaleX = stats.scaleY = 3;
            stats.y = 120
            addChild(stats);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function changeLabel(e:Event):void 
        {
            label.text = String(slider.value/100);            
        }
        
        private function changeImminence(e:Event):void 
        {
            System.pauseForGCIfCollectionImminent(slider.value / 100);
        }
        
        private function update(e:Event):void 
        {
            for (var i:int = 0; i < 20; i++) 
            {
                new MovieClip();
            }                
        }
    }
}