/**
 * Copyright nappingjellyfish ( http://wonderfl.net/user/nappingjellyfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7XcB
 */

package 
{
    import away3d.materials.ColorMaterial;
    import away3d.primitives.SphereGeometry;
    import flash.display.Sprite;
    import flash.events.Event;
    [SWF(backgroundColor="#000000", frameRate="30", width="465", height="465")]
    /**
     * ...
     * @author njf
     */
    public class Main extends Sprite 
    {
        public var prm:MainParameters;
        public static var instance:Main;
        /****************
         * コンストラクタ
         * **************/
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
            instance = this;
        }
        /****************
         * 初期化
         * **************/
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            ExFileLoader.instance.addEventListener(ExFileLoader.LOAD_END, onExFileLoadEndHandler);
            ExFileLoader.instance.startLoad();
            
            
        }
        /****************
         * 外部ファイル読み込み終了
         * **************/
        private function onExFileLoadEndHandler(e:Event):void 
        {
            prm = new MainParameters();
             addChild(prm.mainSprite);
            initCamera();
            initViews();
            initObjects();
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }
        /****************
         * camera初期化
         * **************/
        private function initCamera():void 
        {
            prm.camera = prm.view.camera;
            prm.camera.lens.far = 14000;
            prm.camera.lens.near = 0.05;
            prm.camera.x = 0;
            prm.camera.z = 1;
            prm.camera.y = 300;
            prm.cameraController = new CameraController(prm.camera);
            prm.camera.lookAt(Constants.CENTER_POINT);
            prm.cameraController.addEventListener(AnimationEvent.ST_END, animationEventHandler);
        }
         
         
        /****************
         * view 初期化
         * **************/
        private function initViews():void 
        {
            var m:ColorMaterial = new ColorMaterial();
            var s:SphereGeometry = new SphereGeometry();
            prm.mainSprite.addChild(prm.view);

        }
        
        /****************
         * object初期化
         * **************/
        private function initObjects():void 
        {
            prm.starSkyBoxControler = new StarSkyBoxControler(prm.view.scene);
            prm.magicCircle = new MagicCircle(prm.view);
            prm.magicCircle.addEventListener(AnimationEvent.ST_END, animationEventHandler);
        
            InitialCards.initAllCards(prm.view);
            for (var i:int = 0; i < InitialCards.instances.length; i++) 
            {
                InitialCards.instances[i].addEventListener(AnimationEvent.ST_END, animationEventHandler);
            }
            CardExplodeControl.init(prm.view.scene, prm.camera);
            StarParticleControl.init(prm.view.scene);
            EndCard.initCard(prm.view);
            BackWing.initBackWing(prm.view);
            LevelUp.initLevelUp(prm.view);
            PostFilterControl.init(prm.view);

        }
        /****************
         * アニメーション進行制御
         * **************/
        private function animationEventHandler(e:AnimationEvent):void 
        {
            if (e.detail == MagicCircle.EVENT_APPEAR_END) {
                prm.cameraController.down();
            }else if (e.detail == CameraController.CAMERA_DOWN) {
                InitialCards.appear();
            }else if (e.detail == InitialCards.EVENT_APPEAR_END) {
                prm.cameraController.down2();
            }else if (e.detail == CameraController.CAMERA_DOWN2) {
                CardExplodeControl.start();
            }    
        }
        
        /****************
         * enterframe
         * **************/
        private function onEnterFrameHandler(e:Event):void 
        {
            renderViews();
        }
        /****************
         * render all views
         * **************/
        private function renderViews():void 
        {
            prm.magicCircle.enterFrame();
            prm.cameraController.enterFrame();
            InitialCards.enterFrameAll();
            CardExplodeControl.enterFrame();
            StarParticleControl.instance.enterFrame();
            EndCard.instance.enterFrame();
            BackWing.enterFrame();
            LevelUp.enterFrame();
            PostFilterControl.instance.enterFrame();
            prm.view.render();
        }
        
        
        
        
        
        
    }
    
}
import flash.system.LoaderContext;

import a24.tween.Ease24;
import a24.tween.Tween24;
import a24.tween.Tween24Event;
import away3d.cameras.Camera3D;
import away3d.containers.ObjectContainer3D;
import away3d.containers.Scene3D;
import away3d.containers.View3D;
import away3d.entities.Mesh;
import away3d.entities.Sprite3D;
import away3d.filters.BloomFilter3D;
import away3d.filters.RadialBlurFilter3D;
import away3d.lights.DirectionalLight;
import away3d.lights.PointLight;
import away3d.materials.ColorMaterial;
import away3d.materials.lightpickers.StaticLightPicker;
import away3d.materials.TextureMaterial;
import away3d.primitives.PlaneGeometry;
import away3d.primitives.SkyBox;
import away3d.primitives.SphereGeometry;
import away3d.textures.BitmapCubeTexture;
import away3d.utils.Cast;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.GradientType;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.filters.BitmapFilter;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.geom.Vector3D;
import flash.net.URLRequest;
//------------------------------------
// 共通定数
//------------------------------------
class Constants {
    public static const CENTER_POINT:Vector3D = new Vector3D();
    public static const ZERO_2D_POINT:Point = new Point();
    public static const MAGIC_CIRCLE_RADIUS:int = 128;
    public static const CAMERA_HEIGHT:int = 120;
    public static const COLOR_MAGICK_CIRCLE:uint = 0x00FFFF;
    public static const CARD_NUM:int = 7;
    public static const CARD_COLOR:Array = [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF, 0xFFFFFF];
    public static const CARD_HEIGHT:int = 30;
    public static const CARD_CENTER_HEIGHT:int = 50;
}

//------------------------------------
// 外部ファイル読み込み(singleton)
//------------------------------------
class ExFileLoader extends EventDispatcher {
    public static const KIRA02:String = "http://assets.wonderfl.net/images/related_images/3/31/3167/31679ab5ea5e6b984bd4476ca107be3bf2c37391";
    public static const BG2:String = "http://assets.wonderfl.net/images/related_images/6/6a/6a39/6a39d24903a88ef0e43693fa953fb2aabe242387";
    public static const CARD01:String = "http://assets.wonderfl.net/images/related_images/f/fc/fcfb/fcfb1f18a586ad79fd30a5c08cb4f267e9714530";
    public static const CARD02:String = "http://assets.wonderfl.net/images/related_images/c/c3/c3b9/c3b9c082c57786d6d70cd72f342b232942865a1c";
    public static const MAGIC:String = "http://assets.wonderfl.net/images/related_images/d/d3/d3a6/d3a65301bb89f0e7db4ea5b727224b8b944fba97";
    public static const LUVP02:String = "http://assets.wonderfl.net/images/related_images/e/ef/efdd/efdd32f0082c3456d2268d25c487a3fc1bb12d33";
    
    public static const LOAD_END:String = "exFileLoaderAllLoaded";
    public static const IO_ERROR:String = "exFileLoaderIOError";
    
    private static var _instance:ExFileLoader;
    
    private static const fileNames:Array = [
        BG2,CARD01,CARD02,MAGIC,LUVP02,KIRA02
    ];
    private var loaders:Array;
    private var loadCnt:int;
    
    public function ExFileLoader():void 
    {
    }
    public static function get instance():ExFileLoader {
        if (!_instance) {
            _instance = new ExFileLoader();
        }
        return _instance;
    }
    public function startLoad():void {
        loaders = new Array();
         var context:LoaderContext = new LoaderContext();
          context.checkPolicyFile = true;
        for (var i:int = 0; i < fileNames.length; i++) 
        {
            var loader:Loader = new Loader();
            loaders[i] = loader;
            var s:String = "";
            var request:URLRequest = new URLRequest(fileNames[i]);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
            loader.load(request,context);
            loadCnt++;
        }
    }
    
    private function loadCompleteHandler(e:Event):void {
        loadCnt--;
        if (loadCnt <= 0) {
            allLoaded();
        }
    }
    protected function ioErrorHandler(event:IOErrorEvent):void 
    {
        trace("ExFileLoader:ioErrorHandler", event.toString());
        trace(new Error().getStackTrace());
        dispatchEvent(new Event(IO_ERROR));
    }
    private function allLoaded():void {
        dispatchEvent(new Event(LOAD_END));
    }
    public function getData(type:String):* {
        var idx:int = fileNames.indexOf(type);
        return loaders[idx].content;
    }
}
//------------------------------------
// Mainクラス用パラメーター格納クラス
//------------------------------------
class MainParameters {
    
    public var mainSprite:Sprite = new Sprite();
    public var camera:Camera3D;
    public var view:View3D = new View3D();
    
    public var magicCircle:MagicCircle;
    public var starSkyBoxControler:StarSkyBoxControler;
    
    public var cameraController:CameraController;
    
}
//------------------------------------
// skeybox制御
//------------------------------------
class StarSkyBoxControler {
    private var cubeTexture:BitmapCubeTexture;
    private var mesh:Mesh;
    private var scene:Scene3D;
    
    private const SIZE:int = 1024;
    private const NUM:int = 900;
    private const CUBE_PLANE_NUM:int = 6;
    
    public function StarSkyBoxControler(scene:Scene3D) 
    {
        super();
        this.scene = scene;
        initObjects();
    }
    private function initObjects():void 
    {
        var r:Rectangle = new Rectangle();
        var bmps:Vector.<BitmapData> = new Vector.<BitmapData>;
        var p:Point = new Point();
    
        var num:int = NUM;
        for (var j:int = 0; j < CUBE_PLANE_NUM; j++) {
            var bmpd:BitmapData = new BitmapData(SIZE, SIZE, true, 0xFF000000);
            for (var i:int = 0; i < num; i++) 
            {
                r.x = SIZE * Math.random();
                r.y = SIZE * Math.random();
                if (i < 0.92*num) {
                    r.width = r.height = 1;
                }else if (i < 0.98*num) {
                    r.width = r.height = 2;
                }else {
                    r.width = r.height = 3;
                }
                
                var red:int = rnd();
                var green:int = rnd();
                var blue:int = rnd();
                var color:uint = (red << 16) | (green << 8) | (blue);
                bmpd.fillRect(r, 0xFF000000|color);
            }
            r.x = r.y = 0;
            r.width = SIZE;
            r.height = SIZE;
            bmpd.applyFilter(bmpd, r, p, new BlurFilter(1,1,5));
            
            bmps.push(bmpd);
            
            function rnd():int 
            {
                return 0xFF * (0.7 + 0.3 * Math.random());
            }
            
        }
        cubeTexture = new BitmapCubeTexture(bmps[0], bmps[1], bmps[2], bmps[3], bmps[4], bmps[5]);
        scene.addChild(new SkyBox(cubeTexture));
    }
}
//------------------------------------
// Utility
//------------------------------------
class NjfUtility {
    
    /****************
     * 入力画像を2^nのサイズにして真ん中寄せ
     * **************/
    public static function getBmpForTexture(i_bmpd:BitmapData):BitmapData
    {
        
        var wp:int = Math.ceil(Math.log(i_bmpd.width) / Math.log(2));
        var hp:int = Math.ceil(Math.log(i_bmpd.height) / Math.log(2));
        var w:int = Math.pow(2, wp);
        var h:int = Math.pow(2, hp);
        var retBmpd:BitmapData = new BitmapData(w, h, true, 0);
        var r:Rectangle = new Rectangle(0,0, i_bmpd.width, i_bmpd.height);
        var p:Point = new Point(w / 2 - i_bmpd.width / 2, h / 2 - i_bmpd.height / 2);
        retBmpd.copyPixels(i_bmpd, r, p, null, null, true);
        return retBmpd;
    }
    /****************
     * 入力画像を2^nのサイズにして真ん中寄せ+フィルター
     * **************/
    public static function getBmpForTextureApplyFilter(i_bmpd:BitmapData,filter:BitmapFilter):BitmapData
    {
        
        var wp:int = Math.ceil(Math.log(i_bmpd.width) / Math.log(2));
        var hp:int = Math.ceil(Math.log(i_bmpd.height) / Math.log(2));
        var w:int = Math.pow(2, wp);
        var h:int = Math.pow(2, hp);
        var retBmpd:BitmapData = new BitmapData(w, h, true, 0);
        var r:Rectangle = new Rectangle(0,0, i_bmpd.width, i_bmpd.height);
        var p:Point = new Point(w / 2 - i_bmpd.width / 2, h / 2 - i_bmpd.height / 2);
        retBmpd.applyFilter(i_bmpd, r, p, filter);
        return retBmpd;
    }
}
//------------------------------------
// Bitmap　Textureの平面のベースクラス
//------------------------------------
class PlaneWidhBitmapTexture extends Mesh {
    public var textureId:String;
    public var textureBitmapData:BitmapData;
    public var imageRect:Rectangle = new Rectangle();
    protected var textureMaterial:TextureMaterial;
    protected var statusFuncs:Object = new Object();
    protected var planeGeometory:PlaneGeometry;
    
    protected var frmCnt:int = 0;
    public static const ST_INIT:int = 0;
    protected var tween:Tween24;
    protected var _status:int = ST_INIT;
    
    protected var view:View3D;

    
    public function PlaneWidhBitmapTexture(textureId:String,view:View3D,segmentX:int=4,segmentY:int=4) {
        this.textureId = textureId;
        var bmpd:BitmapData = Bitmap(ExFileLoader.instance.getData(textureId)).bitmapData;
        textureBitmapData = NjfUtility.getBmpForTexture(bmpd);
        imageRect.x = textureBitmapData.width / 2 - bmpd.width / 2;
        imageRect.y = textureBitmapData.height / 2 - bmpd.height / 2;
        imageRect.width = bmpd.width;
        imageRect.height = bmpd.height;
        planeGeometory= new PlaneGeometry(textureBitmapData.width, textureBitmapData.height, segmentX, segmentX, true);
        textureMaterial = new TextureMaterial(Cast.bitmapTexture(textureBitmapData));
        textureMaterial.alphaBlending = true;
        textureMaterial.bothSides = true;
        super(planeGeometory, textureMaterial);
        visible = false;
        this.view = view;
        init();
    }
    protected function init():void 
    {
        initStatusFunc();
        view.scene.addChild(this);
    }
    
    protected function initStatusFunc():void 
    {
        
    }
    
    public function enterFrame():void 
    {
        frmCnt++;
        if (statusFuncs.hasOwnProperty(_status)) {
            statusFuncs[_status]();
        }
    }
    
    public function get status():int 
    {
        return _status;
    }
    
    public function set status(value:int):void 
    {
        if (_status == value) {
            return;
        }
        statusChange(_status, value);
        _status = value;
    }
    protected function statusChange(prevStatus:int,nextStatus:int):void 
    {
        frmCnt = 0;
    }
    
}
//------------------------------------
// 魔方陣
//------------------------------------
class MagicCircle extends PlaneWidhBitmapTexture{
    
    public static const ST_APPEAR:int = 1;
    public static const ST_LIGHT:int = 2;
    public static const ST_NONE:int = 99;
    public static const EVENT_APPEAR_END:String = "MagicCircleAppearEnd";
    
    
    private var light:DirectionalLight;
    public function MagicCircle(view:View3D)
    {
        super(ExFileLoader.MAGIC,view,8,8);
    }
    
    
    override protected function init():void 
    {

        super.init();
        
        visible = true;
        status = ST_APPEAR;
        scale(0.01);
        tween = Tween24.parallel (
            Tween24.tween(this, 1,Ease24._6_ExpoInOut).scaleX(1),
            Tween24.tween(this, 1,Ease24._6_ExpoInOut).scaleY(1),
            Tween24.tween(this, 1,Ease24._6_ExpoInOut).scaleZ(1)
        );
        tween.play();
        light = new DirectionalLight();
        view.scene.addChild(light);
        light.x = light.z = 0;
        light.y = 200;
        light.ambient = 1;
        textureMaterial.ambient = 1;
        textureMaterial.specular = 0.8; 
        light.lookAt(Constants.CENTER_POINT);
        textureMaterial.lightPicker = new StaticLightPicker([light]);
        material = textureMaterial;
        tween.addEventListener(Tween24Event.COMPLETE, onAppearEnd);
    }
    override protected function initStatusFunc():void 
    {
        super.initStatusFunc();
        statusFuncs[ST_LIGHT] = lightStatusFunc;
        
    }
    private var alpha:Number = 0;
    private function lightStatusFunc():void 
    {
        alpha += 0.1;
        alpha = alpha > 1 ? 1:alpha;
        var t:BitmapData=NjfUtility.getBmpForTextureApplyFilter(Bitmap(ExFileLoader.instance.getData(ExFileLoader.MAGIC)).bitmapData,
        new GlowFilter(0x00FFFF,alpha,12,12,2,3));
        textureMaterial.texture = Cast.bitmapTexture(t);
        if (alpha == 1) {
            status = ST_NONE;
            var e:AnimationEvent = new AnimationEvent(AnimationEvent.ST_END);
            e.detail = EVENT_APPEAR_END;
            dispatchEvent(e);
        }
    }
    
    private function onAppearEnd(e:Tween24Event):void 
    {
        status = ST_LIGHT;
    }
    
    override protected function statusChange(prevStatus:int, nextStatus:int):void 
    {
        super.statusChange(prevStatus, nextStatus);
    }
    
}
//------------------------------------
// アニメーションイベント
//------------------------------------
class AnimationEvent extends Event 
{
    public static const ST_END:String = "AnimationEventStEnd";
    public var detail:String = "";
    public function AnimationEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 
    { 
        super(type, bubbles, cancelable);
        
    } 
    

    public override function toString():String 
    {
        return formatToString("AnimationEvent", "type", "bubbles", "cancelable", "eventPhase"); 
    }
    
}
/****************
 * カメラ制御
 * **************/
class CameraController extends EventDispatcher{
    private var camera:Camera3D;
    private var tween:Tween24;
    public static const CAMERA_DOWN:String = "cameraControlCamaraDown";
    public static const CAMERA_DOWN2:String = "cameraControlCamaraDown2";
    public static var instance:CameraController;
    private var explodeId:int;
    public var lookAtPoint:Vector3D = new Vector3D();
    
    private var zoomTween:Tween24;
    
    public function CameraController(camera:Camera3D) 
    {
        this.camera = camera;
        instance = this;
        zoomTween=Tween24.parallel(
            Tween24.tween(camera, 0.5, Ease24._2_QuadInOut).z(Constants.MAGIC_CIRCLE_RADIUS*2/3),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).y(Constants.CARD_CENTER_HEIGHT),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).z(0)
            )
    }
    
    public function down():void 
    {
        tween=Tween24.parallel(
            Tween24.tween(camera, 1, Ease24._2_QuadInOut).z(Constants.MAGIC_CIRCLE_RADIUS+10),
            Tween24.tween(camera, 1, Ease24._2_QuadInOut).y(Constants.CAMERA_HEIGHT)
            );
        tween.play();
        tween.addEventListener(Tween24Event.COMPLETE, onDwoun);
    }
    private function onDwoun(e:Tween24Event):void 
    {
        var ae:AnimationEvent = new AnimationEvent(AnimationEvent.ST_END);
        ae.detail = CAMERA_DOWN;
        dispatchEvent(ae);
    }
    
    public function down2():void 
    {
        var nlp:Vector3D = InitialCards.instances[0].position;
        tween=Tween24.parallel(
            Tween24.tween(camera, 0.5, Ease24._2_QuadInOut).z(Constants.MAGIC_CIRCLE_RADIUS+10),
            Tween24.tween(camera, 0.5, Ease24._2_QuadInOut).y(Constants.CARD_HEIGHT),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).x(nlp.x),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).y(nlp.y),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).z(nlp.z)
            );
        tween.play();
        tween.addEventListener(Tween24Event.COMPLETE, onDwoun2);
    }
    private function onDwoun2(e:Tween24Event):void 
    {
        var ae:AnimationEvent = new AnimationEvent(AnimationEvent.ST_END);
        ae.detail = CAMERA_DOWN2;
        dispatchEvent(ae);
    }
    
    public function explodePan(id:int):void 
    {

        var a:Number = 0;
        var toX:int = 0;
        var toZ:int = 0;
        if (id < Constants.CARD_NUM - 1) {
            a = -id * Math.PI * 2 / (Constants.CARD_NUM - 1);    
        }
        toX = (Constants.MAGIC_CIRCLE_RADIUS + 10)  * Math.sin(a);
        toZ = (Constants.MAGIC_CIRCLE_RADIUS + 10)  * Math.cos(a);
        
        var nlp:Vector3D = InitialCards.instances[id].position;
        
        tween=Tween24.parallel(
            Tween24.tween(camera, 0.5, Ease24._2_QuadInOut).x(toX),
            Tween24.tween(camera, 0.5, Ease24._2_QuadInOut).z(toZ),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).x(nlp.x),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).y(nlp.y),
            Tween24.tween(lookAtPoint, 0.5, Ease24._2_QuadInOut).z(nlp.z)
            );
        tween.play();
        explodeId = id;
        
        
        tween.addEventListener(Tween24Event.COMPLETE, onPanEnd);
    }
    
    public function zoomEndCard():void 
    {
        zoomTween.play();

    }
    
    
    private function onPanEnd(e:Tween24Event):void 
    {
        CardExplodeControl.explodeStart();
    }
    
    public function enterFrame():void 
    {
        camera.lookAt(lookAtPoint);
    }
    
}

//------------------------------------
// 合成前カード
//------------------------------------
class InitialCards extends PlaneWidhBitmapTexture{
    public static var instances:Vector.<InitialCards> = new Vector.<InitialCards>;
    public var id:int = 0;
    private static const EXPLODE_FRM_CNT:int = 30;
    public static const ST_APPEAR:int = 1;
    
    public static const ST_WAIT:int = 2;
    public static const ST_EXPLODE:int = 3;
    public static const ST_EXPLODED:int = 4;
    
    public static const EVENT_APPEAR_END:String = "InitialCardsAppearEnd";
    
    private var initHeight:int = 0;
    private var w:Number;
    private var s:int = 1;
    
    
    public static function enterFrameAll():void 
    {
        for (var i:int = 0; i < instances.length; i++) 
        {
            instances[i].enterFrame();
        }
    }
    
    public static function initAllCards(view:View3D):void 
    {
        for (var i:int = 0; i < Constants.CARD_NUM; i++) 
        {
            new InitialCards(view);
        }
    }
    
    public static function appear():void 
    {
        var arr:Array = new Array();
        for (var i:int = 0; i < instances.length; i++) 
        {
            arr.push(instances[i]);
            instances[i]._appear();
        }
    }
    
    public function InitialCards(view:View3D)
    {
        id = instances.length;
        var cardImageId:String = "";
        if (id == Constants.CARD_NUM-1) {
            cardImageId = ExFileLoader.CARD01;
        }else {
            cardImageId = ExFileLoader.CARD02;
        }
        super(cardImageId,view);
        
    }
    override protected function init():void 
    {
        super.init();
        rotationX = 90;
        rotationY = 90;
        instances.push(this);
        if (id < Constants.CARD_NUM - 1) {
            var a:Number = -id * Math.PI * 2 / (Constants.CARD_NUM - 1);
            x = Constants.MAGIC_CIRCLE_RADIUS * 0.6 * Math.sin(a);
            z = Constants.MAGIC_CIRCLE_RADIUS * 0.6 * Math.cos(a);
            scale(0.2);
            initHeight = Constants.CARD_HEIGHT;
        }else {
            scale(0.3);
            initHeight = Constants.CARD_CENTER_HEIGHT;
        }
        y = initHeight;
        
        textureMaterial.ambient =  0.5;
        textureMaterial.gloss = 0.5;
        textureMaterial.specular = 0.5; 
        textureMaterial.lightPicker = InitialCardLightController.instance.getLightPicker();
        
        material = textureMaterial;
        
    }
    override protected function initStatusFunc():void 
    {
        super.initStatusFunc();
        statusFuncs[ST_APPEAR] = appearing;
        statusFuncs[ST_WAIT] = wait;
        statusFuncs[ST_EXPLODE] = explode;
    }
    
    private function _appear():void 
    {
        visible = true;
        textureMaterial.alpha = 0;
        status = ST_APPEAR;

        
    }
    private function appearing():void 
    {
        var b:Boolean = false;
        if (frmCnt < id * 10) return;
        if (textureMaterial.alpha < 1) {
            textureMaterial.alpha += 0.1;
        }else {
            textureMaterial.alpha = 1;
            b = true;
        }
        var goalY:Number = 0;
        if (Math.abs(rotationY -goalY)>1) {
            rotationY += (goalY - rotationY) * 0.2;
        }else {
            rotationY = 0;
            if (b) {
                status = ST_WAIT;
                w = (0.5 - Math.random()) * Math.PI / 4;
                s = Math.random() < 0.5? -1:1;
                frmCnt = 0;
                if (id == Constants.CARD_NUM - 1) {
                    var e:AnimationEvent = new AnimationEvent(AnimationEvent.ST_END);
                    e.detail = EVENT_APPEAR_END;
                    dispatchEvent(e);
                }
            }
        }
    }
    private function wait():void 
    {
        y = initHeight + s*4 * Math.sin(frmCnt * (Math.PI + w) / 80);
        rotationY = s*5* Math.sin(frmCnt * (Math.PI-w) / 70);
        rotationX = 90 + s*8* Math.sin(frmCnt * (Math.PI+2*w) / 100);
    }
    
    public function explodeStart():void 
    {
        status = ST_EXPLODE;
    }
    
    public function explode():void 
    {
        textureMaterial.texture = Cast.bitmapTexture(NjfUtility.getBmpForTextureApplyFilter(Bitmap(ExFileLoader.instance.getData(textureId)).bitmapData, new GlowFilter(Constants.CARD_COLOR[id]|0x666666, 1, frmCnt*4,frmCnt*4, 2, 2, true)));
        if (frmCnt > 20) {
            
            
            textureMaterial.alpha *= 0.8;
            if (textureMaterial.alpha < 0.1) {
                explodeEnd();
            }
        }else if (frmCnt == 20) {
            StarParticleControl.instance.emit(id);
        }else {
            y += (0.5 - Math.random());
        }
    }
    private function explodeEnd():void 
    {
        view.scene.removeChild(this);
        status = ST_EXPLODED;
        if (id < Constants.CARD_NUM - 1) {
            CardExplodeControl.start();
        }
        
    }
    
    override public function enterFrame():void 
    {
        super.enterFrame();
        
        
        
    }

}
//------------------------------------
// カード照明制御
//------------------------------------
class InitialCardLightController {
    //singleton
    private static var _instance:InitialCardLightController;
    
    private var cardStarLights:Array = new Array();
    private var lightPicker:StaticLightPicker; 
    
    private static const COLOR_OFFSET:uint = 0xF6A6A6;
    public function InitialCardLightController()
    {
        for (var i:int = 0; i <Constants.CARD_NUM-1; i++) 
        {
            var csl:PointLight = new PointLight();
            csl.ambientColor = Constants.COLOR_MAGICK_CIRCLE | COLOR_OFFSET;
            csl.specular = 0.15;
            csl.diffuse = 0.4;
            csl.color=Constants.COLOR_MAGICK_CIRCLE | COLOR_OFFSET;
            cardStarLights.push(csl);
            
            if (i < Constants.CARD_NUM - 1) {
                var a:Number = -(i + 0.5) * Math.PI * 2 / (Constants.CARD_NUM - 1) * 2;
                a = i * Math.PI * 2 / (Constants.CARD_NUM - 1);
                csl.x = 2*Constants.MAGIC_CIRCLE_RADIUS  * Math.sin(a);
                csl.z = 2*Constants.MAGIC_CIRCLE_RADIUS  * Math.cos(a);
            }
            csl.y = 10;
            Main.instance.prm.view.scene.addChild(csl);
        }
        lightPicker = new StaticLightPicker(cardStarLights);
    }
    public function getLightPicker():StaticLightPicker
    {
        return lightPicker;
    }
    
    
    public static function get instance():InitialCardLightController 
    {
        if (!_instance) {
            _instance = new InitialCardLightController();
        }
        return _instance;
    }
    public function setY(y:Number):void 
    {
        for (var i:int = 0; i < cardStarLights.length; i++) 
        {
            var csl:PointLight = cardStarLights[i];
            csl.y = y;
        }
    }

    
    
    
}
//------------------------------------
// カード爆発効果
//------------------------------------
class ExplodeCardEffect extends ObjectContainer3D{
    
    private var lightBeamBitmapData:BitmapData;
    private var workSp:Sprite
    private var meshes:Vector.<Mesh> = new Vector.<Mesh>;
    private var material:TextureMaterial;
    private var status:int = 0;
    private static const ST_INIT:int = 0;
    private static const ST_END:int = 1;
    private var frmCnt:int = 0;
    
    private var startFlg:Boolean = false;
    public var endFlg:Boolean = false;
    
    private var meshOmega:Vector.<Number> = new Vector.<Number>;
    
    private var colorSphereMaterial:ColorMaterial;
    private var centerSphere:Mesh;
    private var color:uint;
    
    private var aura:Mesh;
    
    private var auraMaterial:TextureMaterial;
    
    public function ExplodeCardEffect(color:uint) 
    {
        this.color = color;
        workSp = new Sprite();
        var lineB:BitmapData = makeEachLightBeam();
        
        material = new TextureMaterial(Cast.bitmapTexture(lineB));
        
        var plane:PlaneGeometry = new PlaneGeometry(lineB.width, lineB.height,1,1);
        material.alphaBlending = true;
        
        for (var i:int = 0; i < 20; i++) 
        {
            var mesh:Mesh = new Mesh(plane, material);
            mesh.rotationZ = Math.random() * 360;
            mesh.rotationY = Math.random() * 20;
            mesh.rotationX = 90;
            meshes.push(mesh);
            mesh.scale(0.3*(0.5+Math.random()*0.5));
            meshOmega.push( 4 * (Math.random() - 0.5) );
            addChild(mesh);
        }
        var sphere:SphereGeometry = new SphereGeometry(40);
        
        colorSphereMaterial = new ColorMaterial(color, 0.2);
        centerSphere = new Mesh(sphere, colorSphereMaterial);
        centerSphere.scale(0.2);
        colorSphereMaterial.alphaBlending = true;
        addChild(centerSphere);
        
        var auraB:BitmapData = makeKourin();
        auraMaterial = new TextureMaterial(Cast.bitmapTexture(auraB));
        auraMaterial.alphaBlending = true;
        var auraGeometry:PlaneGeometry = new PlaneGeometry(auraB.width, auraB.height);
        aura = new Mesh(auraGeometry, auraMaterial);
        aura.rotationX = 90;
        aura.scale(0.1);
        addChild(aura);
        scale(0.4);
        
        visible = false;
    }
    
    public function start():void 
    {
        visible = true;
        startFlg = true;
    }
    
    
    private function makeEachLightBeam():BitmapData 
    {
        var v:Vector.<Number> = new Vector.<Number>;
        var r:Number = 1000;
        var ang:Number = (Math.random() * 0.5 + 0.5) * Math.PI / 12;
        
        v[0] = 0;
        v[1] = 0;
        
        for (var i:int = 1; i < 3; i++) 
        {
            var a:Number =   ang * (i - 1-1/2);
            v[2*i] = r * Math.cos(a);
            v[2*i+1] = r * Math.sin(a);
            
        }
        
        var m:Matrix = new Matrix();
        m.scale(0.5, 0.5);
        workSp.graphics.beginGradientFill(GradientType.RADIAL, [color,color], [1,0], [0,255],m);
        workSp.graphics.drawTriangles(v);
        workSp.graphics.endFill();
        workSp.filters = [new BlurFilter(5, 5, 3)];
        
        var w:int = 2;
        var h:int = 2;
        
        while (w < workSp.width) {
            w *= 2;
        }
        while (h < workSp.height) {
            h *= 2;
        }

        
        var bmpd:BitmapData = new BitmapData(w, h, true, 0);
        m = new Matrix();
        m.translate( w / 2, h / 2);
        bmpd.draw(workSp,m);
        return bmpd;
    }
    private function makeKourin():BitmapData {
        var r:int = 100;
        workSp.graphics.clear();
        workSp.graphics.beginGradientFill(GradientType.RADIAL, [color,color,color,color,color,color], [0.1,0.6,0,2,0.4, 0], [0,40,80,100,140, 255]);
        workSp.graphics.drawCircle(0, 0, r);
        workSp.filters = [new BlurFilter(5,5,3)];
        var w:int = 2;
        var h:int = 2;
        while (w < workSp.width) {
            w *= 2;
        }
        while (h < workSp.height) {
            h *= 2;
        }
        var m:Matrix = new Matrix();
        var bmpd:BitmapData = new BitmapData(w, h, true, 0);
        m.translate( w / 2, h / 2);
        bmpd.draw(workSp,m);
        return bmpd;
    }
    
    
    public function draw():void 
    {
        if (!startFlg || endFlg) {
            return;
        }
        frmCnt++;
        
        if (status == ST_INIT) {
            centerSphere.scale(1.03);
            if (colorSphereMaterial.alpha < 0.5) {
                colorSphereMaterial.alpha *= 1.1;
            }
            
            for (var i:int = 0; i < meshes.length; i++) 
            {
                var m:Mesh = meshes[i];
                if (frmCnt < 20) {
                    m.rotationZ += meshOmega[i]/2;
                    m.scale(1.02);
                }else if (m.scaleX < 3) {
                    m.rotationZ += meshOmega[i];
                    m.scale(1.4);
                }else {
                    status = ST_END;
                    break;
                }
            }
            
        }else {
            //centerSphere.scale(1.2);
            if (colorSphereMaterial.alpha > 0.01) {
                colorSphereMaterial.alpha *= 0.6;
                material.alpha *= 0.8;
            }else {
                colorSphereMaterial.alpha = 0;
                material.alpha = 0;
            }
        }
        if (frmCnt > 20) {
            if (auraMaterial.alpha > 0.1) {
                aura.scale(1.5);
                auraMaterial.alpha *= 0.94;
            }else {
                auraMaterial.alpha = 0;
                endFlg = true;
            }
            
        }
        
    }
    
}
//------------------------------------
// カード爆発効果制御
//------------------------------------
class CardExplodeControl {
    //singleton
    private static var _instance:CardExplodeControl;
    private var explodeCardEffects:Vector.<ExplodeCardEffect> = new Vector.<ExplodeCardEffect>;
    private var scene:Scene3D;
    private static var camera:Camera3D;
    private var id:int = 0;
    public static function init(scene:Scene3D,camera:Camera3D):void 
    {
        CardExplodeControl.camera = camera;
        _instance = new CardExplodeControl(scene);
    }
    
    public function CardExplodeControl(scene:Scene3D)
    {
        _init(scene);
    }
    
    
    private function _init(scene:Scene3D):void 
    {
        this.scene = scene;
        for (var i:int = 0; i < Constants.CARD_NUM; i++) 
        {
            var ece:ExplodeCardEffect = new ExplodeCardEffect(Constants.CARD_COLOR[i]|0x666666);
            explodeCardEffects.push(ece);
            if (i < Constants.CARD_NUM - 1) {
                var a:Number = -i * Math.PI * 2 / (Constants.CARD_NUM - 1);
                ece.x = Constants.MAGIC_CIRCLE_RADIUS * 0.61 * Math.sin(a);
                ece.z = Constants.MAGIC_CIRCLE_RADIUS * 0.61 * Math.cos(a);
                ece.y = Constants.CARD_HEIGHT;
            }else {
                ece.y = Constants.CARD_CENTER_HEIGHT;
            }
            scene.addChild(ece);
            
        }
    }

    
    private function _start():void 
    {
        CameraController.instance.explodePan(id);
    
        
    }
    
    public static function explodeStart():void 
    {
        InitialCards.instances[_instance.id].explodeStart();
        _instance.explodeCardEffects[_instance.id].start();
        _instance.explodeCardEffects[_instance.id].y = InitialCards.instances[_instance.id].y;
        _instance.explodeCardEffects[_instance.id].lookAt(camera.position);
        _instance.id++;
    }
    public static function start():void 
    {
        _instance._start();
    }
    
    private function _enterFrame():void 
    {
        for (var i:int = 0; i < Constants.CARD_NUM; i++) 
        {
            explodeCardEffects[i].draw();
        }
        
    }
    public static function enterFrame():void 
    {
        _instance._enterFrame();
        
    }
    
    
}
//------------------------------------
// 星パーティクル
//------------------------------------
class StarParticle{
    private var sprite3d:Sprite3D;
    private var material:TextureMaterial;
    private var textureBitmapData:BitmapData;
    private var textureTwinkleBitmapData:BitmapData;
    
    public static var scene:Scene3D;
    private var type:int = 0;
    private var vel:Vector3D = new Vector3D();
    private var acc:Vector3D = new Vector3D();
    
    private var statusFunc:Object = new Object();
    private var status:int = 0;
    
    private var twinkeFlg:Boolean = false;
    private static const MAX_TWINKLE_CNT:int = 5;
    private var twinkleFrmCnt:int = MAX_TWINKLE_CNT*Math.random();
    
    private static const ST_INIT:int = 0;
    private static const ST_TORNADO:int = 1;
    private static const ST_SCATTER:int = 2;
    
    private static const INIT_VEL:Number = 10;
    
    public static var ringY:Number = 0;
    private var tornadeFrmCnt:int = 0;
    private static const REGIST:Number = 0.01;
    
    private var collapseFlg:Boolean = false;
    
    private var magneticField:Number = 0.175;
    
    public function StarParticle(type:int)
    {
        this.type = type;
        var color:uint = Constants.CARD_COLOR[type];
        var bmpd:BitmapData = Bitmap(ExFileLoader.instance.getData(ExFileLoader.KIRA02)).bitmapData;
        
        
        var cR:uint = 1+((color & 0x010000)>>16);
        var cG:uint = 1+((color & 0x000100)>>8);
        var cB:uint = 1+((color & 0x010001));
        var r:Rectangle = new Rectangle(0, 0, bmpd.width, bmpd.height);
        bmpd.colorTransform(r,new ColorTransform(cR, cG, cB));
        textureBitmapData = NjfUtility.getBmpForTextureApplyFilter(bmpd, new GlowFilter(color, 0.8, 6, 6, 2, 6));
        textureTwinkleBitmapData = NjfUtility.getBmpForTextureApplyFilter(bmpd, new GlowFilter(0xFFFFFF, 1, 6, 6, 3, 6));
        material = new TextureMaterial(Cast.bitmapTexture(textureBitmapData));
        material.alphaBlending = true;
        sprite3d = new Sprite3D(material, 15, 15);
        sprite3d.visible = false;
        scene.addChild(sprite3d);
        
        
        setStFunc();
    }
    
    private function setStFunc():void 
    {
        statusFunc[ST_INIT] = stInitFunc;
        statusFunc[ST_TORNADO] = stTornadoFunc;
        statusFunc[ST_SCATTER] = stScatterSFun;
    }
    
    private function stInitFunc():void 
    {
        var l:Number = vel.normalize();
        l *= 0.9;
        vel.scaleBy(l);

    }
    private function stTornadoFunc():void 
    {
        tornadeFrmCnt++;
        var c:Vector3D = sprite3d.position.clone();
        c.y -= ringY;
        var l:Number = c.normalize();
        var a:Number = 0.25 ;
        var b:Number = magneticField ;
        var r:Number = REGIST ;
        var s:int = type % 2 == 0 ? 1: -1;
        
        if (tornadeFrmCnt < 10) {
            acc.x += s * c.z * a ;
            acc.z += -s * c.x * a ;
        }else {
            acc.x = -c.x * a - r * vel.x + s * c.z * b;
            acc.z = -c.z * a - r * vel.z - s * c.x * b;
            acc.y = -a * c.y - r * vel.y;
        }
        l = vel.normalize();
        vel.scaleBy(l * 0.935);
        if (tornadeFrmCnt == 120) {
            EndCard.instance.startTransition();
        }
        if (collapseFlg) {
            if (sprite3d.position.length > Math.abs(sprite3d.y) + 2) {
                magneticField -= 0.01;
                ringY += 0.0012;
            }else {
                collapseFlg = false;
            }
        }

    }
    public function startTornade():void 
    {
        status = ST_TORNADO;
    }
    
    public function startScatter():void 
    {
        status = ST_SCATTER;
        vel.x = rnd() * INIT_VEL/2;
        vel.y = -Math.random() *  INIT_VEL/2;
        vel.z = Math.random() * INIT_VEL/2;
    }
    private function stScatterSFun():void 
    {
        var l:Number = vel.normalize();
        l *= 0.99;
        vel.scaleBy(l);
    }
    
    
    public function emit(x:int,y:int,z:int):void 
    {
        sprite3d.visible = true;
        sprite3d.x = x;
        sprite3d.y = y;
        sprite3d.z = z;
        vel.x = rnd()*INIT_VEL;
        vel.y = rnd()*INIT_VEL;
        vel.z = rnd()*INIT_VEL;
    }
    
    private function rnd():Number {
        return 0.5 - Math.random();
    }
    
    
    public function collapse():void 
    {
        collapseFlg = true;
    }
    
    public function enterFrame():void 
    {
        if (statusFunc.hasOwnProperty(status)) {
            statusFunc[status]();
        }
        vel.x += acc.x;
        vel.y += acc.y;
        vel.z += acc.z;
        sprite3d.x += vel.x;
        sprite3d.y += vel.y;
        sprite3d.z += vel.z;
        
        twinkleFrmCnt--;
        if (twinkleFrmCnt < 0) {
            if (twinkeFlg) {
                twinkleFrmCnt = (0.5+Math.random()) * MAX_TWINKLE_CNT*5;
                material.texture = Cast.bitmapTexture(textureBitmapData);
            }else {
                twinkleFrmCnt = (0.5+Math.random()) * MAX_TWINKLE_CNT;
                material.texture = Cast.bitmapTexture(textureTwinkleBitmapData);
            }
            twinkeFlg = !twinkeFlg;
        }
    }
    
    
    
}
//------------------------------------
// 星パーティクル制御
//------------------------------------
class StarParticleControl 
{
    private static var _instance:StarParticleControl;
    
    private static const EACH_PARTICLE_NUM:int = 50;
    
    private var usingFlg:Boolean = false;
    
    private var particles:Vector.<StarParticle> = new Vector.<StarParticle>;
    
    private var frmCnt:int = 0;
    
    private var collapseFrmCnt:int = 0;
    
    public static function init(scene:Scene3D):void 
    {
        StarParticle.scene = scene;
        _instance = new StarParticleControl();
    }
    
    public function StarParticleControl()
    {
        for (var i:int = 0; i < Constants.CARD_NUM; i++) 
        {
            for (var j:int = 0; j < EACH_PARTICLE_NUM; j++) 
            {
                particles.push(new StarParticle(i));
            }
        }
    }
    public function emit(type:int):void 
    {
        var c:Vector3D = InitialCards.instances[type].position;
        for (var i:int = type*EACH_PARTICLE_NUM; i < (type+1)*EACH_PARTICLE_NUM; i++) 
        {
            var p:StarParticle = particles[i];
            p.emit(c.x,c.y,c.z);
            
        }
        if (type == Constants.CARD_NUM - 1) {
            frmCnt = -30;
        }
        usingFlg = true;
    }
    public function enterFrame():void 
    {
        if (!usingFlg) return;
        frmCnt ++;
        collapseFrmCnt++;
        for (var i:int = 0; i < EACH_PARTICLE_NUM*Constants.CARD_NUM; i++) 
        {
            var p:StarParticle = particles[i];
            p.enterFrame();
        }
        if (frmCnt == 0) {
            for (i =  0; i < EACH_PARTICLE_NUM*Constants.CARD_NUM; i++) 
            {
                p = particles[i];
                p.startTornade();
                PostFilterControl.instance.applyFilter(PostFilterControl.BLOOM);
            }
        }
        if (collapseFrmCnt == 0) {
//            Main.instance.prm.view.filters3d = [new RadialBlurFilter3D(0,1.2,1,1,0.5,0.5)];
            for (i =  0; i < EACH_PARTICLE_NUM*Constants.CARD_NUM; i++) 
            {
                p = particles[i];
                p.startScatter();
            }
            BackWing.appear();
        }
    }
    public function collapse():void 
    {
        var p:StarParticle;
        for (var i:int =  0; i < EACH_PARTICLE_NUM*Constants.CARD_NUM; i++) 
        {
            p = particles[i];
            p.collapse();
        }
        PostFilterControl.instance.clearFilter(PostFilterControl.BLOOM);
        collapseFrmCnt = -40;
    }
    static public function get instance():StarParticleControl 
    {
        return _instance;
    }
    
}
//------------------------------------
// フィルター制御
//------------------------------------
class PostFilterControl {
    public static var instance:PostFilterControl;
    private var view:View3D;
    private var rbf:RadialBlurFilter3D = new RadialBlurFilter3D(0, 1, 1, -0.2);
    private var bf:BloomFilter3D = new BloomFilter3D(0, 0, 0.75,0);
    private var bfBlurLen:Number = 0;
    private var filterApplyFlg:Boolean = false;
    private var s:Number = 0;
    private var bfs:Number = 0;
    private var intensity:Number = 0;
    private static const MAX_INTENSITY:Number = 2;
    private static const MAX_BLUR_LEN:int = 10;
    
    public static const RADIAL_BLUR:int = 0;
    public static const BLOOM:int = 1;
    
    public static function init(view:View3D):void 
    {
        instance = new PostFilterControl(view);
        
        
    }
    
    public function PostFilterControl(view:View3D)
    {
        this.view = view;
    }
    
    public function applyFilter(type:int):void 
    {
        if (type == RADIAL_BLUR) {
            s = 0.2;
        }else {
            bfs = 0.1;
        }
    }
    
    public function clearFilter(type:int):void 
    {
        if (type == RADIAL_BLUR) {
            s = -0.2;
        }else {
            bfs = -1;
        }
    }
    
    private function bloomEntrFrame():void 
    {
        if (bfs == 0) return;
        if (bfs > 0 && bfBlurLen < MAX_BLUR_LEN) {
            bfBlurLen += bfs;
            bf.blurX=bf.blurY = bfBlurLen;
            if (bfBlurLen > MAX_BLUR_LEN) {
                bfs = 0;
                bfBlurLen = MAX_BLUR_LEN;
            }
            bf.exposure = bfBlurLen / 5;
            view.filters3d = [bf];
        }
        if (bfs < 0 && bfBlurLen > 0) {
            bfBlurLen += bfs;
            bf.blurX=bf.blurY = bfBlurLen;
            if (bfBlurLen < 0.01) {
                bfs = 0;
                bfBlurLen = 0;
                view.filters3d = [];
            }else {
                bf.exposure = bfBlurLen / 5;
                view.filters3d = [bf];
            }
        }
    }
    private function radialBlurEntrFrame():void 
    {
        if (s == 0) return;
        if (s > 0 && intensity < MAX_INTENSITY) {
            intensity += s;
            rbf.intensity = intensity;
            if (intensity > MAX_INTENSITY) {
                s = 0;
                intensity = MAX_INTENSITY;
            }
            view.filters3d = [rbf];
        }
        if (s < 0 && intensity > 0) {
            intensity += s;
            rbf.intensity = intensity;
            if (intensity < 0.01) {
                s = 0;
                intensity = 0;
                view.filters3d = [];
            }else {
                view.filters3d = [rbf];
            }
        }
    }
    
    
    public function enterFrame():void 
    {
        radialBlurEntrFrame();
        bloomEntrFrame();
        
    }
    
    
    
}

//------------------------------------
// 最後のカード
//------------------------------------
class EndCard extends PlaneWidhBitmapTexture {
    private var cardImageId:String = "";
    private var perlinBitMapData:BitmapData;
    private var workBitMapData:BitmapData;
    private var cardBitmapData:BitmapData;
    private var nowDotNum:int = 0;
    //private var drawBitMapData:BitmapData;
    private var glowBitMapData:BitmapData;
    private var maskBitmapData:BitmapData;
    private var maskWorkBitmapData:BitmapData;
    private var endFlg:Boolean = false;
    private var startFlg:Boolean = false;
    
    public static var instance:EndCard;

    private static const scaleFactor:Number = 0.3;
    public function EndCard(view:View3D) 
    {
        cardImageId = ExFileLoader.CARD01;
        super(cardImageId, view);
    }
    override protected function init():void 
    {
        super.init();
        cardBitmapData = Bitmap(ExFileLoader.instance.getData(cardImageId)).bitmapData;
        
        perlinBitMapData = new BitmapData(imageRect.width, imageRect.height, true, 0xFFFFFFFF);
        //drawBitMapData = new BitmapData(imageRect.width, imageRect.height, true, 0);
        workBitMapData = new BitmapData(imageRect.width, imageRect.height, true, 0);
        glowBitMapData = new BitmapData(imageRect.width, imageRect.height, true, 0);
        maskWorkBitmapData = new BitmapData(imageRect.width, imageRect.height, true, 0);
        maskBitmapData = new BitmapData(imageRect.width, imageRect.height * 2, true, 0xFFFFFFFF);
        var r:Rectangle = new Rectangle(0, 0, imageRect.width, imageRect.height);
        maskBitmapData.fillRect(r, 0);
        r.height = imageRect.height / 255;
        for (var i:int = 0; i < 255; i++) 
        {
            r.y = i * imageRect.height / 255+imageRect.height;
            maskBitmapData.fillRect(r, 0xFFFFFF | ((0xFF * i) << 16));
        }
        perlinBitMapData.perlinNoise(imageRect.width /5, imageRect.height / 2, 1, Math.random() * 0xFFFF, false, false, 0x08);
        r.height = imageRect.height;
        r.y = 0;
        perlinBitMapData.colorTransform(r, new ColorTransform(1, 1, 1, 0.5, 0, 0, 0,0x7F));
        var cardBitMap:Bitmap = new Bitmap(cardBitmapData);
        frmCnt = 0;
        
        r.x = r.y = 0;
        r.width = textureBitmapData.width;
        r.height = textureBitmapData.height;
        textureBitmapData.fillRect(r, 0);
        textureMaterial.texture = Cast.bitmapTexture(textureBitmapData);
        y = Constants.CARD_CENTER_HEIGHT;
        rotationX = -90;
        scale(scaleFactor);
        StarParticle.ringY = y - imageRect.height / 2 * scaleFactor;
        textureMaterial.ambient =  .2;
        textureMaterial.gloss = 3;
        textureMaterial.specular = 0.8; 
        material.lightPicker = InitialCardLightController.instance.getLightPicker();
    }
    
    public static function initCard(view:View3D):void 
    {
        instance = new EndCard(view);
    }
    
    public function startTransition():void 
    {
        startFlg = true;
        visible = true;
        frmCnt = 0;
        CameraController.instance.zoomEndCard();

    }
    
    override public function enterFrame():void 
    {
        super.enterFrame();
        drawCard();
        y = Constants.CARD_CENTER_HEIGHT + 5 * Math.sin(frmCnt/100);
    }
    
    private function drawCard():void 
    {
        if (endFlg) return;
        if (!startFlg) return;
        transition();
        if (frmCnt > 256*0.8) {
            endFlg = true;
            var r:Rectangle = new Rectangle(0, 0, imageRect.width, imageRect.height);
            var p:Point = new Point(imageRect.x, imageRect.y);
            textureBitmapData.copyPixels(cardBitmapData, r, p);
            textureMaterial.texture = Cast.bitmapTexture(textureBitmapData);
            StarParticle.ringY = Constants.CARD_CENTER_HEIGHT + imageRect.height / 2 * scaleFactor;
            StarParticleControl.instance.collapse();
        }
    }
    private function transition():void 
    {
        var r:Rectangle = new Rectangle(0, 0, imageRect.width, imageRect.height);
        
        frmCnt++;
        var p:Point = new Point();
        
        var mr:Rectangle = new Rectangle(0, frmCnt < 512?frmCnt:512,imageRect.width , imageRect.height);
        workBitMapData.copyPixels(perlinBitMapData, r, p,maskWorkBitmapData);
        maskWorkBitmapData.copyPixels(maskBitmapData, mr, p,null,null,true);
        glowBitMapData.copyPixels(workBitMapData, r, p,maskWorkBitmapData);
        glowBitMapData.threshold(workBitMapData, r, p, "<", 0x50000000, 0, 0xFFFF0000);
        workBitMapData.threshold(workBitMapData, r, p, "<", 0x7F000000, 0, 0xFF000000);
        glowBitMapData.colorTransform(r, new ColorTransform(1, 1, 1, 4,255,255,255));
        workBitMapData.colorTransform(r, new ColorTransform(0, 0, 0, 2));
        p.x = imageRect.x;
        p.y = imageRect.y;
        textureBitmapData.copyPixels(glowBitMapData, r, p);
        textureBitmapData.copyPixels(cardBitmapData, r, p, workBitMapData, null, true);
        textureMaterial.texture = Cast.bitmapTexture(textureBitmapData);
        var ry:Number = Constants.CARD_CENTER_HEIGHT - (imageRect.height / 2 -mr.y) * scaleFactor;
        ry = ry < Constants.CARD_CENTER_HEIGHT + imageRect.height / 2 * scaleFactor?ry : Constants.CARD_CENTER_HEIGHT + imageRect.height / 2 * scaleFactor;
        InitialCardLightController.instance.setY(ry);
        StarParticle.ringY = ry - 1;
    }
}
//------------------------------------
// 羽背景
//------------------------------------
class BackWing extends PlaneWidhBitmapTexture {
    private static var _instance:BackWing;
    public static const ST_APPEAR:int = 1;
    private var endFlg:Boolean = false;
    public static function initBackWing(view:View3D):void 
    {
        _instance = new BackWing(view);
    }
    
    public function BackWing(view:View3D) {
        super(ExFileLoader.BG2, view, 8, 8);
        
    }
    override protected function init():void 
    {
        super.init();
        rotationX = -90;
        z = -20;
        y = Constants.CARD_CENTER_HEIGHT+40;
    }
    
    public static function appear():void 
    {
        if (_instance) {
            _instance._appear();
        }
    }
    
    private function _appear():void 
    {
        frmCnt = 0;
        textureMaterial.alpha = 0.2;
        visible = true;
        status = ST_APPEAR;
        scale(0.1);
        PostFilterControl.instance.applyFilter(PostFilterControl.RADIAL_BLUR);

    }
    override protected function initStatusFunc():void 
    {
        super.initStatusFunc();
        statusFuncs[ST_APPEAR] = stAppear;
    }
    private function stAppear():void 
    {
        if (textureMaterial.alpha <= 1) {
            textureMaterial.alpha += 0.1;
        }
        if (scaleX < 0.28) {
            scale(1.1);
        }
        if (frmCnt > 60 && !endFlg) {
            PostFilterControl.instance.clearFilter(PostFilterControl.RADIAL_BLUR);
            LevelUp.appear();
            endFlg = true;
        }
    }
    
    public static function enterFrame():void 
    {
        if (_instance) {
            _instance.enterFrame();
        }
    }
    
}
//------------------------------------
// レベルアップ文字
//------------------------------------
class LevelUp extends PlaneWidhBitmapTexture {
    private static var _instance:LevelUp;
    public static const ST_APPEAR:int = 1;
    
    public static function initLevelUp(view:View3D):void 
    {
        _instance = new LevelUp(view);
    }
    
    public function LevelUp(view:View3D) {
        super(ExFileLoader.LUVP02, view, 8, 8);
        
    }
    override protected function init():void 
    {
        super.init();
        rotationX = -90;
        rotationY = 180;
        z = 0;
        y = Constants.CARD_CENTER_HEIGHT-30;
    }
    
    public static function appear():void 
    {
        if (_instance) {
            _instance._appear();
        }
    }
    
    private function _appear():void 
    {
        frmCnt = 0;
        textureMaterial.alpha = 0.2;
        visible = true;
        status = ST_APPEAR;
        scale(0.1);
    }
    override protected function initStatusFunc():void 
    {
        super.initStatusFunc();
        statusFuncs[ST_APPEAR] = stAppear;
    }
    private function stAppear():void 
    {
        if (textureMaterial.alpha <= 1) {
            textureMaterial.alpha += 0.1;
        }
        if (scaleX < 0.25) {
            scale(1.4);
        }
    }
    
    public static function enterFrame():void 
    {
        if (_instance) {
            _instance.enterFrame();
        }
    }
    
}





