/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7XMa
 */

// forked from ProjectNya's Bubble
////////////////////////////////////////////////////////////////////////////////
// Bubble
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            draw();
            create();
        }
        private function create():void {
            var bubble:Bubble = new Bubble();
            addChild(bubble);
            bubble.x = 232;
            bubble.y = 232;
        }
        private function draw():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 465, 0.5*Math.PI, 0, 0);
            graphics.beginGradientFill(GradientType.LINEAR, [0x00AAE4, 0x0069A0], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var label:Label = new Label(200, 60, 60, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 132;
            label.textColor = 0xFFFFFF;
            label.text = "wonderfl";
            label.alpha = 0.4;
        }
        
    }

}


//////////////////////////////////////////////////
// Bubbleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.BlendMode;

class Bubble extends Sprite {
    private static var radius:uint = 10;
    private var _scale:Number = 1;

    public function Bubble() {
        draw();
    }

    private function draw():void {
        var circle:Shape = new Shape();
        addChild(circle);
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0.5*Math.PI, -radius*1.5, -radius*0.5);
        circle.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0xCCCCCC], [1, 0.3], [0, 255], matrix);
        circle.graphics.drawCircle(0, 0, radius);
        circle.graphics.endFill();
        circle.blendMode = BlendMode.LIGHTEN;
        //
        var light:Shape = new Shape();
        addChild(light);
        var _matrix:Matrix = new Matrix();
        _matrix.createGradientBox(radius*0.8, radius*0.8, 0.5*Math.PI, -radius*0.4, -radius*0.6);
        light.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0x0069A0], [1, 0.5], [0, 255], _matrix);
        light.graphics.drawEllipse(-radius*0.4, -radius*0.3, radius*0.8, radius*0.6);
        light.graphics.endFill();
        light.x = radius*0.45;
        light.y = -radius*0.45;
        light.rotation = 45;
        light.blendMode = BlendMode.LIGHTEN;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
