/**
 * Copyright terra1119 ( http://wonderfl.net/user/terra1119 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7XB2
 */

package {
	import flash.display.Stage;//Flashコンテンツが表示される領域に関するクラス
	import flash.display.StageScaleMode;//Flashの表示の種類であるスケールモードに関するクラス
	import flash.display.StageAlign;//Flashコンテンツの位置を指定するクラス
	import flash.display.StageQuality;//Flashの画質を指定するクラス
	import flash.display.Sprite;//タイムラインを持たない基本表示リストクラス
	import flash.display.BitmapData;//ビットマップの画像処理をするクラス
	import flash.display.Bitmap;//BitmapDataをFlashPlayer上で表示するためのクラス
	import flash.geom.Matrix;//Flashで行列を扱うためのクラス
	import flash.geom.Rectangle;//任意の位置からの領域を指定するクラス
	import flash.events.Event;//Eventオブジェクトを作成するための基本クラス
	import flash.events.MouseEvent;//マウスイベントに関するクラス
	import flash.events.ProgressEvent;//ロード処理中のイベントに関するクラス
	
	import org.papervision3d.view.BasicView;//簡易的にPV3Dを初期化するクラス
	import org.papervision3d.objects.DisplayObject3D;//PV3Dの3Dオブジェクトの親バージョンにあたるクラス
	import org.papervision3d.objects.primitives.Plane;//PV3Dの平面オブジェクトに関するクラス
	import org.papervision3d.materials.BitmapMaterial;//PV3Dオブジェクトに貼り付けるビットマップ画像テクスチャに関するクラス
	import org.papervision3d.events.InteractiveScene3DEvent;//PV3Dオブジェクトのマウスイベントに関するクラス
	import org.papervision3d.materials.special.ParticleMaterial;//PV3Dのパーティクルオブジェクトに関するクラス
	import org.papervision3d.objects.special.ParticleField;//PV3Dのパーティクルオブジェクトを配置するフィールドに関するクラス
	import org.papervision3d.materials.ColorMaterial;

	import caurina.transitions.Tweener;//トゥイーンアニメーションクラス
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")]
	
	//BasicViewクラスを継承したドキュメントクラスMain
	public class Main extends BasicView {
		
		private const CONTENTS_MAX:int=30;//画像枚数
		private const DISTANCE:Number=500;//3Dオブジェクトを配置する際の定数
		private var theta:Number=0;//カメラを回す値
		private var no:int=4;//3Dオブジェクトの配置パターンid
		private var selectedId:int=0;//現在選ばれている画像id
		private var imgArray:Array=[];//画像を格納する配列
		private var objs:Array=[];//3Dオブジェクトを格納する配列
		private var oldCameraX:Number;//カメラのx座標を保持する変数
		private var oldCameraY:Number;//カメラのy座標を保持する変数
		private var oldCameraZ:Number;//カメラのz座標を保持する変数
		private var oldRotX:Number;//選択中3Dオブジェクトのx軸を保持する変数
		private var oldRotY:Number;//選択中3Dオブジェクトのy軸を保持する変数
		private var oldRotZ:Number;//選択中3Dオブジェクトのz軸を保持する変数
		private var flg:Boolean=false;//画像を手前に表示しているかどうかのフラグ
		private var isAnimation:Boolean=false;//3Dオブジェクトの配置換えアニメーション中かどうかのフラグ
		private var nowPlane:Plane;//選択中3Dオブジェクト
		//private var photoCloseBtn:closeBtn;//閉じるボタン
		//private var planeChangeBtn:changeBtn;//配置替えボタン
		//private var loadingBar:loadingLine;//ローディングバー
		//private var imgLoader:ImgGroupLoader;//複数画像をロードするカスタムクラスインスタンス
		
		//----------コンストラクタ----------//
		public function Main() {
			stage.quality=StageQuality.MEDIUM;//画質を中にする
			buttonMode=true;//PV3Dオブジェクトのマウスオーバー時にマウスカーソルをハンドカーソルにする
			super(0,0,true,true);//BasicViewクラスの明示的に呼び出し、パラメータを上書きする
			init();//カスタムメソッドinitを実行する
		}
		
		//----------カスタムメソッド----------//
		
		//画像をロードするカスタムメソッド
		private function init():void {
			worldInit();
		}
		/*
		//縦横比を保ったまま画像を拡大/縮小するカスタムメソッド
		private function fixBmp(bmp:BitmapData):BitmapData{
			var bmpWidth:uint=720;//画像の最大横幅を指定する
			var bmpHeight:uint=540;//画像の最大縦幅を指定する
			var xFixNum = bmpWidth/bmp.width;//読み込んだ画像の横幅と最大横幅の比率を計算する
			var yFixNum = bmpHeight/bmp.height;//読み込んだ画像の縦幅と最大縦幅の比率を計算する
			var fixScale:Number=Math.min(xFixNum, yFixNum);//Math.min関数で、横幅比率と縦幅比率の内、小さい方を変数fixScaleに代入する
			var newBmp:BitmapData=new BitmapData(bmpWidth,bmpHeight,false, 0x000000);//新規ビットマップを作成する
			var mat:Matrix = new Matrix();//画像を変形させるためのマトリックスオブジェクトを作成する
			var xx:int=int((bmpWidth-bmp.width*fixScale)*.5);//計算した比率に基づき画像を表示するx座標の開始地点を計算する
			var yy:int=int((bmpHeight-bmp.height*fixScale)*.5);//計算した比率に基づき画像を表示するy座標の開始地点を計算する
			mat.scale(fixScale,fixScale);//マトリックスのスケールの変換を適用する
			mat.translate(xx,yy);//変数xxとyyの分だけマトリックスを平行移動する
			newBmp.draw(bmp,mat);//マトリックスの領域で元画像を新規ビットマップに貼付ける
			bmp.dispose();//元画像を削除する
			return newBmp;//元画像を貼り付けた新規ビットマップを返す
		}
		*/
		//3D空間を初期化するカスタムメソッド
		private function worldInit():void {
			camera.z=-1000;//カメラのz位置を指定する
			camera.focus=500;//カメラのフォーカス（視点からカメラのある面までの距離）を指定する
			camera.zoom=1;//カメラのズーム値を指定する
			camera.target=DisplayObject3D.ZERO;// カメラの視点をシーンの原点（x=0,y=0,z=0）に指定する
			var particleMat:ParticleMaterial=new ParticleMaterial(0xFFFFFF,0.4);//ParticleFieldで使用するパーティクルテクスチャを作成する（引数：色:int,透明度:Number）
			var particles:ParticleField=new ParticleField(particleMat,500,1,2000,2000,2000);//ParticleFieldを作成する（引数：パーティクルマテリアル:ParticleMaterial,パーティクルの量:int,パーティクルを分布させる空間の幅:Number,パーティクルを分布させる空間の高さ:Number = 2000,パーティクルを分布させる空間の奥行:Number = 2000）
			scene.addChild(particles);//3D空間にParticleFieldを追加する

			objs = [];//PV3Dオブジェクトを格納する配列を初期化する
			for (var i:int=0; i<CONTENTS_MAX; i++) {
				var material:ColorMaterial=new ColorMaterial(0xFFFFFF*Math.random());
				material.doubleSided=true;
				material.interactive=true;
				var obj:Plane=new Plane(material,90,60,1,1);
				scene.addChild(obj);
				obj.x=0;
				obj.y=0;
				obj.z=0;
				//obj.alpha=0;
				obj.useOwnContainer=true;
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, onClickHandler);
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_OVER,onMouseOverHandler);
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
				objs.push(obj);
			}
			startRendering();//3D空間の描画を開始する
			setPlane();//カスタムメソッドsetPlaneを実行する
			//createChangeBtn();//カスタムメソッドcreateChangeBtnを実行する
		}
		
		//Plane3Dオブジェクトとカメラを元に戻すカスタムメソッド
		private function backToWorld():void {
			stage.quality=StageQuality.MEDIUM;//画質を中にする
			for (var i:int=0; i<CONTENTS_MAX; i++) {//定数CONTENTS_MAX回繰り返す
				Tweener.addTween(objs[i], {alpha:1,time:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[objs[i]],onComplete:onClickPlaneMoveComplete,onCompleteParams:[objs[i]]});//すべてのPlane3Dオブジェクトの透明度を1にTweenさせる
			}
			nowPlane.rotationX=oldRotX;//現在選ばれているPlane3Dオブジェクトのx回転軸を元に戻す
			nowPlane.rotationY=oldRotY;//現在選ばれているPlane3Dオブジェクトのy回転軸を元に戻す
			nowPlane.rotationZ=oldRotZ;//現在選ばれているPlane3Dオブジェクトのz回転軸を元に戻す
			Tweener.addTween(camera, {x:oldCameraX,y:oldCameraY,z:oldCameraZ,focus:500,zoom:1,time:1,transition:"easeInOut",onComplete:onClickFlgCameraComplete});//カメラを元の位置にTweenさせる
			Tweener.addTween(camera.target, {x:DisplayObject3D.ZERO.x,y:DisplayObject3D.ZERO.y,z:DisplayObject3D.ZERO.z,time:1,transition:"easeInOut",onComplete:removeEndTween,onCompleteParams:[camera.target]});//カメラのターゲットを原点にTweenさせる
			/*
			if(photoCloseBtn!==null){//photoCloseBtnが存在していたら
				photoCloseBtn.removeEventListener(MouseEvent.CLICK,onCloseClick);//photoCloseBtnのクリック時のイベントハンドラを解除する
				photoCloseBtn.removeEventListener(MouseEvent.ROLL_OVER,onCloseOver);//photoCloseBtnのマウスオーバー時のイベントハンドラを解除する
				photoCloseBtn.removeEventListener(MouseEvent.ROLL_OUT,onCloseOut);//photoCloseBtnのマウスアウト時のイベントハンドラを解除する
				removeChild(photoCloseBtn);//photoCloseBtnを表示リストから外す
				photoCloseBtn=null;//photoCloseBtnを削除
			}
			*/
		}
		
		//3DオブジェクトPlaneを配置するカスタムメソッド
		private function setPlane():void {
			var i:int;//変数iを定義
			var r:Number;//変数rを定義
			var yPos:int;//変数yPosを定義
			isAnimation=true;//isAnimationフラグををtrueにする
			switch (no) {//グローバル変数noの値で切り替える
				case 0 ://グローバル変数noが0の時
					//ランダムに配置する
					for (i=0; i<CONTENTS_MAX; i++) {
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.random() * 2000 - 1000,
						y:Math.random() * 2000 - 1000,
						z:Math.random() * 2000 - 1000,
						rotationX:Math.random() * 360, 
						rotationY:Math.random() * 360, 
						rotationZ:Math.random() * 360,
						alpha:1,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 1 ://グローバル変数noが1の時
					//螺旋状に配置する
					for (i=0; i<CONTENTS_MAX; i++) {
						r=360/CONTENTS_MAX*i;
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.cos(r * 3 * Math.PI / 180) * 200,
						y:Math.sin(r * 3 * Math.PI / 180) * 200,
						z:i * 30 - 500,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 2 ://グローバル変数noが2の時
					//円環状に配置する
					for (i=0; i<CONTENTS_MAX; i++) {
						r=360/CONTENTS_MAX*i;
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.cos(r * Math.PI / 180) * 500,
						y:0,
						z:Math.sin(r * Math.PI / 180) * 500,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 3 ://グローバル変数noが3の時
					//円筒状に配置する
					var anglePer:Number = ((Math.PI*2) * (CONTENTS_MAX/10)) / CONTENTS_MAX;
					yPos=0;
					for (i=0; i<CONTENTS_MAX; i++) {
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.cos(i * anglePer) * 300,
						y:yPos-300,
						z:Math.sin(i * anglePer) * 300,
						rotationX:0, 
						rotationY:(-i*anglePer) * (180/Math.PI) + 270, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
						if( (i+1) % 10 == 0 ){
							yPos += 115;
						}
					}
					break;
				case 4 ://グローバル変数noが4の時
					//壁状に配置する
					var xPos:int=0;
					yPos=0;
					for (i=0; i<CONTENTS_MAX; i++) {
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:xPos*140-700,
						y:yPos-300,
						z:0,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
						xPos++;
						if( (i+1) % 10 == 0 ){
							yPos += 110;
							xPos=0;
						}
					}
					break;
				}
			no=4;//グローバル変数noを1増やす
			/*
			if(no>4){//noが4以上だったら
				no=0;//noを0にする
			}
			*/
		}
		/*
		//閉じるボタンを配置するカスタムメソッド
		private function setCloseBtn():void{
			photoCloseBtn=new closeBtn();//closeBtnインスタンスを作成する
			photoCloseBtn.x=783;//closeBtnインスタンスのx座標を指定する
			photoCloseBtn.y=87;//closeBtnインスタンスのy座標を指定する
			photoCloseBtn.alpha=0;//closeBtnインスタンスの透明度を指定する
			photoCloseBtn.buttonMode=true;//closeBtnインスタンスをボタンモードにする
			photoCloseBtn.addEventListener(MouseEvent.CLICK,onCloseClick);//closeBtnインスタンスのクリック時のイベントハンドラを設定する
			photoCloseBtn.addEventListener(MouseEvent.ROLL_OVER,onCloseOver);//closeBtnインスタンスのマウスオーバー時のイベントハンドラを設定する
			photoCloseBtn.addEventListener(MouseEvent.ROLL_OUT,onCloseOut);//closeBtnインスタンスのマウスアウト時のイベントハンドラを設定する
			addChild(photoCloseBtn);//closeBtnインスタンスを表示リストに追加する
			Tweener.addTween(photoCloseBtn, {alpha:1,time:1,transition:"easeInOut",onComplete:removeEndTween,onCompleteParams:[photoCloseBtn]});//closeBtnインスタンスの透明度を1にTweenさせる
		}
		*/
		
		
		//Plane3Dオブジェクトの配置を切り替えるボタンを配置するカスタムメソッド
		/*
		private function createChangeBtn():void{
			planeChangeBtn=new changeBtn();//changeBtnインスタンスを作成する
			planeChangeBtn.x=880;//changeBtnインスタンスのx座標を指定する
			planeChangeBtn.y=600;//changeBtnインスタンスのy座標を指定する
			planeChangeBtn.alpha=0;//changeBtnインスタンスの透明度を指定する
			planeChangeBtn.buttonMode=true;//planeChangeBtnインスタンスをボタンモードにする
			planeChangeBtn.addEventListener(MouseEvent.CLICK,onPlaneChangeClick);//changeBtnインスタンスのクリック時のイベントハンドラを設定する
			planeChangeBtn.addEventListener(MouseEvent.ROLL_OVER,onCloseOver);//changeBtnインスタンスのマウスオーバー時のイベントハンドラを設定する
			planeChangeBtn.addEventListener(MouseEvent.ROLL_OUT,onCloseOut);//changeBtnインスタンスのマウスアウト時のイベントハンドラを設定する
			addChild(planeChangeBtn);//changeBtnインスタンスを表示リストに追加する
			Tweener.addTween(planeChangeBtn, {alpha:1,time:1,transition:"easeInOut",onComplete:removeEndTween,onCompleteParams:[planeChangeBtn]});//changeBtnインスタンスの透明度を1にTweenさせる
		}
		*/
		//----------イベントハンドラ----------//
		
		//ローディング途中の処理
		/*
		private function _onProgress(e:ProgressEvent):void {
			loadingBar.scaleX=e.bytesLoaded / e.bytesTotal;//読み込み状況によってローディングバーの長さを変える
		}
		*/
		//全ての画像を読み込んだ後の処理
		/*
		private function _onComplete(e:Event):void {
			//removeChild(loadingBar);//ローディングバーを表示リストから削除
			//loadingBar=null;//ローディングバーオブジェクトを削除
			var il:ImgGroupLoader = e.target as ImgGroupLoader;//カスタムクラスImgGroupLoaderインスタンス
			il.removeEventListener(ProgressEvent.PROGRESS, _onProgress);//読み込み途中時のイベントハンドラを解除する
			il.removeEventListener(Event.COMPLETE, _onComplete);//ロード完了時のイベントハンドラを解除する
			var bmpArray:Array=il.data;//ロードした画像の配列を変数bmpArrayに格納する
			for(var i:int=0; i<CONTENTS_MAX; i++){//定数CONTENTS_MAX回繰り返す
				bmpArray[i].smoothing=true;//画像のスムージング（拡大・縮小・回転を行った場合にアンチエイリアシングを行う処理）をオンにする
				var newBmp:BitmapData=fixBmp(bmpArray[i].bitmapData);//カスタムメソッドfixBmpで変形させたBitmapDataを変数に格納する
				imgArray[i]=new Bitmap(newBmp);//画像を格納する配列に画像を格納する
			}
 			il=null;//カスタムクラスImgGroupLoaderインスタンスを削除する
			worldInit();//カスタムメソッドworldInitを実行する
		}
		*/
		//BasicViewクラスのonRenderTickメソッドを上書きする処理
		override protected function onRenderTick(e:Event = null):void {
			/*
			if (! flg) {//flgがfalseなら
				camera.x=DISTANCE*Math.sin(theta*Math.PI/180);//カメラのx座標をMath.sinメソッドを使い算出する
				camera.y=DISTANCE*Math.cos(theta*Math.PI/180);//カメラのy座標をMath.cosメソッドを使い算出する
				camera.z=DISTANCE*Math.cos(theta*Math.PI/180);//カメラのz座標をMath.cosメソッドを使い算出する
				theta+=0.4;//回転する角度を0.4加算する
			}
			*/
			super.onRenderTick(e);//BasicViewクラスのonRenderTickメソッドを実行する
		}
		
		//3DオブジェクトPlaneをクリックしたときの処理
		private function onClickHandler(e:Event):void {
			if (! flg) {//flgがfalseなら
				nowPlane=e.target as Plane;//クリックされたPlane3Dオブジェクトを変数に格納する
				oldCameraX=camera.x;//カメラの現在のx座標を変数に格納する
				oldCameraY=camera.y;//カメラの現在のy座標を変数に格納する
				oldCameraZ=camera.z;//カメラの現在のz座標を変数に格納する
				oldRotX=nowPlane.rotationX;//クリックされたPlane3Dオブジェクトの現在のx回転軸を変数に格納する
				oldRotY=nowPlane.rotationY;//クリックされたPlane3Dオブジェクトの現在のy回転軸を変数に格納する
				oldRotZ=nowPlane.rotationZ;//クリックされたPlane3Dオブジェクトの現在のz回転軸を変数に格納する
				nowPlane.rotationX=0;//クリックされたPlane3Dオブジェクトのx回転軸をリセットする
				nowPlane.rotationY=0;//クリックされたPlane3Dオブジェクトのy回転軸をリセットする
				nowPlane.rotationZ=0;//クリックされたPlane3Dオブジェクトのz回転軸をリセットする
				flg=true;//flgをtrueにする
				
				var target:DisplayObject3D = new DisplayObject3D();//新規3Dオブジェクトを作成する
				target.copyTransform(nowPlane);//クリックされたPlane3Dオブジェクトの位置情報を新規3Dオブジェクトにコピーする
				target.moveBackward(56);//クリックされたPlane3Dオブジェクトのz座標を数値分減らす
				Tweener.addTween(camera, {x:target.x,y:target.y,z:target.z,time:1,transition:"easeInOut",onComplete:removeEndTween,onCompleteParams:[camera]});//カメラをクリックされたPlane3Dオブジェクトの位置にTweenさせる
				for (var i:int=0; i<CONTENTS_MAX; i++) {//定数CONTENTS_MAX回繰り返す
					Tweener.addTween(objs[i], {alpha:0,scale:1,time:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[objs[i]],onComplete:onClickPlaneMoveComplete,onCompleteParams:[objs[i]]});//すべてのPlane3Dオブジェクトの透明度と大きさを指定した数値にTweenさせる
				}
				Tweener.addTween(camera.target, {x:e.target.x,y:e.target.y,z:e.target.z,time:1,transition:"easeInOut",onComplete:removeEndTween,onCompleteParams:[camera.target]});//カメラのターゲットをクリックされたPlane3Dオブジェクトの位置にTweenさせる
				Tweener.addTween(nowPlane, {alpha:1,time:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[e.target],onComplete:onChanePlane,onCompleteParams:[nowPlane]});//クリックされたPlane3Dオブジェクトの透明度を1にTweenさせる
			} else {//そうでないなら(flgがtrueなら)
				backToWorld();//カスタムメソッドbackToWorldを実行する
			}
		}
		
		//Plane3Dオブジェクトをマウスオーバーしたときの処理
		private function onMouseOverHandler(e:InteractiveScene3DEvent):void {
			if (! flg) {//flgがtrueでないなら（falseなら）
				Tweener.addTween(e.target, {time:0.4,scale:1.5,transition:"easeOutBack",onComplete:removeEndTween,onCompleteParams:[e.target]});//ターゲットの大きさを1.5倍にTweenさせる
			}
		}
		
		//Plane3Dオブジェクトからマウスアウトしたときの処理
		private function onMouseOutHandler(e:InteractiveScene3DEvent):void {
			if (! flg) {//flgがtrueでないなら（falseなら）
				Tweener.addTween(e.target, {time:0.4,scale:1,transition:"easeOutBack",onComplete:removeEndTween,onCompleteParams:[e.target]});//ターゲットの大きさを等倍にTweenさせる
			}
		}
		
		//閉じるボタンをクリックしたときの処理
		private function onCloseClick(e:Event):void{
			backToWorld();//カスタムメソッドbackToWorldを実行
		}
		
		//マウスオーバーしたときの処理
		private function onCloseOver(e:MouseEvent):void{
			Tweener.addTween(e.target, { alpha:0.5,time:0.6,transition:"easeInOut", onComplete:removeEndTween,onCompleteParams:[e.target]});
		}
		
		//マウスアウトしたときの処理
		private function onCloseOut(e:MouseEvent):void{
			Tweener.addTween(e.target, { alpha:1,time:0.6,transition:"easeInOut", onComplete:removeEndTween,onCompleteParams:[e.target]});
		}
		
		//Plane3Dオブジェクトの配置を切り替えるボタンをクリックしたときの処理
		private function onPlaneChangeClick(e:MouseEvent):void{
			e.target.alpha=1;//ターゲットの透明度を1にする
			if (! flg && ! isAnimation) {//flgがflaseかつisAnimationがfalseなら
				setPlane();//カスタムメソッドsetPlaneを実行する
			}
		}
		
		//----------Tweenerのパラメータで指定したカスタムメソッド群----------//
		
		//TweenerのonComplete時にTweenerに登録したTweenを削除するカスタムメソッド
		private function removeEndTween(target:*):void{
			Tweener.removeTweens(target);//引数で指定したターゲットのTweenを削除する
		}
		
		//TweenerのonComplete時に3D空間を元に戻すためのカスタムメソッド
		private function onClickFlgCameraComplete():void{
			Tweener.removeTweens(camera);//カメラのTweenを削除する
			flg=false;//flgをfalseにする
		}
		
		//Plane3Dオブジェクトクリック時に発生するアニメーション開始時に実行するカスタムメソッド
		private function onClickPlaneMoveStart(plane:Plane):void{
			plane.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);//引数で指定したPlane3Dオブジェクトのクリック時のイベントハンドラを解除する
			plane.removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);//引数で指定したPlane3Dオブジェクトのマウスオーバー時のイベントハンドラを解除する
			plane.removeEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);//引数で指定したPlane3Dオブジェクトのマウスアウト時のイベントハンドラを解除する
		}
		
		//TweenerのonComplete時にPlane3Dオブジェクトクリック時に発生するアニメーション終了時に実行するカスタムメソッド
		private function onClickPlaneMoveComplete(plane:Plane):void{
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);//引数で指定したPlane3Dオブジェクトのクリック時のイベントハンドラを設定する
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);//引数で指定したPlane3Dオブジェクトのマウスオーバー時のイベントハンドラを設定する
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);//引数で指定したPlane3Dオブジェクトのマウスアウト時のイベントハンドラを設定する
		}
		
		//クリックされたPlane3Dオブジェクトのアニメーションが完了したときに実行するカスタムメソッド
		private function onChanePlane(plane:Plane):void{
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);//引数で指定したPlane3Dオブジェクトのクリック時のイベントハンドラを設定する
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);//引数で指定したPlane3Dオブジェクトのマウスオーバー時のイベントハンドラを設定する
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);//引数で指定したPlane3Dオブジェクトのマウスアウト時のイベントハンドラを設定する
			stage.quality=StageQuality.HIGH;//画質を高にする
			//setCloseBtn();//カスタムメソッドsetCloseBtnを実行する
		}
		
		//カスタムメソッド"setPlane"実行時に発生するアニメーション開始時に実行するカスタムメソッド
		private function onPlaneMoveStart():void{
			for (var i:int=0; i<CONTENTS_MAX; i++) {
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);//全てのPlane3Dオブジェクトのクリック時のイベントハンドラを解除する
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);//全てのPlane3Dオブジェクトのマウスオーバー時のイベントハンドラを解除する
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);//全てのPlane3Dオブジェクトのマウスアウト時のイベントハンドラを解除する
			}
			/*
			if(planeChangeBtn!==null){//planeChangeBtnが存在していたら
				planeChangeBtn.removeEventListener(MouseEvent.CLICK,onPlaneChangeClick);//planeChangeBtnのクリック時のイベントハンドラを解除する
				planeChangeBtn.removeEventListener(MouseEvent.ROLL_OVER,onCloseOver);//planeChangeBtnのマウスオーバー時のイベントハンドラを解除する
				planeChangeBtn.removeEventListener(MouseEvent.ROLL_OUT,onCloseOut);//planeChangeBtnのマウスアウト時のイベントハンドラを解除する
			}
			*/
		}
		
		//カスタムメソッド"setPlane"実行時に発生するアニメーション完了時に実行するカスタムメソッド
		private function onPlaneMoveComplete(i:int):void{
			Tweener.removeTweens(objs[i]);//指定PlaneのTweenを削除する
			if(i==CONTENTS_MAX-1){//最後のPlane3Dオブジェクトだったら
				for(var ii:int=0; ii<CONTENTS_MAX; ii++){//定数CONTENTS_MAX回繰り返す
					objs[ii].addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);//指定Plane3Dオブジェクトのクリック時のイベントハンドラを設定する
					objs[ii].addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);//指定Plane3Dオブジェクトのマウスオーバー時のイベントハンドラを設定する
					objs[ii].addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);//指定Plane3Dオブジェクトのマウスアウト時のイベントハンドラを設定する
				}
				/*
				if(planeChangeBtn!==null){//planeChangeBtnが存在していたら
					planeChangeBtn.addEventListener(MouseEvent.CLICK,onPlaneChangeClick);//planeChangeBtnのクリック時のイベントハンドラを設定する
					planeChangeBtn.addEventListener(MouseEvent.ROLL_OVER,onCloseOver);//planeChangeBtnのマウスオーバー時のイベントハンドラを設定する
					planeChangeBtn.addEventListener(MouseEvent.ROLL_OUT,onCloseOut);//planeChangeBtnのマウスアウト時のイベントハンドラを設定する
				}
				*/
				isAnimation=false;//isAnimationフラグをfalseにする
			}
		}
		
	}
}