/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7XAV
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.utils.getDefinitionByName;
 
    import com.flashdynamix.motion.*;
    import com.flashdynamix.motion.effects.*;
    import com.flashdynamix.motion.extras.Emitter;
    import com.flashdynamix.motion.layers.BitmapLayer;
 
    import com.flashdynamix.motion.effects.core.*;
    import com.flashdynamix.utils.*;

    public class MenuEmitter extends Sprite {
 
 
        public var menuButton:MovieClip;
 
        private var emittor : Emitter;
        private var layer : BitmapLayer;
 
        private var ct : ColorTransform;
        private var bf : BlurFilter;
 
        private var tx : Number;
        private var ty : Number;
 
        public function MenuEmitter() {
 
 
            // Create a Bitmap Layer where we'll draw the Emitter and apply some effects
            layer = new BitmapLayer(900, 400);
            bf = new BlurFilter(10, 10, 2);
            layer.add(new ColorEffect(new ColorTransform(1, 1, 1, 0.9)));
            layer.add(new FilterEffect(bf));
 
            // Set quality to LOW to get better performance
            stage.quality = StageQuality.LOW;
 
 
            // The Emitter MovieClip "BluePrint"
            var Box : Class = getDefinitionByName("Box") as Class;
 
            // Emitter Creation
            ct = new ColorTransform(1, 1, 1, 1, -115, -30, 70);
            emittor = new Emitter(Box, null, 2, 1, "0, 360", "1, 110", 1, BlendMode.ADD);
            emittor.transform.colorTransform = ct;
            emittor.endColor = {redOffset:255, greenOffset:-10, blueOffset:-255, alphaOffset:-255};
 
            // We can't build the emitter on 0,0 because it will be cutted on the top and on the left side
            emittor.x = 150
            emittor.y = 150
 
            // Display on screen
            layer.draw(emittor.holder);
            menuButton.addChildAt(layer,0);
 
            // Stop emitter at startTime
            emittor.stop()
 
            // RollOver / RollOut on button
            menuButton.gfx.buttonMode = true;
            menuButton.gfx.addEventListener(MouseEvent.ROLL_OVER, onMenuRollOver)
            menuButton.gfx.addEventListener(MouseEvent.ROLL_OUT, onMenuRollOut)
 
            // ENTER_FRAME event
            // We'll update the emittor properties to generate random
            addEventListener(Event.ENTER_FRAME, update)
 
        }
 
        /**
        * Update emittor rotation properties to have different rotation for each particle
        */
        private function update(e : Event) : void {
            emittor.rotation += 20;
        }
 
        /**
        * At Button rollOver start the emitter
        */
        private function onMenuRollOver(e : MouseEvent) : void {
            emittor.start()
        }
 
        /**
        * At Button rollOut stop the emitter
        */
        private function onMenuRollOut(e : MouseEvent) : void {
            emittor.stop()
        }
 
 
    }
} 
