/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7X4K
 */

package {
    import flash.display.*;
    import flash.net.*;
    import jp.progression.casts.*;
    import mx.graphics.codec.*;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.ColorShortcuts;
    ColorShortcuts.init();
   
    /**
     * Twitterで緑色アイコンがはやっていたので
     * 画像を緑色にして保存するツールを作ってみました
     * @author Yasu
     */
    public class Main extends CastDocument {
        
        public function Main():void {
            var fr :FileReference = new FileReference();
            var wrap :Sprite = addChild(new Sprite()) as Sprite;
            wrap.x = 10; wrap.y = 120;
            var loader:CastLoader = wrap.addChild(new CastLoader()) as CastLoader;
            
            // 1.ローカル画像の読み込み
            var loadBtn :Sprite = addChild(new Sprite()) as Sprite;
            loadBtn.x = 10; loadBtn.y = 10;
            loadBtn.addChild(new CastTextField({text:"SELECT", opaqueBackground: 0xCCCCCC, selectable: false}));
            loadBtn.addEventListener("click", function():void { fr.browse(); });
            
            // 2.緑色にする
            fr.addEventListener("select", function():void { fr.load(); });
            fr.addEventListener("complete", function():void {
                loader.contentLoaderInfo.addEventListener("init", function():void {
                    Tweener.addTween(loader, {_color_redOffset:-150, _color_blueOffset:-150, time:2 } );
                });
                loader.loadBytes(fr.data);
            });
            
            // 3.保存する
            var saveBtn : Sprite = addChild(new Sprite()) as Sprite;
            saveBtn.x = 130; saveBtn.y = 10;
            saveBtn.addChild(new CastTextField({text:"SAVE", opaqueBackground: 0xCCCCCC, selectable: false})) ;
            saveBtn.addEventListener("click", function():void {
                if (!loader.content) return;
                var capture :BitmapData = new BitmapData(loader.width, loader.height);
                capture.draw(wrap);
                fr.save((new PNGEncoder()).encode(capture), "geeen-icon.png");
            });
        }
    }
}