/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Wik
 */

// forked from siouxcitizen's Away3D練習5　Shading&Phong Color MaterialでCone表示
// forked from siouxcitizen's Away3D練習4　3種類のMaterialでCube表示
// forked from siouxcitizen's Away3D練習3　3種類のMaterialでSphere表示
// forked from siouxcitizen's Away3D練習2　3種類のMaterialでPlane表示
// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習
//
//以下のサイトとそこからリンクされているコードを参考にさせていただきました
//サイト
//way3D Basics 5 - Primitives (Part 3)
//http://www.flashmagazine.com/tutorials/detail/away3d_basics_5_-_primitives_part_3/

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.geom.Vector3D;

  import away3d.containers.View3D;
  import away3d.primitives.Torus;
  import away3d.materials.PhongColorMaterial;
  import away3d.lights.DirectionalLight3D

  [SWF(frameRate="60", backgroundColor="#ffffff")]
  public class Away3DTest extends Sprite {
    private var view:View3D;
    private var torus1 : Torus;
    private var torus2 : Torus;
    private var torus3 : Torus;

    private var phongColorMaterial1:PhongColorMaterial;
    private var phongColorMaterial2:PhongColorMaterial;
    private var phongColorMaterial3:PhongColorMaterial;
    private var light:DirectionalLight3D;
    
    public function Away3DTest() {

      view = new View3D();
      view.x = stage.stageWidth >> 1;
      view.y = stage.stageHeight >> 1;
      addChild(view);

      phongColorMaterial1 = new PhongColorMaterial(0xff0000);
      phongColorMaterial2 = new PhongColorMaterial(0x0000ff);
      phongColorMaterial3 = new PhongColorMaterial(0xffff00);

      torus1 = new Torus({material:phongColorMaterial1,radius:50,x:0,rotationX:90,rotationZ:90});;
      view.scene.addChild(torus1);

      torus2 = new Torus({material:phongColorMaterial2,radius:140,x:0,rotationX:90});;
      view.scene.addChild(torus2);

      torus3 = new Torus({material:phongColorMaterial3,radius:230,x:0,rotationX:90,rotationZ:90});;
      view.scene.addChild(torus3);

      light = new DirectionalLight3D();
      light.direction = new Vector3D(500,-300,200);
      view.scene.addLight(light);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {

      torus1.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      torus1.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      torus2.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      torus2.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      torus3.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      torus3.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      view.render();
    }
  }
}
            