/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7VuO
 */

// forked from dannnn's forked from: forked from: flash on 2014-8-21
// forked from YoupSolo's forked from: flash on 2014-8-21

// refactored some code
// now Koam1 and Koma2 inherits from Koma base class
// added an owner property to the Koma
// added params to the Board class (colors & dropshadown)
// added a dropshadow when dragging a pawn

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;


    [SWF(width = "465", hight = "465", frameRate = "30")]
    public class FlashTest extends Sprite 
    {
        [Embed(systemFont = "sansserif", fontName = "myFont", mimeType = "application/x-font")]
        private static const myFont:Class;
                
        public function FlashTest() 
        {

            // you don't need to create a display object (Sprite) for a background and lines
            this.graphics.beginFill(Board.COLOR);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();             

            // same here draw directly on the stage
            this.graphics.lineStyle(1);
            var numbers:TextField
            for ( var i: int = 0; i <= Board.TILE_NUM; i++)
            {
                numbers = new TextField();
                numbers.selectable = false;
                numbers.x = Board.MARGIN + 15 + (i * Board.TILE_SIZE); 
                numbers.text = ( (Board.TILE_NUM - i) != 0) ? (Board.TILE_NUM - i).toString() : "";
                addChild(numbers);
                
                this.graphics.moveTo(Board.MARGIN+Board.TILE_SIZE*i, Board.MARGIN);
                this.graphics.lineTo(Board.MARGIN+Board.TILE_SIZE*i, Board.MARGIN);
                this.graphics.lineTo(Board.MARGIN+Board.TILE_SIZE*i, Board.MARGIN + Board.TILE_NUM * Board.TILE_SIZE);
            }

            
            for ( var j: int = 0; j <= Board.TILE_NUM; j++)
            {
                numbers = new TextField();                
                numbers.selectable = false;
                numbers.x = 400; 
                numbers.y = -5 + (j * Board.TILE_SIZE); 
                numbers.text = ( j == 0) ? "" : j.toString();
                addChild(numbers);                
                
                this.graphics.moveTo(Board.MARGIN, Board.MARGIN+Board.TILE_SIZE*j);
                this.graphics.lineTo(Board.MARGIN, Board.MARGIN+Board.TILE_SIZE*j);
                this.graphics.lineTo(Board.MARGIN + Board.TILE_NUM * Board.TILE_SIZE, Board.MARGIN+Board.TILE_SIZE*j);
            }           

            //////////////////////////////////
            // creating the board
            
            // reseting the counter
            Board.KOMA_NAMES_IDX = 0;            
            fillLine(2, 2);
            addChild( new Koma2(1, 7) );
            addChild( new Koma2(1, 1) ); // create a Koma at 1,1 for player 2            
            fillLine(0, 2);
            
            
            // reseting the counter
            Board.KOMA_NAMES_IDX = 0;
            fillLine(6, 1);
            addChild( new Koma1(7, 1) );
            addChild( new Koma1(7, 7) );
            fillLine(8, 1);            

            // you can create one listener to handle the whole DnD mechanic
            this.addEventListener(MouseEvent.MOUSE_DOWN, onDrag);
            this.addEventListener(MouseEvent.MOUSE_UP, onDrop);
        }

        // fill the @line with pawns for the @player
        private function fillLine(lineNumber:int, player:int):void 
        {
            for (var index:int = 0; index < Board.TILE_NUM; index++) 
            {
                // with addchild add directly the pawn to the display list
                if (player == 1) {
                    addChild( new Koma1(lineNumber, index) );
                }else {
                    addChild( new Koma2(lineNumber, index) );
                }
            }
        }        

        // on drag behavior
        public function onDrag(e:MouseEvent):void 
        {
            // if we click on a Koma, I put this one on the top of the display list ( the pawn is now over the others )
            if (e.target is Koma) {
                var targetKoma:Koma = e.target as Koma;
                targetKoma.filters = [Board.DROP_SHADOW]; // added a drop shadow                
                addChild( targetKoma );
                // dragging
                targetKoma.startDrag();
            }
        }

        public function onDrop(e:MouseEvent):void 
        {
            stopDrag();           
            // the koma is centered in the curent Tile
            if (e.target is Koma) 
            {
                // now, Koma1 and Koma2 inherits from Koma
                var targetKoma:Koma = e.target as Koma;
                targetKoma.filters = [];
                var newX:int = Board.MARGIN + Board.KOMA_OFFSET_X + (int((e.stageX - e.localX) / Board.TILE_SIZE)) * Board.TILE_SIZE;
                var newY:int = Board.MARGIN + Board.KOMA_OFFSET_Y + (int((e.stageY - e.localY) / Board.TILE_SIZE)) * Board.TILE_SIZE;
                // new coordinates
                targetKoma.x = newX;
                targetKoma.y = newY;
            }
        }
    }
}

import flash.filters.DropShadowFilter;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Koma extends Sprite
{
    public var owner:int;
    public const showName:Boolean = true;
    
    protected var tf:TextField;
    
    public function Koma(lineNumer:int, index:int)
    {
        mouseChildren = false;
        mouseEnabled = true; 
        x = Board.MARGIN + Board.KOMA_OFFSET_X + index * Board.TILE_SIZE;
        y = Board.MARGIN + Board.KOMA_OFFSET_Y + lineNumer * Board.TILE_SIZE;
        //name = lineNumer+ "_" + index;        
        name = Board.KOMA_NAMES[Board.KOMA_NAMES_IDX++];

        tf = new TextField();
        tf.embedFonts = true;
        tf.x = 7; // centering the text
        tf.y = 7; // centering the text
        tf.defaultTextFormat = new TextFormat('myFont', 10, 0x0);
        tf.autoSize = TextFieldAutoSize.LEFT;
        tf.text = name;        
        addChild( tf );
        
        tf.visible = showName;
        draw();
    }
    
    public function draw():void
    {
        // to override 
    }
}

class Koma1 extends Koma
{
    public function Koma1(lineNumber:int, index:int)
    {
        owner = 1;
        super(lineNumber, index);
    }

    override public function draw():void
    {
        graphics.beginFill(Board.KOMA_COLOR);
        graphics.lineStyle(1);
        graphics.moveTo(15, 0);
        graphics.lineTo(15, 0);
        graphics.lineTo(25, 5);
        graphics.lineTo(30, 30);
        graphics.lineTo(0, 30);
        graphics.lineTo(5, 5); 
        graphics.endFill();
    }
}

class Koma2 extends Koma
{
    public function Koma2(lineNumber:int, index:int)
    {
        owner = 2;
        super(lineNumber, index);
        
        tf.rotation = 180;        
        tf.x = 22;
        tf.y = 22;
    }

    override public function draw():void
    {   
        graphics.beginFill(Board.KOMA_COLOR);
        graphics.lineStyle(1);
        graphics.moveTo(15, 30);
        graphics.lineTo(15, 30);
        graphics.lineTo(5, 25);
        graphics.lineTo(0, 0);
        graphics.lineTo(30, 0);
        graphics.lineTo(25, 25); 
        graphics.endFill();
    }
}


// a config object
class Board 
{
    public static const MARGIN:int = 25;
    public static const TILE_SIZE:int = 40;        
    public static const TILE_NUM:int = 9;
    public static const KOMA_OFFSET_X:int = 5;
    public static const KOMA_OFFSET_Y:int = 5;
    
    public static const COLOR:int = 0xC2922F;
    public static const KOMA_COLOR:int = 0xE2A22F;
    
    public static const DROP_SHADOW:DropShadowFilter = new DropShadowFilter(5,45,0x0,.5);
    public static const KOMA_NAMES:Array = ["hu","hu","hu","hu","hu","hu","hu","hu","hu","ka","hi","ky","ke","gi","ki","ou","ki","gi","ke","ky"];
    public static var KOMA_NAMES_IDX:int = 0;    
    
    public function Board() {}
}

