/**
 * Copyright seikai ( http://wonderfl.net/user/seikai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7VCV
 */

package
{
        /**
         * セル・オートマトン ルール30 
         * http://ja.wikipedia.org/wiki/%E3%82%BB%E3%83%AB%E3%83%BB%E3%82%AA%E3%83%BC%E3%83%88%E3%83%9E%E3%83%88%E3%83%B3#.E3.83.AB.E3.83.BC.E3.83.AB30
         */
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	
	[SWF(width = 465, height = 465, frameRate = 30, backgroundColor=0)]
	public class Rule30 extends Sprite
	{
		//開始位置
		private var _line:uint = 120;
		
		//終了位置
		//左端のピクセルが切れると破綻する・・・。
		private var _stop:uint = 350; 
		
		private var _canvas:BitmapData;
		
		private var _rect:Rectangle;
		
		private const RULE:Vector.<uint> = Vector.<uint>([
			0xFF0000,
			0x00FFFF,
			0x00FF00,
			0x0000FF
		]);
		
		public function Rule30()
		{
			_init();
		}
		
		private function _init(e:Event = null):void {
			
			_canvas = new BitmapData(stage.stageWidth+1, stage.stageHeight, false, 0x000000);
			_canvas.setPixel(int(stage.stageWidth/2), _line, 0xFFFFFF);
			
			_rect = new Rectangle(0, _line, stage.stageWidth+1, 1);
			
			addChild(new Bitmap(_canvas));
			addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
		}
		
		private function _enterFrameHandler(e:Event):void {
			
			_rect.y = _line;
			_rect.width = stage.stageWidth + 2;
			
			var w:uint = stage.stageWidth;
			var data:ByteArray = _canvas.getPixels(_rect);
			data.position = 3;
			
			var bit1:uint, bit2:uint, bit3:uint;
			var pixcels:ByteArray = new ByteArray();
			
			bit1 = 0;
			bit1 = data.readUnsignedByte();
			
			if(_line+1 < _stop){
				
				for(var i:int = 0; i < w; i++) {
					data.position = (i+1)*4 + 3;
					bit3 = data.readUnsignedByte();
					pixcels.position = i*4;
					pixcels.writeUnsignedInt(_rule(bit1 << 16 | bit2 << 8 | bit3));
					bit1 = bit2;
					bit2 = bit3;
				}
				_line++;
				
				_rect.width = stage.stageWidth;
				_rect.y = _line;
				pixcels.position = 0;
				_canvas.setPixels(_rect, pixcels);
				
			} else {
				removeEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			}
		}
		
		private function _rule(p:uint):uint
		{
			return ( RULE.indexOf(p,0) >= 0 )? 0xFFFFFFFF: 0xFF000000;
		}
	}
}