/**
 * Copyright nanasi ( http://wonderfl.net/user/nanasi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Uk4
 */

// forked from cjcat2266's [Stardust] Damped Stars
/**
 * Stardust Particle Engine
 * 
 * Homepage
 *     http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 *     http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 *     http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.twoD.display.AddChildMode;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
    
    [SWF(backgroundColor="#FFFFFF", frameRate=60)]
    
    public class Main extends Sprite {
        
        private var emitter:StarEmitter;
        
        public function Main():void {
            emitter = new StarEmitter(new SteadyClock(1));
            var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
            renderer.addEmitter(emitter);
            
            addEventListener(Event.ENTER_FRAME, mainLoop);
        }
        
        private function mainLoop(e:Event):void {
            emitter.step();
        }
    }
}

//------------------------------------------------------------------------------------------------

    import flash.display.*;
    import flash.events.*;
    import idv.cjcat.stardust.common.actions.*;
    import idv.cjcat.stardust.common.clocks.*;
    import idv.cjcat.stardust.common.emitters.*;
    import idv.cjcat.stardust.common.renderers.*;
    import idv.cjcat.stardust.common.initializers.*;
    import idv.cjcat.stardust.common.math.*;
    import idv.cjcat.stardust.twoD.actions.*;
    import idv.cjcat.stardust.twoD.fields.*;
    import idv.cjcat.stardust.twoD.emitters.*;
    import idv.cjcat.stardust.twoD.initializers.*;
    import idv.cjcat.stardust.twoD.zones.*;
    import idv.cjcat.stardust.twoD.renderers.*;
    import idv.cjcat.stardust.twoD.deflectors.CircleDeflector;
//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class StarEmitter extends Emitter2D {
    
    public function StarEmitter(clock:Clock) {
        super(clock);
        
        //initializers
        addInitializer(new DisplayObjectClass(Star));
addInitializer(new Velocity(new LazySectorZone(0, 1)));
addInitializer(new Life(new UniformRandom(100, 5)));
addInitializer(new Position(new Line( 100, 300, 500, 300 )));
addAction(new Age());
addAction(new DeathLife());
addAction(new Accelerate(0.2));
addAction(new Move());
addAction(new ScaleCurve(1,7));
addAction( new Gravity() );

addInitializer( new Omega(new UniformRandom(0,0) ) );

    }
}

//------------------------------------------------------------------------------------------------

class Star extends Shape {
    
    private const OUTER_RADIUS:Number = 20;
    private const INNER_RADIUS:Number = 12;
    
    public function Star() {
        graphics.lineStyle(0, 0, 1, false, LineScaleMode.NONE);
        graphics.beginFill(0xF9C330);
        graphics.moveTo(0, -OUTER_RADIUS);
        for (var i:int = 1; i <= 11; i++) {
            var radius:Number = (i & 1)?(INNER_RADIUS):(OUTER_RADIUS);
            var theta:Number = 0.2 * Math.PI * i;
            graphics.lineTo(radius * Math.sin(theta), radius * -Math.cos(theta));
        }
        graphics.endFill();
    }
}