/**
 * Copyright selflash ( http://wonderfl.net/user/selflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7UaN
 */

// forked from yooKo's レインボーな何か
/*
 * @author yooKo@selflash
 * 
 * 着地点を決めずに何かを作ってみた。
 * で、これは何だろう
 * 何がなんだかわかんなくなったし飽きたからこれで終わるとしよう
 *
 */
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.utils.Timer;
	import net.hires.debug.Stats;

	[SWF(width = "500", height = "500", backgroundColor = "0x000000", frameRate = "60")]

	public class RainbowLine extends Sprite {
		private const MAX_DISTANCE:Number = 350;
		private const POINT_ZERO:Point = new Point();
	    private const FILTER_BLUR:BlurFilter = new BlurFilter(8, 8, BitmapFilterQuality.LOW);	
	    
	    private var trancsform_color:ColorTransform = new ColorTransform(.95, .95, .95, 0.999999999999, 1, 1, 1, -2.5);	
	    private var list:Array = [];
		private var numPoints:uint = 20;
		private var canvas:BitmapData;
		private var source:Shape = new Shape();
		private var g:Graphics = source.graphics;
		private var particles:Array = [];

		public function RainbowLine() {
		    Wonderfl.capture_delay( 20 );
			canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0xFFFFFF);
			addChild( new Bitmap( canvas ) );
			
			source.filters = [ new BlurFilter(8, 8) ];
			
			for ( var j:uint = 0; j < numPoints; j ++ ) {
				var p:ChasePoint = new ChasePoint();
				list.push( p );
			};		
			
			var timer:Timer = new Timer(0);
			timer.addEventListener( TimerEvent.TIMER, loop );
			timer.start();
			
			addEventListener( Event.ENTER_FRAME, upData );
			
			addChild(new Stats());                       
		}
		
		private function loop( e:TimerEvent = null ):void {
			var p0:ChasePoint = list[0];
			//p0.x = Math.random() * MAX_DISTANCE - MAX_DISTANCE / 2 + stage.width / 2;
			//p0.y = Math.random() * MAX_DISTANCE - MAX_DISTANCE / 2 + stage.height / 2;
			p0.x = stage.width / 2 + ( ( Math.random() - .5 ) * 200 );
			p0.y = stage.height - ( ( Math.random() - .4 ) * 500 );	   

			e.currentTarget.delay = Math.random() * 200;
			
			var q:Number = (Math.random() - .5) * 35;
			var w:Number = (Math.random() - .5) * 35;
			var t:Number = (Math.random() - .5) * 35;
			trancsform_color = new ColorTransform(.95, .95, .95, 0.999999999999, q, w, t, -2.5);
		}
		
		private function upData( e:Event = null ):void {
		    canvas.scroll(-2, -2);
			g.clear();
			
			canvas.lock();
			canvas.colorTransform(canvas.rect, trancsform_color);
			canvas.applyFilter(canvas, canvas.rect, POINT_ZERO, FILTER_BLUR);		
			
			var p0:ChasePoint = list[0];
			//p0.x = stage.mouseX;
			//p0.y = stage.mouseY;
			var p1:ChasePoint = list[1];
			movePoint( p1, p0, 0.05, 0.8 );
				
			var a:Number = 1;
			for( var j:int = 2; j < list.length; j++ ){
				p0 = list[ j - 1 ];
				p1 = list[ j ];
				movePoint( p1, p0, 0.4, 0.5 );
				g.lineStyle( (j-1)*0.2, 0xFFFFFF, a);
				g.moveTo( p0.x, p0.y );
				g.lineTo( p1.x, p1.y );
				//a -= 0.023;
			};	
			
			canvas.draw(source);	
			canvas.unlock();
		}
		
		private function movePoint( p1:ChasePoint, p0:ChasePoint, spring:Number, friction:Number ):void {
			p1.sx += ( p0.x - p1.x ) * spring;
			p1.sx *= friction;
			p1.x += p1.sx;
			
			p1.sy += ( p0.y - p1.y ) * spring;
			p1.sy *= friction;
			p1.y += p1.sy;
		}
	}
}

class ChasePoint {
	public var x  : Number = 0;
	public var y  : Number = 0;
	public var sx : Number = 0;
	public var sy : Number = 0;
	public var c  : int;
}
