/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7UXU
 */

package {
    import flash.display.*;
    import flash.events.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import com.bit101.components.*;
    import net.hires.debug.Stats;
       import org.papervision3d.cameras.*;
       import org.papervision3d.core.math.*;
    
    // LIVE CODING TEST
    // @author Yasu
    // - THANKS TO WONDERFL STAFF
    
    public class FlashTest extends BasicView {
        public function FlashTest() {
            
               super(0, 0, true, false, CameraType.SPRING);
               
            opaqueBackground = 0;
            stage.quality = "low";
            stage.frameRate = 60;
            
            var arr :Array = [];
            
            for(var i:int=0; i<100; i++)
            {
                    var s:Sphere = new Sphere(new WireframeMaterial(0xFF0000), 100, 1, 1);
                    scene.addChild(s);
                    
                    var angle:Number = (i / 100) * 360 * Math.PI / 180;
                    s.x = Math.cos(angle * 1) * 3000;
                    s.z = Math.sin(angle * 2) * 3000;                
                    s.y = 0.3 * Math.sin(angle * 1) * 3000;
                    
            }
            
            for(i = 0; i<200; i++)
            {
                    s = new Sphere(new WireframeMaterial(0x333333), 100, 1, 1);         
                 scene.addChild(s);                                    
                    s.x = 20000 * (Math.random() - 0.5);               
                 s.z = 20000 * (Math.random() - 0.5);               
                 s.y = 20000 * (Math.random() - 0.5);            
                }
         
            var rot:Number = 0;
                var eye:Sphere = new Sphere(new WireframeMaterial(0xCCCCCC), 100, 1, 1);            scene.addChild(eye);
 
            camera.target = eye;            
            SpringCamera3D(camera).mass = 30;    
            SpringCamera3D(camera).damping = 30;            
            SpringCamera3D(camera).stiffness = 1;            
            SpringCamera3D(camera).positionOffset = new Number3D(0, 200, 0);        
            SpringCamera3D(camera).lookOffset = new Number3D(0, 0, 0);
            camera.fov = 80;
            
            addEventListener(Event.ENTER_FRAME, function():void
            {    
                    rot += 0.15;
                    
                    var angle:Number = (rot / 100) * 360 * Math.PI / 180;
                    
                    eye.x = Math.cos(angle * 1) * 3000;
                    eye.z = Math.sin(angle * 2) * 3000;
                    
                    
                  eye.y = 0.3 * Math.sin(angle * 1) * 3000 + 300;
            });
            
            
            var l:Label = new Label(this, 5, 5, "HELLO! LIVE CODING");
            l.scaleX = l.scaleY = 2;
            l.x = 80;
            
            addChild(new Stats);
            
            startRendering();
        }
    }
}