/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7TpW
 */

/* Processing Creating Coding and Computational Artと言う本の
コードを打ち込んでみました。*/
package {
	import frocessing.display.*;

	[SWF(width=465, height=465, frameRate="60")]
	public class Moirepattern extends F5MovieClip2DBmp {
		private var interval:Number;
		private var spacer:Number;
		// Experiment with these values
		private var angle:Number=0;
		private var amplitude:Number = .05;
		private var waveGap:Number = 10;
		private var frequency:Number= .1;
		private var ringGrowthRate:Number = .5;
		private var isInactive:Boolean = true;

		public function Moirepattern() {
			super();
		}

		public function setup():void {
			interval = width*.03;
			spacer = interval;
			noFill();
		}
		public function draw():void{
			background(0);
			stroke(255);
			var py:Number = 0;
			/* This nestedfor loop fills the frame
				with a wave pattern.Some of its properties
					are controlled,in part,by the mouse position*/
			for(var i:int = 0;i<height;i+=waveGap){
				for(var j:int = 0;j<width;j++){
					py = i+sin(radians(angle))*mouseY*amplitude;
					point(j,py);
					angle+=mouseX*frequency;
				}
			}
			// draw conccentric ring pattern
			for(var k:int=0;k<width/2*spacer/interval;k+=spacer){
				ellipse(mouseX,mouseY,10+k,10+k)
			}
			// describe mouse press behavior
			if(isMousePressed){
				angle = 0;
				isInactive = false;
				if(spacer<interval*2){
					spacer += ringGrowthRate;
				}
			}
			// shrink rings
			if(isInactive){
				if(spacer>interval){
					spacer -= ringGrowthRate;
				}
			}
		}
		// allows ring to shrink
		public function mouseReleased():void {
			isInactive = true;
		}
	}
}


