/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Tm8
 */

package  
{
	import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
	
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0xffffff)]
    public class FlashTest18 extends Sprite
	{
		private var max_spark:int = 8;
		private var circle_d:Number = 360 / max_spark;
		private var spark_list:Array = [];
		private var line_list:Array = [];
		private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
		private var screen:Bitmap = new Bitmap(buffer);

		private var line_color_list:Array = [0x0099ff, 0xff6600];
		
		private var center_x:Number = 30;
		private var center_y:Number = 30;
		
		private var old_x_list:Array = [];
		private var old_y_list:Array = [];
		
		private var count:int = 0;

		public function FlashTest18()
		{
			var init_x:Number;
			var init_y:Number;
			
			for (var i:int = 0; i < max_spark; i++) {
				init_x = Math.cos(circle_d * i * Math.PI / 180) * 500 + stage.stageWidth / 2;
                init_y = Math.sin(circle_d * i * Math.PI / 180) * 500 + stage.stageHeight / 2;
			   
				spark_list.push(new Spark(init_x, init_y, circle_d));
				old_x_list[i] = 0;
				old_y_list[i] = 0;
			}
			
			addChild(screen);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function init(e:Event):void
		{
			for (var i:int = 0; i < max_spark; i++) {
				spark_list[i].flag = 1;
			}
		}
		
		private function onEnterFrame(e:Event):void
		{
			var max:int = spark_list.length;
			
			buffer.lock();
			buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));

			for (var i:int = 0; i < max; i++) {
				spark_list[i].move(stage.mouseX, stage.mouseY, i, count);
			}
			
			for (i = 0; i < max_spark; i++) {
				line_list.push(new Line(old_x_list[i], old_y_list[i], spark_list[i].x + center_x, spark_list[i].y + center_y));
				old_x_list[i] = spark_list[i].x + center_x;
				old_y_list[i] = spark_list[i].y + center_y;
			}
			
			max = line_list.length;
			for (i = 0; i < max; i++) {
				if (line_list[i].move() === false) {
					line_list.splice(i, 1);
					i--;
					max--;
					continue;
				}
				
				buffer.copyPixels(line_list[i].top_bmp, line_list[i].top_bmp.rect, new Point(line_list[i].x, line_list[i].y));
			}
			
			count++;
			if (count >= 360) {
				count = 0;
			}
			
			buffer.unlock();
		}
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;

class Spark
{
	public var x:Number;
	public var y:Number;
	public var tmp_x:Number;
    public var tmp_y:Number;
	public var init_x:Number;
    public var init_y:Number;
	public var d:Number;
	public var c:Number;
	public var flag:uint = 0;
	
    public function Spark(x:int, y:int, d:Number)
    {
		this.d = d;
		this.c = Math.PI / 180;
		this.x = x;
		this.y = y;
		this.tmp_x = x;
		this.tmp_y = y;
		this.init_x = x;
		this.init_y = y;
    }
	
	public function move(x:Number, y:Number, i:int, count:int):Boolean
	{
		var target_x:Number;
		var target_y:Number;
		
		if(this.flag == 0) {
			target_x = x;
			target_y = y;
        } else {
			target_x = this.init_x;
			target_y = this.init_y;
		}
		
        this.tmp_x += (Math.cos((this.d * i + count * 5) * this.c) * 25 + target_x - 30 - this.x) / 20;
        this.tmp_y += (Math.sin((this.d * i + count * 5) * this.c) * 25 + target_y - 30 - this.y) / 20;

        this.tmp_x *= 0.92;
        this.tmp_y *= 0.92;
           
        this.x += this.tmp_x;
        this.y += this.tmp_y;
		
		if (target_x >= this.x - 10 && target_x <= this.x + 10 && target_y >= this.y - 10 && target_y <= this.y + 10) {
			this.flag = 0;
		}
	
		return true;
	}
}

class Line
{
    public var top_bmp:BitmapData;
	public var x:Number;
	public var y:Number;
	public var life:Number = 40;

    public function Line(old_x:Number, old_y:Number, x:Number, y:Number)
    {
        Wonderfl.capture_delay( 10 );
		var width:Number = Math.abs(old_x - x) + 10;
		var height:Number = Math.abs(old_y - y) + 10;
		var from_x:Number;
		var from_y:Number;
		var to_x:Number;
		var to_y:Number;
		
		if (x > old_x) {
			this.x = old_x - (old_x / Math.abs(old_x));
		} else {
			this.x = x - (x / Math.abs(x));
		}
		
		if (y > old_y) {
			this.y = old_y - (old_y / Math.abs(old_y));
		} else {
			this.y = y - (y / Math.abs(y));
		}
		
        this.top_bmp = new BitmapData(width, height, true, 0xffffff);
		
		from_x = x - this.x + 1;
		from_y = y - this.y + 1;
		to_x = old_x -this.x + 1;
		to_y = old_y -this.y + 1;
		
		var top_shape:Shape = new Shape();
		top_shape.graphics.beginFill(0xffffff, 0.1);
		top_shape.graphics.lineStyle(1, 0xffffff, 0.5);
		top_shape.graphics.moveTo(0, 0);
		top_shape.graphics.lineTo(width - 2, 0);
		top_shape.graphics.lineTo(width - 2, height - 2);
		top_shape.graphics.lineTo(0, height - 2);
		top_shape.graphics.lineTo(0, 0);
		top_shape.filters = [new GlowFilter(0xffffff, 0.8, 8, 8, 2)];
		
		this.top_bmp.draw(top_shape);
    }
	
	public function move():Boolean
	{
		life--;
		
		if (life <= 0) {
			return false;
		}
		
		return true;
	}
}
