/**
 * Copyright wellflat ( http://wonderfl.net/user/wellflat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7TVL
 */

package {
  import flash.display.Bitmap;
  import flash.display.BitmapData;
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.filters.BlurFilter;
  import flash.geom.Point;
  import idv.cjcat.stardust.common.clocks.SteadyClock;
  import idv.cjcat.stardust.twoD.renderers.PixelRenderer;
  import frocessing.color.ColorHSV;
  
  [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
  
  /**
   * Draws Tinkerbell Map using Stardust Particle Engine.
   * see also: http://en.wikipedia.org/wiki/Tinkerbell_map
   */
  public class Main extends Sprite {
    private var size:int;
    private var canvas:BitmapData;
    private var blurFilter:BlurFilter;
    private var zero:Point;
    private var renderer:PixelRenderer;
    private var emitter:TinkerbellEmitter;
    private var hsv:ColorHSV;
    
    public function Main():void {
      size = stage.stageWidth;  // required square stage
      graphics.beginFill(0);
      graphics.drawRect(0, 0, size, size);
      canvas = new BitmapData(size, size, true, 0x00000000);
      blurFilter = new BlurFilter(2, 2, 1);
      zero = new Point(0, 0);
      hsv = new ColorHSV();
      emitter = new TinkerbellEmitter(new SteadyClock(1), size);
      renderer = new PixelRenderer(canvas);
      renderer.addEmitter(emitter);
      addChild(new Bitmap(canvas));
      stage.addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
    }
    
    private function draw(e:Event):void {
      canvas.applyFilter(canvas, canvas.rect, zero, blurFilter);
      hsv.h++;
      emitter.plot(hsv.value32);
    }
  }
}

  import idv.cjcat.stardust.common.actions.*;
  import idv.cjcat.stardust.common.clocks.Clock;
  import idv.cjcat.stardust.common.initializers.*;
  import idv.cjcat.stardust.common.math.UniformRandom;
  import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;
  import idv.cjcat.stardust.twoD.actions.*;
  import idv.cjcat.stardust.twoD.emitters.Emitter2D;
  import idv.cjcat.stardust.twoD.initializers.*;
  import idv.cjcat.stardust.twoD.zones.*;

  class TinkerbellEmitter extends Emitter2D {
    private const a:Number = 0.9;
    private const b:Number = -0.6013;
    private const c:Number = 2.0;
    private const d:Number = 0.5;
    private var x:Number;
    private var y:Number;
    private var point:SinglePoint;
    private var plotColor:Color;
    private var size:int;
    
    public function TinkerbellEmitter(clock:Clock,
                                      canvasSize:int,
                                      initialX:Number = -0.72,
                                      initialY:Number = -0.64) {
      super(clock);
      size = canvasSize;
      x = initialX;
      y = initialY;
      point = new SinglePoint();
      addInitializer(new Color());
      addInitializer(new Life(new UniformRandom(1000, 200)));
      addInitializer(new Position(point));
      
      var actions:CompositeAction = new CompositeAction();
      actions.mask = 1 | 2;
      actions.addAction(new Age());
      actions.addAction(new DeathLife());
      actions.addAction(new Move());
      
      var spawn:Spawn = new Spawn(new UniformRandom(1, 0));
      plotColor = new Color();
      spawn.addInitializer(plotColor);
      spawn.addInitializer(new Mask(2));
      spawn.addInitializer(new Life(new UniformRandom(150, 100)));
      spawn.addInitializer(new Velocity(new LazySectorZone(0.04, 0)));
      
      var trigger:DeathTrigger = new DeathTrigger();
      trigger.mask = 1;
      trigger.addAction(spawn);
      
      addAction(actions);
      addAction(trigger);
    }
    
    public function plot(color:uint):void {
      var tmp:Number = x*x - y*y + a*x + b*y;
      y = 2*x*y + c*x + d*y;
      x = tmp;
      point.x = int(x*size/2.4) + size*0.5 + 50;
      point.y = int(-y*size/2.4) + size*0.5 - 100;
      plotColor.color = color;
      step();
    }
  }