/**
 * Copyright kazuyuki ( http://wonderfl.net/user/kazuyuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7T9h
 */

package {
    import flash.display.Sprite;
    import flash.filters.GlowFilter;
    import flash.events.Event;
    
   [SWF(width="465", height="465", backgroundColor="0x000000",frameRate="30")]
    public class animation extends Sprite {
    		
    		private var _ball:Sprite;
    		private var _startX:Number = 0;
    		private var _endX:Number = stage.stageWidth;
    		private var _framecount:Number = 0;
    		private var _framecountLimit:Number = 28;
    		private var _animationframes:Array;
    		
        public function animation() {
            init()
        }
        
        public function init():void{
        		_animationframes = generate_animationFrames();
        		
        		_ball = new Sprite();
        		_ball.graphics.lineStyle(1,0x00ffff);
        		_ball.graphics.beginFill(0x00ffff,0.2);
        		_ball.graphics.drawCircle(0,300,5);
        		_ball.graphics.endFill();
        		//GlowFilter(color:uint = 0xFF0000, alpha:Number = 1.0, blurX:Number = 6.0, blurY:Number = 6.0, strength:Number = 2, quality:int = 1, inner:Boolean = false, knockout:Boolean = false)
        		_ball.filters = [new GlowFilter(0x00ffff,1,10,10,5,1)];
        		addChild(_ball);
        		
        		start();
        }
        private function generate_animationFrames():Array{
        		var tmp:Array = new Array();
        		var easeRatio:Number = 0.2;
        		var tmpX:int = _startX;
        		for(var i:int = 0;i<_framecountLimit; i++){
        			tmpX += (_endX-tmpX)*easeRatio;
        			tmp.push(tmpX);
        		}
        		return tmp;
        }
        	
        	private function render(e:Event):void{
        		if(_framecount < _framecountLimit){
        			_ball.x = _animationframes[_framecount];
        		}else{
        			stop();
        		}
        		_framecount++;
        	}
        	
        	private function start():void{
        		addEventListener(Event.ENTER_FRAME,render);
        		}
        	private function stop():void{
        		removeEventListener(Event.ENTER_FRAME,render);
        		}
    }
}