/**
 * Copyright paulm ( http://wonderfl.net/user/paulm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7T4c
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	public class Clouds05 extends Sprite
	{
		
		/** @private **/
		protected static const canvasWidth:Number = 400;
		protected static const canvasHeight:Number = 400;
		protected static const _spacing:Number = 15;
		private var canvas:Sprite;
		
		public function Clouds05()
		{
			stage.scaleMode = "noScale";
			stage.align = "tl";
			init();
			
		}
		
		protected function init():void
		{
			canvas = new Sprite();
			canvas.x = stage.stageWidth*.5 - canvasWidth*.5;
			canvas.y = stage.stageHeight*.5 - canvasHeight*.5;
			
			addChild(canvas);
			
			addNodes();
			
		}
		
		protected function addNodes():void
		{
			var col:uint = 0;
			var row:uint = 1;
			
			var xpos:Number;
			var ypos:Number;
			
			for (var i:uint=0; i<3700; i++) {
				
				
				if(col >= Math.floor((canvasWidth-_spacing) / _spacing )){
					col = 0;
					row ++;
				}
				
				col++;
				
				/* aligned
				xpos = col*_spacing;
				ypos = row*_spacing;
				*/
				
				// random
				var p:Point = getRandom();
				xpos = p.x;
				ypos = p.y;
				
				//var b:item = new item(Math.random()*15, imageBitmapData.getPixel(xpos, ypos));
				var b:item = new item(Math.random()*15, 0xEEEEEE);
				
				//var q:Point = getRandom();
				b.x = xpos + ((Math.random()*80) - 40);
				b.y = ypos;
				canvas.addChild(b);
				
			}
		}
		
		public function getRandom():Point
		{
			var p:Point = new Point();
			var iterations:Number = 3;
			var xpos:Number = 0;
			for(var j:uint = 0; j < iterations; j++)
			{
				xpos += Math.random() * canvasWidth;
			}
			p.x = xpos / iterations;
			
			var ypos:Number = 0;
			for(j = 0; j < iterations; j++)
			{
				ypos += Math.random() * canvasHeight;
			}
			p.y = ypos / iterations;
			
			return p;
		}
	}
}




import flash.display.Sprite;
import flash.filters.DropShadowFilter;

class item extends Sprite
{
	public function item(size:Number = 20, color:uint = 0xFFFFFF)
	{
		var dsFilter:DropShadowFilter = new DropShadowFilter(0, 0, 0x000000);
		dsFilter.alpha = .65;
		dsFilter.blurX = 2;
		dsFilter.blurY = 2;
		
		this.graphics.beginFill(color, 1);
		this.graphics.drawCircle(size*.5, size*.5, size);
		
		this.filters = [dsFilter];
		
	}
}
