/**
 * Copyright Yuichi ( http://wonderfl.net/user/Yuichi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Rlz
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.LoaderContext;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    
    public class Main extends Sprite
    {
        private var canvas:BitmapData;  //ドットを描写する領域
        private var dots:Vector.<Dot> = new Vector.<Dot>(); //ドットを格納
        private var precision:Number = 6; //ドットの間隔
        private var size:Number = 4; //ドットの大きさ
        private var radius:Number = 300; //ドットを退ける強さ
        private var test:uint = 0; //0:オフ 1:オン
        
        public function Main():void
        {
            //画像をダウンロード
            var url:String = "http://www.occn.zaq.ne.jp/cuaek704/common/img/otomodachi.jpg";
            var loader:Loader = new Loader();
            loader.name = "pre";
            loader.contentLoaderInfo.addEventListener(Event.INIT, onInit);
            loader.load(new URLRequest(url), new LoaderContext(true));
        }
        
        private function onInit(e:Event):void
        {
            //画像からドットの情報を抜き出す
            var loader:Loader;
            var loaderInfo:LoaderInfo = e.currentTarget as LoaderInfo;
            loaderInfo.removeEventListener(Event.INIT, onInit);
            if(loaderInfo.loader.name == "pre"){
                loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.INIT, onInit);
                loader.loadBytes(loaderInfo.bytes);
            } else {
                loader = loaderInfo.loader;
                var pic:BitmapData = new BitmapData(loader.width, loader.height,false);
                pic.draw(loader);
                var ratio:Number = Math.min(1, Math.min(stage.stageWidth / pic.width, stage.stageHeight / pic.height));
                for (var j:int = 0; j < pic.height / precision / ratio; j++) {
                    for (var i:int = 0; i < pic.width * ratio / precision / ratio; i++) {
                        var x:int = int(precision * (i + 0.5) / ratio);
                        var y:int = int(precision * (j + 0.5) / ratio);
                        var c:uint = pic.getPixel32(x, y);
                        if(uint(c / 0x1000000) > 0){
                            var dot:Dot = new Dot(x * ratio + (stage.stageWidth - pic.width * ratio) / 2, y * ratio + (stage.stageHeight - pic.height * ratio) / 2, c);
                            dots.push(dot);
                        }
                    }
                }
                canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
                addChild(new Bitmap(canvas));
                stage.addEventListener(MouseEvent.CLICK, onClick);
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
        }
            
        private function onClick(e:MouseEvent):void
        {
            //オン・オフを切り替える
            test = 1 - test;
        }
        
        private function onEnterFrame(e:Event):void
        {
            //マウスの位置からドットの情報を更新して描写
            canvas.lock();
            canvas.fillRect(new Rectangle(0, 0, canvas.width, canvas.height), 0x00000000);
            for each(var dot:Dot in dots) {
                var angle:Number = Math.atan2(dot.y - mouseY, dot.x - mouseX);
                var distance:Number = Math.sqrt(Math.pow(mouseX - dot.x, 2) + Math.pow(mouseY - dot.y, 2));
                var circle:Number = radius / (distance + 10);
//                if (distance < 50) {
                    dot.x += circle * Math.cos(angle) * test + (dot.baseX - dot.x) * 0.2;
                    dot.y += circle * Math.sin(angle) * test + (dot.baseY - dot.y) * 0.2;
//                } else {
//                    dot.x += (dot.baseX - dot.x) * 0.1;
//                    dot.y += (dot.baseY - dot.y) * 0.1;
//                    if (Math.abs(dot.baseX - dot.x) < 0.5 && Math.abs(dot.baseY - dot.y) < 0.5) {
//                        dot.x = dot.baseX;
//                        dot.y = dot.baseY;
//                    }
//                }
                canvas.fillRect(new Rectangle(int(dot.x),int(dot.y), size, size), dot.color);
            }
            canvas.unlock();
        }
    }
}

class Dot
{
    public var x:Number;
    public var y:Number;
    public var baseX:Number;
    public var baseY:Number;
    public var color:uint;
    
    public function Dot(x:Number, y:Number, color:uint):void
    {
        this.x = baseX = x;
        this.y = baseY = y;
        this.color = color;
    }
}