/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7RLs
 */

// forked from shevchenko's pv3d interactive box with env shaded
// forked from shevchenko's flash on 2010-4-3
// forked from k3lab's Icosahedron
package {
    import flash.display.*;
    import flash.system.LoaderContext;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import jp.progression.data.*;
    import jp.progression.casts.*;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadBitmapData;
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")] 
    public class Main  extends Sprite{
        
      //  public static var ENV_MAP_URL:String ="http://3.bp.blogspot.com/_gOqHtPCk6xw/SLR5OvpSSVI/AAAAAAAAAGc/HFNDtrWBQ54/s1600-h/mountains.png"
       

        public function Main (){
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            const GRAPHIC_URL:String ="http://www.k3lab.com/wonderfl/Amphisbaena/photo1.jpg";
            const LOGO_URL:String ="http://3.bp.blogspot.com/_gOqHtPCk6xw/SLR45J70EiI/AAAAAAAAAGM/_iBk8rwF32g/s400/pv3d.png";//="http://www.k3lab.com/wonderfl/Amphisbaena/photo.jpg";
            
             var context:LoaderContext = new LoaderContext(true);
             new SerialList(null,
              new LoadBitmapData(new URLRequest(LOGO_URL), {context:context}),
              new LoadBitmapData(new URLRequest(GRAPHIC_URL),{context:context}),                
              function ():void {
                    var castbitmap:CastBitmap = new CastBitmap(getResourceById(GRAPHIC_URL).data);
                    //var castbitmap_logo:CastBitmap = new CastBitmap(getResourceById(LOGO_URL).data);
                    
                   var castbitmap_logo:CastBitmap = new CastBitmap(getResourceById(LOGO_URL).data);                  
                    
                    var canvas:BitmapData = castbitmap.bitmapData.clone();
                    var blur:BlurFilter = new BlurFilter(30, 30, 1);
                    canvas.applyFilter(canvas, canvas.rect, new Point(0, 0), blur); 
                    var bmp:Bitmap = addChild(new Bitmap(canvas)) as Bitmap;
                    
                    bmp.scaleX = bmp.scaleY = 3;
                    
                    var snake:Snake = addChild(new Snake(castbitmap, castbitmap_logo) ) as Snake;
                }
               
                ).execute();
             
        }
    }
}
import jp.progression.casts.*;
import org.papervision3d.lights.PointLight3D;
import org.papervision3d.materials.BitmapFileMaterial;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.materials.shadematerials.EnvMapMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.objects.parsers.Collada;
import org.papervision3d.view.BasicView;
import flash.events.Event;
import flash.net.URLRequest;


  
    import flash.events.MouseEvent;
    import flash.ui.Mouse;
    import gs.TweenMax;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
      import org.papervision3d.events.InteractiveScene3DEvent;
  import org.papervision3d.lights.PointLight3D;
  import org.papervision3d.materials.BitmapMaterial;
  import org.papervision3d.materials.shaders.CellShader;
  import org.papervision3d.materials.shaders.EnvMapShader;
  import org.papervision3d.materials.shaders.FlatShader;
  import org.papervision3d.materials.shaders.GouraudShader;
  import org.papervision3d.materials.shaders.PhongShader;
  import org.papervision3d.materials.shaders.ShadedMaterial;
  import org.papervision3d.materials.shaders.Shader;
  import org.papervision3d.objects.DisplayObject3D;
  import org.papervision3d.objects.primitives.Sphere;
  import org.papervision3d.view.BasicView;


   
    
class Snake extends BasicView{
    public static var COLLADA_URL:String ="http://www.k3lab.com/wonderfl/Amphisbaena/geosphere.DAE"
    private var _castbitmap:CastBitmap;
  private var _castbitmap_logo:CastBitmap;
        ///Ufold swf vars
        private var frontpivot:DisplayObject3D;
        private var backpivot:DisplayObject3D;
        private var leftpivot:DisplayObject3D;
        private var rightpivot:DisplayObject3D;
        private var toppivot:DisplayObject3D;
        private var bitmapMaterial:BitmapMaterial;

        private var CUBEWIDTH:Number = 500;
        private var CUBEHEIGHT:Number = 340;
        private var CUBEDEPTH:Number = 600;
               
        private var bottomPlanematerial:ColorMaterial;
        private var frontPlanematerial:ColorMaterial;
        private var backPlanematerial:ColorMaterial;
        private var leftPlanematerial:ColorMaterial;
        private var rightPlanematerial:ColorMaterial;
        private var topPlanematerial:EnvMapMaterial;
        
       
        private var vr:Number = .05;
        private var isDown : Boolean = false;
        private var drag:Boolean;
        private var _x : Number;
        private var _y : Number;
       
        private var _vx : Number = 0;
        private var _vy : Number = 0;
       
        private var cubeHolder:DisplayObject3D;
        private var topPlane:Plane;
        public function Snake(bmp:CastBitmap, bmp_logo:CastBitmap){
        super(465, 465, false, true);
        
       _castbitmap = bmp;
       _castbitmap_logo = bmp_logo;
       
             
        init();
    }
    private function init():void{
        var light:PointLight3D = new PointLight3D(false, false);
        var envMapMaterial:EnvMapMaterial = new EnvMapMaterial(light, _castbitmap.bitmapData, _castbitmap.bitmapData,0x555555);
         var shader:Shader;
                bitmapMaterial = new BitmapMaterial(_castbitmap.bitmapData, false);
                bitmapMaterial.smooth = true;
                shader = new EnvMapShader(light, _castbitmap_logo.bitmapData, _castbitmap_logo.bitmapData, 0x333333);
                var shadedMapMaterial:ShadedMaterial =  new ShadedMaterial(bitmapMaterial, shader);
               // envMapMaterial.interactive = true;
        //scene.addChild(light);
        
        
        var materialsList:MaterialsList = new MaterialsList(); 
        
        materialsList.addMaterial( shadedMapMaterial, "Mat"); 
        
        var c:Collada = new Collada(COLLADA_URL, materialsList, 0.2);
        
       // scene.addChild(c);
        
        addEventListener(Event.ENTER_FRAME, function(e:Event):void {
           // light.copyPosition(camera) 
            cubeHolder.yaw((200- mouseX )/80);
            cubeHolder.pitch((200- mouseY )/80);
            
        })
         createCube();
        //PVUnfoldCube2();
      
       startRendering();
    }
    ///Cube folding functions
        public function PVUnfoldCube2():void
        {
            createCube();
            //viewport.interactive = true;
           
            //singleRender();
           // addEventListener(Event.ENTER_FRAME, tick);
           
           // stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
           // stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
        }
        private function createCube():void
        {
                   
                   
        
            var light:PointLight3D = new PointLight3D(false, false);
              
        var envMapMaterial:EnvMapMaterial = new EnvMapMaterial(light, _castbitmap.bitmapData, _castbitmap.bitmapData,0x555555);
            var shader:Shader;
                bitmapMaterial = new BitmapMaterial(_castbitmap_logo.bitmapData, false);
                bitmapMaterial.smooth = true;
                shader = new EnvMapShader(light, _castbitmap.bitmapData, _castbitmap.bitmapData, 0x666666);
                var shadedMapMaterial:ShadedMaterial =  new ShadedMaterial(bitmapMaterial, shader);
               // envMapMaterial.interactive = true;
                              
          
         
          scene.addChild(light);
  
        var materialsList:MaterialsList = new MaterialsList(); 
        materialsList.addMaterial( shadedMapMaterial, "Mat");     
        
        
    
            cubeHolder = new DisplayObject3D();
            scene.addChild(cubeHolder);
           
            // ------------------------------------------------------------------------
            //    BOTTOM
            // ------------------------------------------------------------------------
            bottomPlanematerial= new ColorMaterial(0xff0000)
            var bottomPlane:Plane = new Plane(shadedMapMaterial, CUBEWIDTH, CUBEDEPTH);
            bottomPlane.y = -100;
            
             bottomPlane.material=shadedMapMaterial;
            bottomPlane.pitch(-90);
            bottomPlane.material.doubleSided = true;
            
            cubeHolder.addChild(bottomPlane);
           
            /*
            var axis:Gimble = new Gimble();
            bottomPlane.addChild(axis);
            axis.useOwnContainer = true;
            */
           
            // ------------------------------------------------------------------------
            //    FRONT
            // ------------------------------------------------------------------------
            frontpivot = new DisplayObject3D();
            frontpivot.y = CUBEDEPTH/2;
            bottomPlane.addChild(frontpivot);
           
            frontPlanematerial= new ColorMaterial(0x00ff00)
            var frontPlane:Plane = new Plane(shadedMapMaterial, CUBEWIDTH, CUBEHEIGHT);
            frontPlane.z = CUBEHEIGHT/2;
            frontPlane.pitch(90);
             frontPlane.material.doubleSided = true;
            frontpivot.addChild(frontPlane);
           
           
            // ------------------------------------------------------------------------
            //    BACK
            // ------------------------------------------------------------------------
            backpivot = new DisplayObject3D();
            backpivot.y = -CUBEDEPTH/2;
            bottomPlane.addChild(backpivot);
           
            backPlanematerial= new ColorMaterial(0xffff00)
            var backPlane:Plane = new Plane(shadedMapMaterial, CUBEWIDTH, CUBEHEIGHT);
            backPlane.z = CUBEHEIGHT/2;
            backPlane.pitch(-90);
            backpivot.addChild(backPlane);
           
            // ------------------------------------------------------------------------
            //    LEFT
            // ------------------------------------------------------------------------
            leftpivot = new DisplayObject3D();
            leftpivot.x = CUBEWIDTH/2;
            bottomPlane.addChild(leftpivot);
           
            leftPlanematerial= new ColorMaterial(0x0000ff)
            var leftPlane:Plane = new Plane(shadedMapMaterial, CUBEHEIGHT, CUBEDEPTH);
            leftPlane.z = CUBEHEIGHT/2;
            leftPlane.yaw(-90);
            leftpivot.addChild(leftPlane);
           
           
            // ------------------------------------------------------------------------
            //    RIGHT
            // ------------------------------------------------------------------------
            rightpivot = new DisplayObject3D();
            rightpivot.x = -CUBEWIDTH/2;
            bottomPlane.addChild(rightpivot);
           
            rightPlanematerial= new ColorMaterial(0x000000)
            var rightPlane:Plane = new Plane(shadedMapMaterial, CUBEHEIGHT, CUBEDEPTH);
            rightPlane.z = CUBEHEIGHT/2;
            rightPlane.yaw(90);
            rightpivot.addChild(rightPlane);
           
            // ------------------------------------------------------------------------
            //    TOP
            // ------------------------------------------------------------------------
            toppivot = new DisplayObject3D();
            toppivot.y = CUBEHEIGHT/2;
            frontPlane.addChild(toppivot);
           
           
           // topPlanematerial = new ColorMaterial(0x5E3A6D);
           topPlanematerial = envMapMaterial;
            topPlanematerial.interactive = true;
            
            topPlane = new Plane(topPlanematerial, CUBEWIDTH,CUBEDEPTH);
            topPlane.z = CUBEDEPTH/2;
            topPlane.pitch(90);
            toppivot.addChild(topPlane);
           
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, opencube, false, 0, true);
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, mouseIcon, false, 0, true);
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, mouseIcon, false, 0, true);
           
        }
       
        private function mouseIcon(e:InteractiveScene3DEvent):void
        {
            if (e.type == "mouseOver")
            {
                this.buttonMode = true;
            }
            else
            {
                this.buttonMode = false;
            }
        }
       
        private function opencube(e:InteractiveScene3DEvent):void
        {
          
           
            TweenMax.to(frontpivot, 3, { localRotationX:"90", onStart:onStartTween  } );
            TweenMax.to(backpivot, 3, { localRotationX:"-90" } );
            TweenMax.to(leftpivot, 3, { localRotationY:"-90" } );
            TweenMax.to(rightpivot, 3, { localRotationY:"90" } );
            TweenMax.to(toppivot, 3, { localRotationX:"90", onComplete:onEndTween } );
           
            e.target.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, opencube);
            e.target.removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, mouseIcon);
        }
       
        private function onStartTween():void
        {
           
        }
       
        private function onEndTween():void
        {
            TweenMax.to(frontpivot, 3, { localRotationX:"-90" } );
            TweenMax.to(backpivot, 3, { localRotationX:"90" } );
            TweenMax.to(leftpivot, 3, { localRotationY:"90" } );
            TweenMax.to(rightpivot, 3, { localRotationY:"-90" } );
            TweenMax.to(toppivot, 3, { localRotationX:"-90", onComplete:onEndTween2} );
        }
       
        private function onEndTween2():void
        {
           
           
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, opencube, false, 0, true);
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, mouseIcon, false, 0, true);
        }
       
        // camera orbit easing
        private function downHandler(event : MouseEvent) : void {
            _x = mouseX;
            _y = mouseY;
            isDown = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
        }
       
        private function upHandler(event : MouseEvent) : void {
            isDown = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
        }
       
        private function moveHandler(event : MouseEvent) : void {
            _vx = (mouseX - _x) * .4;
            _vy = (mouseY - _y) * .2;
            _x = mouseX;
            _y = mouseY;
           
            cubeHolder.rotationX  -= _vy;
            cubeHolder.rotationY -= _vx;
           
        }
       
        private function tick(e:Event):void
        {
            //easing
            if(!isDown) {
                if(_vx != 0 || _vy != 0) {
                    _vx *= .9;
                    _vy *= .9;
                    if(Math.abs(_vx) < .1) {
                        _vx = 0;
                    }
                    if(Math.abs(_vy) < .1) {
                        _vy = 0;
                    }
                    cubeHolder.rotationX -= _vy;
                    cubeHolder.rotationY -= _vx;
                }
            }
            singleRender();
        }
}