/**
 * Copyright amine2010 ( http://wonderfl.net/user/amine2010 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7QdQ
 */

// forked from hacker_j5c1ldvh's forked from: forked from: Human Clock
// forked from termat's forked from: Human Clock
// forked from Event's Human Clock
package
{
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;

    [SWF(framerate = "30", width = "480",height="480",backgroundColor="0x000000")]
    public class Practice89 extends Sprite{
        private var list:Vector.<ClockMan> = new Vector.<ClockMan>();
        private var team:Team;
        private var time:Date;
        private var text:TextField;
        private var tf:TextFormat;
        private var bmpdata:BitmapData;
        private var canUpdate:Boolean = true;
        
        public function Practice89() {
            initTime();
            var ss:Number = (time.getSeconds() * 6 + 270) % 360;
            for (var i:Number = 0; i < 360; i = i + 3) {
                var xx:Number = Math.cos(i / 180.0 * Math.PI);
                var yy:Number = Math.sin(i / 180.0 * Math.PI);
                var col:uint = 0x888888;
                if (i == ss) col = 0xff0000;
                for (var j:int = 0; j < 6; j++) {
                    var rr:Number = 200 -(j * 15);
                    var c:ClockMan = new ClockMan(col, rr * xx + ClockMan.center.x, rr * yy + ClockMan.center.y);
                    c.scaleX = 0.3;
                    c.scaleY = 0.3;
                    c.deg = i;
                    c.rad = rr;
                    list.push(c);
                    addChild(c);
                }
            }
            team=new Team();
            addChildAt(team, 0);
            setTime();
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function initTime():void {
            time = new Date();
            text = new TextField();
            tf = new TextFormat();
            tf.size = 96;
            tf.color = 0x000000;
            tf.bold = true;
            text.defaultTextFormat = tf;
        }

        private function setTime():void {
            var mes:String = "";
            var hh:Number = time.getHours();
            if (hh < 10) {
                mes = "0" + hh.toString();
            }else {
                mes = hh.toString();
            }
            var mm:Number = time.getMinutes();
            if (mm < 10) {
                mes = mes + ":0" + mm.toString();
            }else {
                mes = mes + ":" + mm.toString();
            }
            text.text = mes;
            text.width = text.textWidth + 2;
            text.height = text.textHeight + 2;
            bmpdata = new BitmapData(text.textWidth + 2, text.textHeight + 2, false, 0xffffff);
            bmpdata.fillRect(bmpdata.rect,0xffffff);
            bmpdata.draw(text);
            var al:Array = new Array();
            for (var i:int = 0; i < bmpdata.width; i=i+5) {
                for (var j:int = 0; j < bmpdata.height; j=j+5) {
                    if (bmpdata.getPixel(i, j) != 0) continue;
                    al.push(new Point(i, j));
                }
            }
            team.setPoint(al);
            team.x = 130;
            team.y = 200;
            canUpdate = true;
        }
        
        private function update(e:Event):void {
            for each(var c:ClockMan in list) {
                c.move();
            }
            time = new Date();
            team.draw();
            if (canUpdate && time.getSeconds() == 0) {
                removeChild(team);
                canUpdate = false;
                setTime();
                addChildAt(team, 0);
            }
        }
    }
}

import flash.display.MovieClip;
import flash.geom.Point;

class Man extends MovieClip {
    public var dir:Number = 0;
    private var cap:Point = new Point(5*Math.sin(dir/180*Math.PI), 0);
    private var head:Point = new Point(0, 0);
    private var bodyH:Point = new Point(1*Math.sin(dir/180*Math.PI), 10);
    private var bodyL:Point = new Point(-1*Math.sin(dir/180*Math.PI), 20);
    private var legRH:Point = new Point(5*Math.cos(dir/180*Math.PI), 30);
    private var legRL:Point = new Point(5*Math.cos(dir/180*Math.PI), 45);
    private var legLH:Point = new Point(-5*Math.cos(dir/180*Math.PI), 30);
    private var legLL:Point = new Point( -5*Math.cos(dir/180*Math.PI), 45);
    private var sholderR:Point = new Point(5*Math.cos(dir/180*Math.PI), 6);
    private var sholderL:Point = new Point(-5*Math.cos(dir/180*Math.PI), 6);
    private var armRH:Point = new Point(5*Math.cos(dir/180*Math.PI), 16);
    private var armRL:Point = new Point(8*Math.cos(dir/180*Math.PI), 26);
    private var armLH:Point = new Point(-5*Math.cos(dir/180*Math.PI), 16);
    private var armLL:Point = new Point(-8*Math.cos(dir/180*Math.PI), 26);
    
    public var time0:Number = Math.PI*Math.random();
    public var time1:Number = Math.PI * Math.random();
    public var addTime0:Number = 0.3;
    public var addTime1:Number = 0.4;
    private var color:uint;
    
    public function Man(c:uint,xx:Number,yy:Number):void {
        color = c;
        x = xx;
        y = yy;
        drawMan();
    }
    
    public function drawMan():void {
        update();
        graphics.clear();
        graphics.beginFill(color );
        graphics.drawCircle(head.x, head.y, 4);
        graphics.endFill();
        graphics.lineStyle(1.0, color);
        graphics.moveTo(head.x, head.y);
        graphics.lineTo(bodyH.x, bodyH.y);
        graphics.lineTo(bodyL.x, bodyL.y);
        graphics.lineTo(legRH.x, legRH.y);
        graphics.lineTo(legRL.x, legRL.y);
        graphics.moveTo(bodyL.x, bodyL.y);
        graphics.lineTo(legLH.x, legLH.y);
        graphics.lineTo(legLL.x, legLL.y);
        graphics.moveTo(sholderR.x, sholderR.y);
        graphics.lineTo(sholderL.x, sholderL.y);
        graphics.lineTo(armLH.x, armLH.y);
        graphics.lineTo(armLL.x, armLL.y);
        graphics.moveTo(sholderR.x, sholderR.y);
        graphics.lineTo(armRH.x, armRH.y);
        graphics.lineTo(armRL.x, armRL.y);
        graphics.moveTo(head.x, head.y);
        graphics.lineTo(cap.x, cap.y);
    }
    
    private function update():void {
        sholderR = new Point(5 * Math.cos(dir / 180 * Math.PI), 6);        
        sholderL = new Point(-5 * Math.cos(dir / 180 * Math.PI), 6);
        cap = new Point(8 * Math.sin(dir / 180 * Math.PI), 0);
        var lg:Number = Math.cos(time0);
        time0 += addTime0;
        armRH = new Point(5 * Math.cos(dir / 180 * Math.PI)+4*lg*Math.sin(dir/180*Math.PI), 16);
        armRL = new Point(8 * Math.cos(dir / 180 * Math.PI)+10*lg*Math.sin(dir/180*Math.PI), 26);
        armLH = new Point( -5 * Math.cos(dir / 180 * Math.PI)-4*lg*Math.sin(dir/180*Math.PI), 16);
        armLL = new Point( -8 * Math.cos(dir / 180 * Math.PI)-10*lg*Math.sin(dir/180*Math.PI), 26);
        lg = Math.cos(time1);
        time1 += addTime1;
        legRH = new Point(5 * Math.cos(dir / 180 * Math.PI)-2*lg*Math.sin(dir/180*Math.PI), 30);
        legLH = new Point( -5 * Math.cos(dir / 180 * Math.PI)+2*lg*Math.sin(dir/180*Math.PI), 30);    
        legRL = new Point(5 * Math.cos(dir / 180 * Math.PI)-8*lg*Math.sin(dir/180*Math.PI), 45);
        legLL = new Point( -5 * Math.cos(dir / 180 * Math.PI)+8*lg*Math.sin(dir/180*Math.PI), 45);
        bodyH = new Point(1 * Math.sin(dir / 180 * Math.PI), 10);
        bodyL = new Point( -1 * Math.sin(dir / 180 * Math.PI), 20);
    }
    
    public function dist(x0:Number, y0:Number, x1:Number, y1:Number):Number {
        var len:Number = (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1);
        return Math.sqrt(len);
    }
}

class TimeMan extends Man {
    private var pos:Point;
    
    public function TimeMan(c:uint, xx:Number, yy:Number,px:Number,py:Number):void {
        super(c, xx, yy);
        pos = new Point(px, py);
        addTime0 = 0.15;
        addTime1 = 0.2;
    }
    
    public function moveIn():void {
        var dx:Number = pos.x - x;
        var dy:Number = pos.y - y;
        var l:Number = dist(pos.x,pos.y,x,y);
        if (dx != 0) {
            dir = -Math.atan2(dy, dx) / Math.PI * 180 + 90;
        }else {
            dir = 90;
        }
        x += dx * 0.02;
        y += dy * 0.02;
        drawMan();
    }
    
    public function setPos(p:Point):void {
        pos = p;
    }
    
}

class ClockMan extends Man {
    public var deg:Number = 0;
    public var rad:Number = 100;
    public static const center:Point = new Point(240,240);
    
    public function ClockMan(c:uint, xx:Number, yy:Number):void {
        super(c, xx, yy);
    }
    
    public function move():void {
        deg = (deg + 0.2) % 360;
        var rr:Number = deg / 180 * Math.PI;
        var nx:Number = rad * Math.cos(rr) + center.x;
        var ny:Number = rad * Math.sin(rr) + center.y;
        var l:Number = dist(x, y, nx, ny);
        var dx:Number = (nx - x);
        var dy:Number = (ny - y);
        if (dx != 0) dir = -Math.atan2(dy, dx) / Math.PI * 180 + 90;
        x += dx;
        y += dy;
        drawMan();
    }
}

class Team extends MovieClip {
    public var team:Vector.<TimeMan> = new Vector.<TimeMan>();
    
    public function add(m:TimeMan):void {
        team.push(m);
        addChild(m);
    }
    
    public function draw():void {
        for each(var m:TimeMan in team) {
            m.moveIn();
            m.drawMan();
        }
    }
    
    public function setPoint(p:Array):void {
        while (team.length > p.length) {
            var t:TimeMan = team.pop();
            removeChild(t);
        }
        while (p.length > team.length) {
            var m:TimeMan = new TimeMan(0x666666, 0, 0, 0, 0);
            m.dir = -90;
            m.scaleX = 0.3;
            m.scaleY = 0.3;
            add(m);
        }
        for (var i:int = 0; i < p.length; i++) {
            team[i].setPos(p[i]);
        }
    }

}