/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7QOB
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    
    public class FlashTest extends Sprite {
        private var _prev:uint;
        
        public function FlashTest() {
            var date:Date = new Date();
            _prev = (date.hours * 10000) + (date.minutes * 100) + (date.seconds);

            // BG
            for (var index:uint = 0; index < 465; ++index) {
                var b:uint = (index > 233) ? 465 - index : index;
                this.graphics.beginFill(0x202020, 1.0 - (uint(b / 16) / 64.0));
                this.graphics.drawRect(0, index, 465, 1);
                this.graphics.endFill();
            }

            this.addEventListener(Event.ENTER_FRAME, proc);
        }
        
        private function proc(e:Event):void {
            var date:Date = new Date();
            var current:uint = (date.hours * 10000) + (date.minutes * 100) + (date.seconds);
            
            if (current != _prev) {
                var baseX:uint = 22;
                var baseY:uint = 192.5;
                var dist:uint = 64;
                var distColon:uint = 32;
                create(baseX, baseY, numArray(date.hours / 10));
                create(baseX + (dist * 1), baseY, numArray(date.hours % 10));
                create(baseX + (dist * 2), baseY, colonArray());
                create(baseX + (dist * 2) + distColon, baseY, numArray(date.minutes / 10));
                create(baseX + (dist * 3) + distColon, baseY, numArray(date.minutes % 10));
                create(baseX + (dist * 4) + distColon, baseY, colonArray());
                create(baseX + (dist * 4) + (distColon * 2), baseY, numArray(date.seconds / 10));
                create(baseX + (dist * 5) + (distColon * 2), baseY, numArray(date.seconds % 10));
            }
            _prev = current;
        }
        
        private function create(posx:Number, posy:Number, a:Array):void {
            for (var index:uint = 0; index < a.length; ++index) {
                var data:Array = a[index];
                var x:uint = data[0];
                var y:uint = data[1];
                var r:uint = 128 + (Math.random() * 128);
                var g:uint = 128 + (Math.random() * 128);
                var b:uint = 128 + (Math.random() * 128);
                var color:uint = (r << 16) + (g << 8) + (b << 0);
                var dot:Dot = new Dot(color);
                dot.x = Math.random() * 465;
                dot.y = Math.random() * 465;
                dot.x = (dot.x > 232.5) ? -40 : 485;
                dot.y = (dot.y > 232.5) ? -40 : 485;
                Tweener.addTween(dot, {x:posx + (x * 18), y:posy + (y * 18), time:18, useFrames:true});
                Tweener.addTween(dot, {scaleX:6.0, scaleY:6.0, alpha:0, delay:25, time:15, useFrames:true, onComplete:function():void{ this.removeChild(dot); }});
                this.addChild(dot);
            }
            
        }
        
        private function numArray(num:uint):Array {
            var array:Array = new Array();
            switch (num) {
                case 0:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 1));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 3));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 1:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 1));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 3));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 4));
                    break;
                case 2:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 3));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 4));
                    break;
                case 3:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 4:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 1));
                    array.push(new Array(0, 2));
                    array.push(new Array(1, 2));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 5:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 1));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 6:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 1));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 3));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 7:
                    array.push(new Array(0, 0));
                    array.push(new Array(1, 0));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 8:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 1));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 3));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
                case 9:
                    array.push(new Array(0, 0));
                    array.push(new Array(0, 1));
                    array.push(new Array(0, 2));
                    array.push(new Array(0, 4));
                    array.push(new Array(1, 0));
                    array.push(new Array(1, 2));
                    array.push(new Array(1, 4));
                    array.push(new Array(2, 0));
                    array.push(new Array(2, 1));
                    array.push(new Array(2, 2));
                    array.push(new Array(2, 3));
                    array.push(new Array(2, 4));
                    break;
            }
            return array;
        }
        
        private function colonArray():Array {
            var array:Array = new Array();
            array.push(new Array(0, 1));
            array.push(new Array(0, 3));
            return array;
        }

    }
}
import flash.display.Sprite;


class Dot extends Sprite
{
    public function Dot(color:uint) {
        this.graphics.beginFill(color);
        this.graphics.drawRoundRect(-7, -7, 14, 14, 4);
        this.graphics.endFill();
    }
}


