/**
 * Copyright zotin95 ( http://wonderfl.net/user/zotin95 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Q5L
 */

// forked from enok's Golden Spiral
//黄金比を使った螺旋四角形
//クリックすると色が変わり、連打すると消えていきます。

//full version
//http://linkalink.jp/enok/swf/third/
//blog
//http://linkalink.jp/enok/?p=768

//reference & document
//http://www.libspark.org/wiki/nutsu/Frocessing
//http://www.libspark.org/htdocs/as3/frocessing/
//http://processing.org/reference/

package {
    import com.flashdynamix.utils.SWFProfiler;
    import frocessing.display.F5MovieClip3D;
    import frocessing.display.F5MovieClip3DBmp;
    import frocessing.geom.FGradientMatrix;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(backgroundColor = "0xffffff", frameRate = "50")] 
    
    public class Frocessing extends F5MovieClip3DBmp {
        
        private var _golden_ratio:Number = 1.618; //黄金比
        private var _shape_size:Number = 300; //一辺の長さ
        public function Frocessing():void {
            //SWFProfiler.init(stage, this);
            //Wonderfl.capture_delay(30);
            Wonderfl.disable_capture();
        }
        
        public function setup():void {
            //背景
            background( 0xffffff ); 
        }
        
        private var _spiral_count:uint = 1; //四角形の数
        public function draw( ):void {
            if (frameCount % 50 == 0) {
                //50回に1回増やす
                _spiral_count++;
            }
            
            //カメラセット
            setCamera();
            //真ん中に移動
            translate( stage.stageWidth / 2 - _shape_size / 2, stage.stageHeight / 2 - _shape_size / 2 );
            //再帰処理
            drawSpiral(_spiral_count);
        }
        
        private var _angle:Number = -2 * Math.PI / 4; //広がりの角度
        private var _color_no:uint = 1; //現在の色番
        private var _color:Array = new Array(
            new Array(1.4, 5.0, 5.0),
            new Array(5.0, 1.4, 5.0),
            new Array(5.0, 5.0, 1.4)
            
        ); //色パターン
        private function drawSpiral(n:uint):void {
            //再帰処理から抜ける
            if ( n-- <= 0 ) return;
            
            //色設定
            var p:int = 100;
            colorMode( RGB, random(p*_color[_color_no%_color.length][0],p) , p*_color[_color_no%_color.length][1], p*_color[_color_no%_color.length][2] );
            var c:Number = color( p, p, p );
            
            //グラデーション塗り
            var mtx:FGradientMatrix = new FGradientMatrix();
            mtx.createLinear( 0, 0, _shape_size, _shape_size );
            beginGradientFill( "linear", [0, c], [0.2, 0.2], [0, 128], mtx );
            //beginFill(c, 0.1);
            rect(0, 0, _shape_size, _shape_size);
            endFill();
            
            //線色設定
            colorMode( RGB, 1, 1, 1 );
            
            //対角線
            stroke(0, 1, 0, 0.4 );
            line(0, 0, _shape_size, _shape_size);
            //扇線
            stroke(0.5, 1, 0.5, 0.3 );
            noFill();
            beginShape();
            moveTo(0, 0);
            curveTo(0, _shape_size, _shape_size, _shape_size);
            endShape();
            
            //キャンバス回転
            rotate( _angle );
            //キャンバス拡大
            scale( _golden_ratio );
            //キャンバス移動
            translate( -_shape_size, -_shape_size );
            //角度をずらしていく
            _angle += 0.002;
            
            //再帰処理
            drawSpiral(n);
        }
        
        private var _x:Number = stage.stageWidth / 2; //カメラX
        private var _y:Number = stage.stageHeight / 2; //カメラY
        public var _z:Number = 800; //カメラZ
        public var _rotation_z:Number = 0; //カメラZローテーション
        private function setCamera():void {
            //カメラの動き設定
            camera( _x, _y, _z, stage.stageWidth / 2, stage.stageHeight / 2, 0.0, 0.0, 1.0, 0.0);
            if (frameCount % 50 == 0) {
                BetweenAS3.to(this, {
                    _z: _z * _golden_ratio, 
                    _rotation_z:_rotation_z + Math.PI / 2 }, 0.4, Sine.easeOut
                ).play();
            }
            rotateZ(_rotation_z);
        }
        
        public function mousePressed():void {
            if (_spiral_count > 3) {
                //四角形の数を減らす
                _spiral_count--;
                //色の変更
                _color_no++;
                //カメラサイズの変更
                _z = _z / _golden_ratio;
            }
        }
    }
}
