/**
 * Copyright SoWhat1983 ( http://wonderfl.net/user/SoWhat1983 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7PkD
 */

// forked from dada_sygnas's 投稿テスト
/*
Wonderflの投稿テストです。
*/

package{
	
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
    [SWF(backgroundColor="#FFFFFF", frameRate=25)]
	public class Main extends MovieClip{

		public static const ATTACH_X:int	= 20;
		public static const ATTACH_Y:int	= 20;
		public static const ATTACH_W:int	= 20;
		public static const ATTACH_H:int	= 19;
		public static const MARGIN:int		= 24;
		
		private var $targetList:Array;
		
		/***********************************
		* コンストラクタ
		*/
		public function Main(){

			$targetList = [];

			for( var y:int=0; y<ATTACH_H; y++ ){
				for( var x:int=0; x<ATTACH_W; x++ ){
					
					var attachX:Number = x * MARGIN + ATTACH_X;
					var attachY:Number = y * MARGIN + ATTACH_Y;
					
					var escapeTaget:EscapeTarget = new EscapeTarget( attachX, attachY );
					
					addChild( escapeTaget );
					$targetList.push( escapeTaget );
				}
			}
			

			this.addEventListener( Event.ENTER_FRAME, ___onEnterFrame );
		}
		
		/***********************************
		* エンターフレーム
		*/
		protected function ___onEnterFrame( e:Event ):void{
			var targetList:Array = $targetList;
			var len:int = targetList.length;

			for( var i:int=0; i<len; i++ ){
				targetList[i].checkMouse( mouseX, mouseY );
			}
			
		}
	}
}


import flash.display.*;
import flash.events.*;
import flash.geom.*;


/**************************************
* 逃げ回る玉
*/
class EscapeTarget extends Sprite{
	
	public static const SIZE:Number			= 10;	// 球のサイズ
	public static const RANGE:Number		= 60;	// 拒絶範囲
	public static const KIRAI:Number		= 1.3;	// どれくらい拒絶するか（距離の倍率）
	public static const SPEED_PAR:Number	= 4;	// 移動ののろさ

	protected var $startPt:Point;
	
	/************************************
	* コンストラクタ
	* @param attachX,attachY	基準点
	*/
	public function EscapeTarget( attachX:Number, attachY:Number ){
		super();

		$startPt = new Point( attachX, attachY );
		
		var circle:Shape = new Shape();
		circle.graphics.beginFill( 0 );
		circle.graphics.drawCircle( 0, 0, SIZE );
		circle.graphics.endFill();
		
		this.addChild( circle );
		this.x = attachX;
		this.y = attachY;
	}
	
	/************************************
	* マウスをチェック
	* @param gmX,gmY	配置先のマウス座標
	*/
	public function checkMouse( gmX:Number, gmY:Number ):void{
		
		// 目的座標
		var targetX:Number;
		var targetY:Number;
		// 自分からのマウス座標
		var mousePt:Point = new Point( mouseX, mouseY );
		// 自分からマウスへの距離
		var dist:Number = Point.distance( mousePt, new Point(0,0) );
		
		// 範囲に入っていた
		if( dist < RANGE ){
			
			// 侵入距離
			var insert:Number = (dist - RANGE) * KIRAI;
			// 侵入角度
			var radian:Number = Math.atan2( mouseX, mouseY );
			
			targetX = Math.sin( radian ) * insert + $startPt.x;
			targetY = Math.cos( radian ) * insert + $startPt.y;

		// 範囲外
		}else{
			targetX = $startPt.x;
			targetY = $startPt.y;
		}

		this.x += (targetX - this.x) / SPEED_PAR;
		this.y += (targetY - this.y) / SPEED_PAR;
		
		// 色を変更
		___changeColor();
	}

	/************************************
	* 距離によって色を変更
	*/
	public function ___changeColor():void{
		// 自分の座標
		var myPt:Point = new Point(this.x, this.y);
		// マウスグローバル座標
		var globalMouse:Point = localToGlobal( new Point( mouseX, mouseY ));
		// マウスからの距離
		var distMouse:Number = Point.distance( globalMouse, myPt ) / 2;
		// マウス距離から色数を算出
		var green:Number = 255 - Math.min( distMouse / RANGE * 255, 255 );;
		
		var colorTrans:ColorTransform = new ColorTransform();
		colorTrans.greenOffset = green;
		
		this.transform.colorTransform = colorTrans;
	}
}


