/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7PYh
 */

package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Matrix3D;

    public class Test extends Sprite
    {    

        static private const _N:Number = Math.PI / 180;

        public function Test()
        {
            _init();
        }

        private function _init():void
        {
            _matrix = new Matrix();
            _vector = new Vector.<Triangle>();
            for (var i:int = 0; i < LENGTH; i++)
            {
                _vector[i] = new Triangle();
            }
            stage.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            stage.quality = StageQuality.LOW;
        }


        private function _enterFrameHandler(e:Event):void 
        {
            var mx:Number = mouseX;
            var my:Number = mouseY;
            var length:int = _vector.length;
            

            for (var i:int = length - 1; i >= 0; i--)

            {

                var tri:Triangle = _vector[i];
                _matrix.identity();
                _matrix.tx = tri.ax;
                _matrix.ty = tri.ay;
                _matrix.rotate(tri.rv);
                tri.ax = _matrix.tx;
                tri.ay = _matrix.ty;

                _matrix.identity();
                _matrix.tx = tri.bx;
                _matrix.ty = tri.by;
                _matrix.rotate(tri.rv);
                tri.bx = _matrix.tx;
                tri.by = _matrix.ty;

                _matrix.identity();
                _matrix.tx = tri.cx;
                _matrix.ty = tri.cy;
                _matrix.rotate(tri.rv);
                tri.cx = _matrix.tx;
                tri.cy = _matrix.ty;

                tri.x += tri.vx;
                tri.y += tri.vy;

                tri.x = tri.x < 0 ? 465 : (tri.x > 465 ? 0 : tri.x);
                tri.y = tri.y < 0 ? 465 : (tri.y > 465 ? 0 : tri.y);

                var hit:Boolean = _test(mx, my, tri.ax + tri.x, tri.ay + tri.y, tri.bx + tri.x, tri.by + tri.y, tri.cx + tri.x, tri.cy + tri.y);
                tri.color = hit ? 0xFF0000 : 0x898989;
            }
            _draw();
        }
        
        private function _draw():void
        {

            var length:int = _vector.length;
            var g:Graphics = graphics;
            g.clear();
            for (var i:int = length - 1; i >= 0; i--)
            {
                var tri:Triangle = _vector[i];
                g.beginFill(tri.color);
                g.moveTo(tri.ax + tri.x, tri.ay + tri.y);
                g.lineTo(tri.bx + tri.x, tri.by + tri.y);
                g.lineTo(tri.cx + tri.x, tri.cy + tri.y);
                g.lineTo(tri.ax + tri.x, tri.ay + tri.y);
                g.endFill();
            }
        }

        private function _test(px:Number, py:Number, pax:Number, pay:Number, pbx:Number, pby:Number, pcx:Number, pcy:Number):Boolean
        {
            var ax:Number, bx:Number, cx:Number, dx:Number, ex:Number, fx:Number, ay:Number, by:Number, cy:Number, dy:Number, ey:Number, fy:Number;
            ax = px  - pax;        ay = py  - pay;//p0
            bx = pbx - pax;        by = pby - pay;//p1
            cx = px  - pbx;        cy = py  - pby;//p2
            dx = pcx - pbx;        dy = pcy - pby;//p3
            ex = px  - pcx;        ey = py  - pcy;//p4
            fx = pax - pcx;        fy = pay - pcy;//p5
            return !(((ay * bx - ax * by) < 0) || ((cy * dx - cx * dy) < 0) || ((ey * fx - ex * fy) < 0));
        }

        private const LENGTH:int = 40;
        private var _vector:Vector.<Triangle>;
        private var _matrix:Matrix;
    }
}





internal class Triangle
{

    static private const _RADIUS:int = 80;
    static private const _N:Number = Math.PI / 180;

    public function Triangle():void
    {
        var radius:Number;
        x = Math.random() * 465;
        y = Math.random() * 465;
        vx = Math.random() * 2 - 1;
        vy = Math.random() * 2 - 1;

        rv = Triangle._N * Math.random() * 4 - Triangle._N * 2;

        radius = Math.random() * Triangle._RADIUS;
        ax = Math.cos(0 * Triangle._N) * radius;
        ay = Math.sin(0 * Triangle._N) * radius;

        radius = Math.random() * Triangle._RADIUS;
        bx = Math.cos(120 * Triangle._N) * radius;
        by = Math.sin(120 * Triangle._N) * radius;
        
        radius = Math.random() * Triangle._RADIUS;
        cx = Math.cos(240 * Triangle._N) * radius;
        cy = Math.sin(240 * Triangle._N) * radius;

    }

    public var rv:Number;
    public var x:Number;
    public var y:Number;
    public var ax:Number;
    public var ay:Number;
    public var bx:Number;
    public var by:Number;
    public var cx:Number;
    public var cy:Number;
    public var vx:Number;
    public var vy:Number;
    public var color:uint;
}