/**
 * Copyright DLabz ( http://wonderfl.net/user/DLabz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Ohr
 */

// forked from DLabz's forked from: 3d particles forked from: flash on 2009-11-18
// forked from DLabz's 3d particles forked from: flash on 2009-11-18
// forked from littlepad's flash on 2009-11-18

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.StageDisplayState;
    import flash.events.MouseEvent;
  
    public class FlashTest extends Sprite {
        private const WIDTH:Number = 456;
        private const HEIGHT:Number = 456;
        private var radDeg:Number = Math.PI / 180;
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _cTra:ColorTransform;
        private var _rect:Rectangle;
        private var _particles:Array;
        private var _cPoint:Point;
        private var speed:Number;
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            
            
            _rect = new Rectangle(0, 0, WIDTH, HEIGHT);
            _cTra = new ColorTransform(.8, .8, .9, 1);
            _particles = new Array();
            _cPoint = new Point(WIDTH/2, HEIGHT/2);
            
            _canvas = new BitmapData(WIDTH, HEIGHT, false, 0xFF000000);
            addChild(new Bitmap(_canvas));
            
           _glow = new BitmapData(WIDTH/4, HEIGHT/4, false, 0xFF000000);
            var bmp:Bitmap = new Bitmap(_glow, PixelSnapping.NEVER, true);
            bmp.scaleX = bmp.scaleY = 4;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            bmp.addEventListener(MouseEvent.CLICK ,function(e:Event):void{stage.displayState=StageDisplayState.FULL_SCREEN});
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        private function moveParticles ():void{
              for(var i:uint = 0; i < _particles.length; i++){
                    var p:Particle = _particles[i];
                    var radian:Number = Math.atan2( mouseY - p.y, mouseX - p.x );  
                    
                    p.vx +=  5*Math.cos(radian);
                    p.vy +=  5*Math.sin(radian);
                    var radian2:Number = Math.atan2( (p.vx - p.y), _cPoint.x - p.z );
                    p.vz +=  5*Math.cos(radian2);
                    p.vx *= (0.11*(mouseX)/WIDTH)+0.90; 
                    p.vy *= (0.11*(mouseY)/HEIGHT)+0.90;
                    p.vz *= (0.11*(Math.sqrt(mouseX*mouseY))/WIDTH)+0.90;
                    p.x += p.vx;
                    p.y += p.vy;
                    p.z += p.vz;
                    
                   // p.ang = new Point(radian,radian2);
                    
                 
            }
        }
        private function onEnterFrame(e:Event):void {
    
             moveParticles(); 
          
            _particles.sortOn("z", Array.NUMERIC);//pseudo z-sort
          
             for(var i:uint = 0; i < _particles.length; i++){
               var p:Particle = _particles[i];
            // if ( _canvas.getPixel32(p.x+m, p.y+n) <= 0xFFf5f5f5){
               for (var m:int =-p.z/30; m < p.z/50; m++){
                   for  (var n:int = -p.z/30; n < p.z/50; n++){ 
                       _canvas.setPixel32(p.x+m, p.y+n, p.c);//TODO: Project a rectangle in perspective, instead of drawing a square
                   }
               }
             
         //  }
                
              
                if(Math.abs(p.x - mouseX) < 1 && Math.abs(p.y - mouseY) < 1 && Math.abs(p.z - _cPoint.x) < 1) {
                    _particles.splice(i, 1);
                }
                
            }
            
            _glow.draw(_canvas, new Matrix(1/4, 0, 0, 1/4));
                 
          _canvas.colorTransform(_rect, _cTra);
          _canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(40, 40));
        }
        
        private function onTimer(e:TimerEvent):void {
            var n:uint = 1;
            while(n--){
            while(_particles.length < 200) {
                var p:Particle = new Particle();
                p.x =  800 * Math.random();//WIDTH * Math.random();
                p.y = 800 *  Math.random();// HEIGHT * Math.random();
               p.z =  800 * Math.random();;//10 * Math.random();//
               p.c = 0xFFFFFFFF * Math.random();
                _particles.push(p);
               } //
            }
        }
    }
}

internal class Particle {
     import flash.geom.Point;
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var vx:Number;
    public var vy:Number;
    public var vz:Number;
    public var c:Number;
    public var ang:Point;
    public function Particle() {
        x = 0;
        y = 0;
        z = 0;
        vx = 0;
        vy = 0;
        vz = 0;
        c = 0xFFFFFFFF;
    }
}