/**
 * Copyright Dorara ( http://wonderfl.net/user/Dorara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7OT0
 */

package 
{
    import com.bit101.components.*;
    
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
 
    public class Main extends Sprite 
    {
        private const W_WIDTH:int = 465;
        private const W_HEIGHT:int = 465;
        
        private var _canvas_bmp:Bitmap;
        private var bure:BureLines;
        private var _alist:TextArea;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP_LEFT;
            
            //ハイジさんまじぱねぇっす
            var tmpX:Array = [0, 111, 98, 29, 7, 15, 42, 46, 53, 52, 56, 60, 65, 70, 151, 137, 137, 140, 143, 164, 154, 160, 169, 189, 189, 186, 182, 182, 177, 155, 152, 163, 163, 146, 146, 136, 123, 112, 87, 69, 68, 72, 67, 62, 65, 74, 75, 68, 66, 62, 55, 59, 51, 46, 39, 34, 32, 42, 52, 77, 78, 111, 111, 92, 96, 110, 112, 141, 158, 158, 142, 141, 135, 128, 122, 111, 121, 119, 104, 103, 112, 130, 128, 107, 128, 125, 104, 104, 97, 90, 90, 79, 70, 72, 78, 87, 87, 84, 78, 82, 90, 97, 105, 118, 111, 123, 125, 131, 134, 136, 132, 130, 129,
            131,131,128,117,117,126,115,116,106,86,112,122,136,146,198,208,202,225,230,221,237,251,259,244,259,262,273,281,297,301,299,280,275,300,313,328,333,333,326,311,303,336,347,341,349,370,348,336,224,209,222,233,246,233,269,246,259,282,259,253,275,253,257,279,294,290,307,310,324,339,343,360,341,338,372,352,357,373,358,365,381,397,379,387,403,406,397,416,423,436,437,429,415,415,412,415,435,463]; 
            var tmpY:Array = [0, 6, 16, 52, 97, 154, 164, 182, 182, 191, 191, 183, 180, 190, 190, 166, 162, 158, 158, 172, 191, 191, 176, 187, 184, 163, 165, 157, 151, 154, 150, 129, 111, 93, 73, 46, 34, 7, 40, 58, 70, 79, 81, 82, 86, 81, 84, 89, 89, 86, 108, 138, 140, 138, 130, 129, 139, 154, 156, 167, 163, 163, 167, 169, 181, 176, 162, 153, 130, 112, 95, 96, 103, 102, 93, 95, 104, 110, 115, 128, 146, 135, 126, 134, 123, 118, 125, 114, 100, 102, 114, 115, 110, 100, 98, 98, 103, 107, 102, 98, 102, 98, 114, 108, 96, 91, 84, 82, 84, 86,
            91,89,85,79,76,70,71,68,65,63,54,46,42,5,34,46,74,73,21,47,50,25,74,71,27,56,52,58,74,74,27,29,39,48,47,75,73,27,28,36,45,51,47,73,76,49,25,47,30,48,76,119,162,120,161,124,162,163,161,120,123,121,139,141,140,119,122,122,164,122,164,122,122,145,123,144,168,167,167,144,144,143,120,120,120,168,147,147,169,121,121,120,124,134,145,145,121,170,146,168,175]; 
            
            bure = new BureLines(W_WIDTH, W_HEIGHT, tmpX, tmpY);

            _canvas_bmp = bure.drawAllpts();
            this.addChild(_canvas_bmp);
            
            this.stage.addEventListener(MouseEvent.CLICK, onClick);
            this.stage.addEventListener(Event.ENTER_FRAME, drawAllpts);
        }
        
        
        private function drawAllpts(e:Event):void {
            _canvas_bmp = bure.drawAllpts();
        }
        
        private function onClick(e:MouseEvent):void {
            bure.addPoint(mouseX, mouseY);
        }
    }
    
}

import flash.display.*;

class BureLines {
    private var _arrPX:Array;
    private var _arrPY:Array;
    private var C_WIDTH:int = 465;
    private var C_HEIGHT:int = 465;
        
    private var _canvas:BitmapData;
    private var _canvas_bmp:Bitmap;
    
    public function BureLines(width:int, height:int, aPX:Array = null, aPY:Array = null):void {
        C_WIDTH = width;
        C_HEIGHT = height;
        if (aPX == null || aPY == null) {
            _arrPX = new Array();
            _arrPY = new Array();
        } else {
            _arrPX = aPX;
            _arrPY = aPY;
        }
        init();
    }
    
    private function init():void {
        _canvas = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x00000000);
        var bg_sh:Shape = new Shape;
        bg_sh.graphics.beginFill(0x000000);
        bg_sh.graphics.drawRect(0, 0, C_WIDTH, C_HEIGHT);
        bg_sh.graphics.endFill();
        _canvas.draw(bg_sh);
        _canvas_bmp = new Bitmap(_canvas);
    }
    
    public function addPoint(x:int, y:int):void {
        _arrPX.push(x);
        _arrPY.push(y);
    }
    
    public function drawAllpts():Bitmap {
        var bg_sh:Shape = new Shape;
        bg_sh.graphics.beginFill(0x000000);
        bg_sh.graphics.drawRect(0, 0, C_WIDTH, C_HEIGHT);
        bg_sh.graphics.endFill();
        _canvas.draw(bg_sh);
        
        drawPoint(_arrPX[0], _arrPY[0], 2);
        
        for (var i:int = 1; i < _arrPX.length; i++) {
            drawPoint(_arrPX[i], _arrPY[i], 1);
            
            var ex:int = Math.random() * 5 - 2;
            var ey:int = Math.random() * 5 - 2;
            drawLine(_arrPX[i - 1]+ex, _arrPY[i - 1]+ey, _arrPX[i]+ex, _arrPY[i]+ey);
        }
        
        return _canvas_bmp;
    }
    
    private function clear():void {
        _arrPX.length = 0;
        _arrPY.length = 0;
    }
    
    private function drawPoint(x:int, y:int, size:int):void {
        var sh:Shape = new Shape();
        sh.graphics.beginFill(0xffffff);
        sh.graphics.drawRect(x-(int)(size/2), y-(int)(size/2), size, size);
        sh.graphics.endFill();
        _canvas.lock();
        _canvas.draw(sh);
        _canvas.unlock();
    }
        
    private function drawLine(x1:int, y1:int, x2:int, y2:int):void {
        var sh:Shape = new Shape();
        sh.graphics.lineStyle(1, 0xffffff);
        sh.graphics.moveTo(x1, y1);
        sh.graphics.lineTo(x2, y2);
        _canvas.lock();
        _canvas.draw(sh);
        _canvas.unlock();
    }
}