/**
 * Copyright tipein123 ( http://wonderfl.net/user/tipein123 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7NqZ
 */

// forked from tipein123's forked from: ohne rekursion fertig: the house Knotenpunkte
//"     4
//"    / \
//"   2---3
//"   I\ /I
//"   I X I
//"   I/ \I
//"   0---1

package {
    import flash.geom.Point;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.filters.*;
    import flash.text.*;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;


    [SWF(width="500",height="500",backgroundColor="0x000000",frameRate="60")]
    public class FlashTest extends Sprite {
        public function FlashTest() { 
            // write as3 code here..
            
 stage.scaleMode = StageScaleMode.NO_SCALE;
 stage.align = StageAlign.TOP_LEFT;
            
 var tf:TextField = new TextField();
 tf.width = stage.stageWidth;
 tf.height = stage.stageHeight;
 tf.text = "\n\n";
 tf.wordWrap = true;
 tf.multiline = true;
 tf.textColor = 0x00ff00; //0x0000ff wenn nicht schwarz auf schwarz gewünscht wird
 addChild(tf);


 
//geometrische Lage (relativ) der einzelnen Punkte / Position 0 (erstes Paar im Array) entspricht Punkt 0
var Punktarray:Array = new Array ([0,8] , [4,8] , [0,2], [4,2], [2,0]); 

//verschiedene Farben zur besseren Unterscheidung des Verlaufes. Extrafarben für Testzwecke. (eigentlich nur 8 Linien)  
var Farbarray:Array = new Array (0xff33aa,0xffffff,0xffff00,0xff00ff,0x00ffff,0xff0000,0x00ff00,0x0000ff,0x999999 
                                ,0x999900,0x990099,0x009999,0x990000,0x009900,0x000099);
                                
//Knotenpunkte: Knotenarray[0] = grenzt an 1,2,3 / Knotenarray[4] = grenzt an 2,3                                
var Knotenarray:Array = new Array ([1,2,3] , [0,2,3] , [0,1,3,4] , [0,1,2,4] , [2,3]);

//Ein MultiArray KA übergeben in dem ein Knoten entfernt wird
//Über 0'ter Wert von Array-Punkt gibt an welcher Punkt (also z.B.  0'ter [1,2,3], 3'ter[0,1,2,4]... aus Knotenarray)
//Dann nächster Wert im Array-Punkt gibt an, welcher Wert (also Knoten) entfernt werden soll 
//(nicht die Stelle, sondern die Zahl)
//ist dieser Wert nicht enthalten, wird auch nichts gelöscht !
function KnotenEntfernen (KA:Array, Punkt:Array  ):Array
  {
    var NA:Array = new Array();
     
    for(var a:uint = 0; a<KA.length; a++){
        var zwischenArray:Array = new Array();

        for(var i:uint = 0; i<KA[a].length; i++){
            if((a == Punkt[0]) && (KA[a][i] == Punkt[1]))
             {
                 //zwischenArray.push ("X");
             }
            else
             {
                 zwischenArray.push (KA[a][i]);
             }
        }
        NA.push (zwischenArray); 
    }

    return NA;
  }
  
  
  //TEST: manuell Konten entfernen  
  //MultiArrayAusgeben(Knotenarray);
  //  Trennstrich();
  //MultiArrayAusgeben(KnotenEntfernen (Knotenarray ,[1,2])  );
  //  Trennstrich();


//zu Testzwecken noch manuell Züge gepushed
var Zugarray:Array = new Array ();  

/*
Zugarray.push ([0,2,1,3,2,4,3,0,1]);    
Zugarray.push ([0,2,1,3,4,2,3,0,1]);    
Zugarray.push ([0,1,3,2,4,3,0,2,1]);    
Zugarray.push ([0,1,3,4,2,3,0,2,1]);    
Zugarray.push ([0,3,4,2,3,1,2,0,1]);    
Zugarray.push ([0,3,2,4,3,1,2,0,1]);    
Zugarray.push ([0,2,4,3,2,1,0,3,1]);    
Zugarray.push ([0,2,3,4,2,1,0,3,1]);    
Zugarray.push ([0,2,4,3,2,1,3,0,1]);    
Zugarray.push ([0,2,3,4,2,1,3,0,1]);    
Zugarray.push ([0,2,3,1,2,4,3,0,1]);    
*/ 

//Zugarray.push ([0]);  //hier können die einzelnen Punkte angegeben werden (siehe oben)    
//MultiArrayAusgeben(Zugarray);

var Faktor:Number = 10;
var Spalten:int = 11;

var glow:GlowFilter = new GlowFilter(0xff3366,0.6,11,11);


// In Zugarray wird nachher automatisch mit richtigen Lösungen (.length == 8) gepushed
// Dieses kann dann mit ZeichneHaus dargestellt werden. (Faktor und Spalten anpassen, je nach Menge)
//Evtl. muß dies noch jedes mal aufgerufen werden, wenn ein Zug gepushed wurde. (Auch Zugarray.length angeben !)
function Darstellung ():void{
  Davor ("Lösungsmenge: " + Zugarray.length + "\n\n");

  var Stadt:Sprite = new Sprite();
  Stadt.graphics.beginFill(0x000000);
  Stadt.graphics.drawRect(-20,0, 800, 800);
  Stadt.graphics.endFill(); 

  addChild(Stadt);
  
  for(var i:uint = 0; i<Zugarray.length; i++){
    var Haus:Sprite = new Sprite();
    Stadt.addChild(Haus);
    
    Haus.filters = [glow];

    Haus.x = Faktor + ((i%Spalten)*7) *Faktor - Math.floor (i / Spalten);
    Haus.y = Math.floor (i / Spalten) *Faktor *9;
    ZeichneHaus (Haus, Zugarray[i]);
  } 
      
  Stadt.addEventListener(MouseEvent.MOUSE_DOWN, dragHaus);
  Stadt.addEventListener(MouseEvent.MOUSE_UP, stopHaus); 

 }
 
 BerechneHaus ([0]); //ergibt 44
 BerechneHaus ([1]); //ergibt 44 weiter (gespiegelt)  
 BerechneHaus ([2]); //keine weiteren
 BerechneHaus ([3]); //keine weiteren  
 BerechneHaus ([4]); //keine weiteren  
  
 Darstellung(); 

// Zeichnet für Darstellung(); jeweils ein Haus laut Zugfolge in Zugarray[i]     
function  ZeichneHaus (Sp:Sprite , Liste:Array):void{
    var KnotenarrayKopie:Array = Knotenarray; 
    Sp.graphics.clear(); 
    //Trennstrich ("Startwert");
    //MultiArrayAusgeben(KnotenarrayKopie);

    Sp.graphics.lineStyle(1, Farbarray[0]);
    Sp.graphics.drawCircle(Punktarray[Liste[0]] [0] *Faktor,Punktarray[Liste[0]] [1] *Faktor, Faktor/3);

    Sp.graphics.lineStyle(1, Farbarray[1]);
    Sp.graphics.moveTo(Punktarray[Liste[0]] [0] *Faktor,Punktarray[Liste[0]] [1] *Faktor);
    for(var i:uint = 1; i<Liste.length; i++){
      var zielpunkt:uint = Liste [i];
      Sp.graphics.lineStyle(1, Farbarray[i]); 
      Sp.graphics.lineTo(Punktarray[zielpunkt] [0] *Faktor + i *Faktor*0.11,Punktarray[zielpunkt] [1] *Faktor + i *Faktor*0.1);
       
      KnotenarrayKopie = KnotenEntfernen(KnotenarrayKopie,[Liste [i-1],Liste [i]]); //der TO-Punkt wird aus dem Davor entfernt!
      KnotenarrayKopie = KnotenEntfernen(KnotenarrayKopie,[Liste [i],Liste [i-1]]); //und umgekehrt!
      
      /*
      Trennstrich ("Durchgang: "+i); 
      MultiArrayAusgeben(KnotenarrayKopie);  
      Ausgabe("In "+Liste [i-1]+" die "+Liste[i]+" entfernen. ");
      Ausgabe("\nUnd in "+Liste [i]+" die "+Liste[i-1]+" entfernen. ");
      Ausgabe("\n==> "+Liste);
      if(i==8)
        {
            Ausgabe("\n!!! Gelöst !!!");
            //Zugarray.push (Liste); //Diesen Zug hinzufügen 
        }
      Ausgabe (" L:"+KnotenarrayKopie[Liste [i]]);
      //if(KnotenarrayKopie[Liste [i]].length < 1){Ausgabe("\nKeine weiteren Züge möglich!");}
     
     */
    }  

    var wohin:int = Liste[(Liste.length)-1]; 
    for(var a:uint = 0; a<KnotenarrayKopie[wohin].length; a++){
      Sp.graphics.lineStyle(2, Farbarray[1]);
      Sp.graphics.drawCircle(Punktarray[KnotenarrayKopie[wohin][a]] [0] *Faktor,Punktarray[KnotenarrayKopie[wohin][a]] [1] *Faktor, Faktor/4);
    }
      //Trennstrich ("Mögliche Lösungszüge:"); 
      //MultiArrayAusgeben(Zugarray);  

}

//dies wird die Rekursive Funktion, die Zugarray mit möglichen Zügen füllt
//Alle Zeichenbefehle raus !
//Muß am Anfang für alle Punkte 0-4 aufgerufen werden !
//Zu Testzwecken wohl erst mal nur Punkt 0. 
function BerechneHaus (Liste:Array):void
  {
    var KnotenarrayKopie:Array = Knotenarray; 

    for(var i:uint = 1; i<Liste.length; i++){
      var zielpunkt:uint = Liste [i];

       
      KnotenarrayKopie = KnotenEntfernen(KnotenarrayKopie,[Liste [i-1],Liste [i]]); //der TO-Punkt wird aus dem Davor entfernt!
      KnotenarrayKopie = KnotenEntfernen(KnotenarrayKopie,[Liste [i],Liste [i-1]]); //und umgekehrt!
      
      if(KnotenarrayKopie[Liste [i]].length < 1){Ausgabe("\n---Keine weiteren Züge möglich!---"+i+"--");}

      if(i==8)
        {
            Ausgabe("\n!!! Gelöst !!!");
            Zugarray.push (Liste); //Diesen Zug hinzufügen 
            Davor (Zugarray.length+") "+Liste+" /   ");  
        }
    }


    var wohin:int = Liste[(Liste.length)-1]; 
    Ausgabe ("\nFür "+Liste+" mögliche Züge: ");
    for(var a:uint = 0; a<KnotenarrayKopie[wohin].length; a++){
      var RekuWeg:Array = new Array();
      for (var ii:uint = 0; ii<Liste.length; ii++){
          RekuWeg.push (Liste[ii]);  
      } 

      RekuWeg.push(KnotenarrayKopie[wohin][a]);
      Ausgabe (RekuWeg + "(" + Liste + ")" + " / "); //Liste.push (KnotenarrayKopie[wohin][a]) + " / "
      
      BerechneHaus(RekuWeg); //hier ist die eigentliche Rekursion !!!!  
      
    }

  }


function MultiArrayAusgeben (AR:Array):void
  {
      for (var i:uint = 0; i<AR.length; i++)
       {
           tf.appendText("\n");
           for (var a:uint = 0; a<AR[i].length; a++)
             {
                 tf.appendText(AR[i][a]+" ");
             }
       }
       tf.appendText("\n");
  }
  
 function Trennstrich (tx:String):void
  {
      tf.appendText("\n---------------");
      tf.appendText(tx); 
      tf.appendText("----------------\n");
  }
  
  function Ausgabe (tx:String):void
   {
      tf.appendText(tx); 
   }

  function Davor (tx:String):void
   {
      tf.text = tx + tf.text;
   }
   
  function dragHaus(e:MouseEvent):void{
    //e.target.startDrag();
    e.target.startDrag();
  }
  function stopHaus(e:MouseEvent):void{
    //e.target.stopDrag();
    e.target.stopDrag();
  }

            
        }
    }
}